/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class WaterFluid
extends FlowingFluid {
    @Override
    public Fluid func_210197_e() {
        return Fluids.field_207212_b;
    }

    @Override
    public Fluid func_210198_f() {
        return Fluids.field_204546_a;
    }

    @Override
    public Item func_204524_b() {
        return Items.field_151131_as;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World worldIn, BlockPos pos, FluidState state, Random random) {
        if (!state.func_206889_d() && !((Boolean)state.func_177229_b((Property)field_207209_a)).booleanValue()) {
            if (random.nextInt(64) == 0) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197605_P, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData func_204521_c() {
        return ParticleTypes.field_197618_k;
    }

    @Override
    protected boolean func_205579_d() {
        return true;
    }

    @Override
    protected void func_205580_a(IWorld worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = state.hasTileEntity() ? worldIn.func_175625_s(pos) : null;
        Block.func_220059_a(state, worldIn, pos, tileentity);
    }

    @Override
    public int func_185698_b(IWorldReader worldIn) {
        return 4;
    }

    @Override
    public BlockState func_204527_a(FluidState state) {
        return (BlockState)((Object)Blocks.field_150355_j.func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, Integer.valueOf(WaterFluid.func_207205_e(state))));
    }

    @Override
    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == Fluids.field_204546_a || fluidIn == Fluids.field_207212_b;
    }

    @Override
    public int func_204528_b(IWorldReader worldIn) {
        return 1;
    }

    @Override
    public int func_205569_a(IWorldReader p_205569_1_) {
        return 5;
    }

    @Override
    public boolean func_215665_a(FluidState p_215665_1_, IBlockReader p_215665_2_, BlockPos p_215665_3_, Fluid p_215665_4_, Direction p_215665_5_) {
        return p_215665_5_ == Direction.DOWN && !p_215665_4_.func_207185_a(FluidTags.field_206959_a);
    }

    @Override
    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Source
    extends WaterFluid {
        @Override
        public int func_207192_d(FluidState p_207192_1_) {
            return 8;
        }

        @Override
        public boolean func_207193_c(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends WaterFluid {
        @Override
        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        @Override
        public int func_207192_d(FluidState p_207192_1_) {
            return (Integer)p_207192_1_.func_177229_b((Property)field_207210_b);
        }

        @Override
        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }
}

