/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math.vector;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Vector4f {
    private float field_229368_a_;
    private float field_229369_b_;
    private float field_229370_c_;
    private float field_229371_d_;

    public Vector4f() {
    }

    public Vector4f(float x, float y, float z, float w) {
        this.field_229368_a_ = x;
        this.field_229369_b_ = y;
        this.field_229370_c_ = z;
        this.field_229371_d_ = w;
    }

    public Vector4f(Vector3f vectorIn) {
        this(vectorIn.func_195899_a(), vectorIn.func_195900_b(), vectorIn.func_195902_c(), 1.0f);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ != null && this.getClass() == p_equals_1_.getClass()) {
            Vector4f vector4f = (Vector4f)p_equals_1_;
            if (Float.compare(vector4f.field_229368_a_, this.field_229368_a_) != 0) {
                return false;
            }
            if (Float.compare(vector4f.field_229369_b_, this.field_229369_b_) != 0) {
                return false;
            }
            if (Float.compare(vector4f.field_229370_c_, this.field_229370_c_) != 0) {
                return false;
            }
            return Float.compare(vector4f.field_229371_d_, this.field_229371_d_) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.field_229368_a_);
        i = 31 * i + Float.floatToIntBits(this.field_229369_b_);
        i = 31 * i + Float.floatToIntBits(this.field_229370_c_);
        return 31 * i + Float.floatToIntBits(this.field_229371_d_);
    }

    public float func_195910_a() {
        return this.field_229368_a_;
    }

    public float func_195913_b() {
        return this.field_229369_b_;
    }

    public float func_195914_c() {
        return this.field_229370_c_;
    }

    public float func_195915_d() {
        return this.field_229371_d_;
    }

    public void func_195909_a(Vector3f vec) {
        this.field_229368_a_ *= vec.func_195899_a();
        this.field_229369_b_ *= vec.func_195900_b();
        this.field_229370_c_ *= vec.func_195902_c();
    }

    public void func_195911_a(float x, float y, float z, float w) {
        this.field_229368_a_ = x;
        this.field_229369_b_ = y;
        this.field_229370_c_ = z;
        this.field_229371_d_ = w;
    }

    public float func_229373_a_(Vector4f vectorIn) {
        return this.field_229368_a_ * vectorIn.field_229368_a_ + this.field_229369_b_ * vectorIn.field_229369_b_ + this.field_229370_c_ * vectorIn.field_229370_c_ + this.field_229371_d_ * vectorIn.field_229371_d_;
    }

    public boolean func_229374_e_() {
        float f = this.field_229368_a_ * this.field_229368_a_ + this.field_229369_b_ * this.field_229369_b_ + this.field_229370_c_ * this.field_229370_c_ + this.field_229371_d_ * this.field_229371_d_;
        if ((double)f < 1.0E-5) {
            return false;
        }
        float f1 = MathHelper.func_226165_i_((float)f);
        this.field_229368_a_ *= f1;
        this.field_229369_b_ *= f1;
        this.field_229370_c_ *= f1;
        this.field_229371_d_ *= f1;
        return true;
    }

    public void func_229372_a_(Matrix4f matrixIn) {
        float f = this.field_229368_a_;
        float f1 = this.field_229369_b_;
        float f2 = this.field_229370_c_;
        float f3 = this.field_229371_d_;
        this.field_229368_a_ = matrixIn.field_226575_a_ * f + matrixIn.field_226576_b_ * f1 + matrixIn.field_226577_c_ * f2 + matrixIn.field_226578_d_ * f3;
        this.field_229369_b_ = matrixIn.field_226579_e_ * f + matrixIn.field_226580_f_ * f1 + matrixIn.field_226581_g_ * f2 + matrixIn.field_226582_h_ * f3;
        this.field_229370_c_ = matrixIn.field_226583_i_ * f + matrixIn.field_226584_j_ * f1 + matrixIn.field_226585_k_ * f2 + matrixIn.field_226586_l_ * f3;
        this.field_229371_d_ = matrixIn.field_226587_m_ * f + matrixIn.field_226588_n_ * f1 + matrixIn.field_226589_o_ * f2 + matrixIn.field_226590_p_ * f3;
    }

    public void func_195912_a(Quaternion quaternionIn) {
        Quaternion quaternion = new Quaternion(quaternionIn);
        quaternion.func_195890_a(new Quaternion(this.func_195910_a(), this.func_195913_b(), this.func_195914_c(), 0.0f));
        Quaternion quaternion1 = new Quaternion(quaternionIn);
        quaternion1.func_195892_e();
        quaternion.func_195890_a(quaternion1);
        this.func_195911_a(quaternion.func_195889_a(), quaternion.func_195891_b(), quaternion.func_195893_c(), this.func_195915_d());
    }

    public void func_229375_f_() {
        this.field_229368_a_ /= this.field_229371_d_;
        this.field_229369_b_ /= this.field_229371_d_;
        this.field_229370_c_ /= this.field_229371_d_;
        this.field_229371_d_ = 1.0f;
    }

    public String toString() {
        return "[" + this.field_229368_a_ + ", " + this.field_229369_b_ + ", " + this.field_229370_c_ + ", " + this.field_229371_d_ + "]";
    }

    public void set(float[] values) {
        this.field_229368_a_ = values[0];
        this.field_229369_b_ = values[1];
        this.field_229370_c_ = values[2];
        this.field_229371_d_ = values[3];
    }

    public void setX(float x) {
        this.field_229368_a_ = x;
    }

    public void setY(float y) {
        this.field_229369_b_ = y;
    }

    public void setZ(float z) {
        this.field_229370_c_ = z;
    }

    public void setW(float z) {
        this.field_229371_d_ = z;
    }
}

