/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.registry;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DelegatingDynamicOps;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenSettingsExport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldSettingsImport<T>
extends DelegatingDynamicOps<T> {
    private static final Logger field_240870_b_ = LogManager.getLogger();
    private final IResourceAccess field_244332_c;
    private final DynamicRegistries.Impl field_240872_d_;
    private final Map<RegistryKey<? extends Registry<?>>, ResultMap<?>> field_240873_e_;
    private final WorldSettingsImport<JsonElement> field_244333_f;

    public static <T> WorldSettingsImport<T> func_244335_a(DynamicOps<T> p_244335_0_, IResourceManager p_244335_1_, DynamicRegistries.Impl p_244335_2_) {
        return WorldSettingsImport.func_244336_a(p_244335_0_, IResourceAccess.func_244345_a(p_244335_1_), p_244335_2_);
    }

    public static <T> WorldSettingsImport<T> func_244336_a(DynamicOps<T> p_244336_0_, IResourceAccess p_244336_1_, DynamicRegistries.Impl p_244336_2_) {
        WorldSettingsImport<T> worldsettingsimport = new WorldSettingsImport<T>(p_244336_0_, p_244336_1_, p_244336_2_, Maps.newIdentityHashMap());
        DynamicRegistries.func_243608_a((DynamicRegistries.Impl)p_244336_2_, worldsettingsimport);
        return worldsettingsimport;
    }

    private WorldSettingsImport(DynamicOps<T> p_i242092_1_, IResourceAccess p_i242092_2_, DynamicRegistries.Impl p_i242092_3_, IdentityHashMap<RegistryKey<? extends Registry<?>>, ResultMap<?>> p_i242092_4_) {
        super(p_i242092_1_);
        this.field_244332_c = p_i242092_2_;
        this.field_240872_d_ = p_i242092_3_;
        this.field_240873_e_ = p_i242092_4_;
        this.field_244333_f = p_i242092_1_ == JsonOps.INSTANCE ? this : new WorldSettingsImport<T>(JsonOps.INSTANCE, p_i242092_2_, p_i242092_3_, (IdentityHashMap<RegistryKey<Registry<?>>, ResultMap<?>>)p_i242092_4_);
    }

    protected <E> DataResult<Pair<java.util.function.Supplier<E>, T>> func_241802_a_(T p_241802_1_, RegistryKey<? extends Registry<E>> p_241802_2_, Codec<E> p_241802_3_, boolean p_241802_4_) {
        Optional optional = this.field_240872_d_.func_230521_a_(p_241802_2_);
        if (!optional.isPresent()) {
            return DataResult.error((String)("Unknown registry: " + p_241802_2_));
        }
        MutableRegistry mutableregistry = (MutableRegistry)optional.get();
        DataResult dataresult = ResourceLocation.field_240908_a_.decode(this.field_240857_a_, p_241802_1_);
        if (!dataresult.result().isPresent()) {
            return !p_241802_4_ ? DataResult.error((String)"Inline definitions not allowed here") : p_241802_3_.decode((DynamicOps)this, p_241802_1_).map(p_240874_0_ -> p_240874_0_.mapFirst(p_240891_0_ -> () -> p_240891_0_));
        }
        Pair pair = (Pair)dataresult.result().get();
        ResourceLocation resourcelocation = (ResourceLocation)pair.getFirst();
        return this.func_241805_a_(p_241802_2_, mutableregistry, p_241802_3_, resourcelocation).map(p_240875_1_ -> Pair.of((Object)p_240875_1_, (Object)pair.getSecond()));
    }

    public <E> DataResult<SimpleRegistry<E>> func_241797_a_(SimpleRegistry<E> p_241797_1_, RegistryKey<? extends Registry<E>> p_241797_2_, Codec<E> p_241797_3_) {
        Collection<ResourceLocation> collection = this.field_244332_c.func_241880_a(p_241797_2_);
        DataResult dataresult = DataResult.success(p_241797_1_, (Lifecycle)Lifecycle.stable());
        String s = p_241797_2_.func_240901_a_().func_110623_a() + "/";
        for (ResourceLocation resourcelocation : collection) {
            String s1 = resourcelocation.func_110623_a();
            if (!s1.endsWith(".json")) {
                field_240870_b_.warn("Skipping resource {} since it is not a json file", (Object)resourcelocation);
                continue;
            }
            if (!s1.startsWith(s)) {
                field_240870_b_.warn("Skipping resource {} since it does not have a registry name prefix", (Object)resourcelocation);
                continue;
            }
            String s2 = s1.substring(s.length(), s1.length() - ".json".length());
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s2);
            dataresult = dataresult.flatMap(p_240885_4_ -> this.func_241805_a_(p_241797_2_, (MutableRegistry)p_240885_4_, p_241797_3_, resourcelocation1).map(p_240877_1_ -> p_240885_4_));
        }
        return dataresult.setPartial(p_241797_1_);
    }

    private <E> DataResult<java.util.function.Supplier<E>> func_241805_a_(RegistryKey<? extends Registry<E>> p_241805_1_, MutableRegistry<E> p_241805_2_, Codec<E> p_241805_3_, ResourceLocation p_241805_4_) {
        RegistryKey registrykey = RegistryKey.func_240903_a_(p_241805_1_, p_241805_4_);
        ResultMap<E> resultmap = this.func_240884_a_(p_241805_1_);
        DataResult dataresult = (DataResult)((ResultMap)resultmap).field_240893_a_.get(registrykey);
        if (dataresult != null) {
            return dataresult;
        }
        Supplier supplier = Suppliers.memoize(() -> {
            Object e = p_241805_2_.func_230516_a_(registrykey);
            if (e == null) {
                throw new RuntimeException("Error during recursive registry parsing, element resolved too early: " + registrykey);
            }
            return e;
        });
        ((ResultMap)resultmap).field_240893_a_.put(registrykey, DataResult.success((Object)supplier));
        DataResult dataresult1 = this.field_244332_c.func_241879_a((DynamicOps<JsonElement>)this.field_244333_f, p_241805_1_, registrykey, p_241805_3_);
        Optional optional = dataresult1.result();
        if (optional.isPresent()) {
            Pair pair = (Pair)optional.get();
            p_241805_2_.func_241874_a((OptionalInt)pair.getSecond(), registrykey, pair.getFirst(), dataresult1.lifecycle());
        }
        DataResult dataresult2 = !optional.isPresent() && p_241805_2_.func_230516_a_(registrykey) != null ? DataResult.success(() -> p_241805_2_.func_230516_a_(registrykey), (Lifecycle)Lifecycle.stable()) : dataresult1.map(p_244339_2_ -> () -> p_241805_2_.func_230516_a_(registrykey));
        ((ResultMap)resultmap).field_240893_a_.put(registrykey, dataresult2);
        return dataresult2;
    }

    private <E> ResultMap<E> func_240884_a_(RegistryKey<? extends Registry<E>> p_240884_1_) {
        return this.field_240873_e_.computeIfAbsent(p_240884_1_, p_244344_0_ -> new ResultMap());
    }

    protected <E> DataResult<Registry<E>> func_244340_a(RegistryKey<? extends Registry<E>> p_244340_1_) {
        return this.field_240872_d_.func_230521_a_(p_244340_1_).map(p_244337_0_ -> DataResult.success((Object)p_244337_0_, (Lifecycle)p_244337_0_.func_241875_b())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + p_244340_1_)));
    }

    static final class ResultMap<E> {
        private final Map<RegistryKey<E>, DataResult<java.util.function.Supplier<E>>> field_240893_a_ = Maps.newIdentityHashMap();

        private ResultMap() {
        }
    }

    public static interface IResourceAccess {
        public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> var1);

        public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> var1, RegistryKey<? extends Registry<E>> var2, RegistryKey<E> var3, Decoder<E> var4);

        public static IResourceAccess func_244345_a(final IResourceManager p_244345_0_) {
            return new IResourceAccess(){

                @Override
                public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> p_241880_1_) {
                    return p_244345_0_.func_199003_a(p_241880_1_.func_240901_a_().func_110623_a(), p_244348_0_ -> p_244348_0_.endsWith(".json"));
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> p_241879_1_, RegistryKey<? extends Registry<E>> p_241879_2_, RegistryKey<E> p_241879_3_, Decoder<E> p_241879_4_) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                public String toString() {
                    return "ResourceAccess[" + p_244345_0_ + "]";
                }

                private static /* synthetic */ Pair lambda$func_241879_a$1(Object p_244347_0_) {
                    return Pair.of((Object)p_244347_0_, (Object)OptionalInt.empty());
                }
            };
        }

        public static final class RegistryAccess
        implements IResourceAccess {
            private final Map<RegistryKey<?>, JsonElement> field_244349_a = Maps.newIdentityHashMap();
            private final Object2IntMap<RegistryKey<?>> field_244350_b = new Object2IntOpenCustomHashMap(Util.func_212443_g());
            private final Map<RegistryKey<?>, Lifecycle> field_244351_c = Maps.newIdentityHashMap();

            public <E> void func_244352_a(DynamicRegistries.Impl p_244352_1_, RegistryKey<E> p_244352_2_, Encoder<E> p_244352_3_, int p_244352_4_, E p_244352_5_, Lifecycle p_244352_6_) {
                DataResult dataresult = p_244352_3_.encodeStart((DynamicOps)WorldGenSettingsExport.func_240896_a_((DynamicOps)JsonOps.INSTANCE, (DynamicRegistries)p_244352_1_), p_244352_5_);
                Optional optional = dataresult.error();
                if (optional.isPresent()) {
                    field_240870_b_.error("Error adding element: {}", (Object)((DataResult.PartialResult)optional.get()).message());
                } else {
                    this.field_244349_a.put(p_244352_2_, (JsonElement)dataresult.result().get());
                    this.field_244350_b.put(p_244352_2_, p_244352_4_);
                    this.field_244351_c.put(p_244352_2_, p_244352_6_);
                }
            }

            @Override
            public Collection<ResourceLocation> func_241880_a(RegistryKey<? extends Registry<?>> p_241880_1_) {
                return this.field_244349_a.keySet().stream().filter(p_244355_1_ -> p_244355_1_.func_244356_a(p_241880_1_)).map(p_244354_1_ -> new ResourceLocation(p_244354_1_.func_240901_a_().func_110624_b(), p_241880_1_.func_240901_a_().func_110623_a() + "/" + p_244354_1_.func_240901_a_().func_110623_a() + ".json")).collect(Collectors.toList());
            }

            @Override
            public <E> DataResult<Pair<E, OptionalInt>> func_241879_a(DynamicOps<JsonElement> p_241879_1_, RegistryKey<? extends Registry<E>> p_241879_2_, RegistryKey<E> p_241879_3_, Decoder<E> p_241879_4_) {
                JsonElement jsonelement = this.field_244349_a.get(p_241879_3_);
                if (jsonelement != null) {
                    jsonelement.getAsJsonObject().addProperty("forge:registry_name", p_241879_3_.func_240901_a_().toString());
                }
                return jsonelement == null ? DataResult.error((String)("Unknown element: " + p_241879_3_)) : p_241879_4_.parse(p_241879_1_, (Object)jsonelement).setLifecycle(this.field_244351_c.get(p_241879_3_)).map(p_244353_2_ -> Pair.of((Object)p_244353_2_, (Object)OptionalInt.of(this.field_244350_b.getInt((Object)p_241879_3_))));
            }
        }
    }
}

