/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerProfileCache {
    private static final Logger field_242114_a = LogManager.getLogger();
    private static boolean field_187322_c;
    private final Map<String, ProfileEntry> field_152661_c = Maps.newConcurrentMap();
    private final Map<UUID, ProfileEntry> field_152662_d = Maps.newConcurrentMap();
    private final GameProfileRepository field_187323_g;
    private final Gson field_152660_b = new GsonBuilder().create();
    private final File field_152665_g;
    private final AtomicLong field_242115_h = new AtomicLong();

    public PlayerProfileCache(GameProfileRepository gameProfileRepository, File file) {
        this.field_187323_g = gameProfileRepository;
        this.field_152665_g = file;
        Lists.reverse(this.func_242116_a()).forEach(this::func_242118_a);
    }

    private void func_242118_a(ProfileEntry profileEntry) {
        GameProfile gameProfile = profileEntry.func_152668_a();
        profileEntry.func_242126_a(this.func_242123_d());
        String \u26032 = gameProfile.getName();
        if (\u26032 != null) {
            this.field_152661_c.put(\u26032.toLowerCase(Locale.ROOT), profileEntry);
        }
        if ((\u2603 = gameProfile.getId()) != null) {
            this.field_152662_d.put(\u2603, profileEntry);
        }
    }

    @Nullable
    private static GameProfile func_187319_a(GameProfileRepository gameProfileRepository, String string) {
        final AtomicReference atomicReference = new AtomicReference();
        ProfileLookupCallback \u26032 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                atomicReference.set(gameProfile);
            }

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                atomicReference.set(null);
            }
        };
        gameProfileRepository.findProfilesByNames(new String[]{string}, Agent.MINECRAFT, \u26032);
        GameProfile \u26033 = (GameProfile)atomicReference.get();
        if (!PlayerProfileCache.func_187321_d() && \u26033 == null) {
            UUID uUID = PlayerEntity.func_146094_a(new GameProfile(null, string));
            \u26033 = new GameProfile(uUID, string);
        }
        return \u26033;
    }

    public static void func_187320_a(boolean bl) {
        field_187322_c = bl;
    }

    private static boolean func_187321_d() {
        return field_187322_c;
    }

    public void func_152649_a(GameProfile gameProfile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date \u26032 = calendar.getTime();
        ProfileEntry \u26033 = new ProfileEntry(gameProfile, \u26032);
        this.func_242118_a(\u26033);
        this.func_152658_c();
    }

    private long func_242123_d() {
        return this.field_242115_h.incrementAndGet();
    }

    @Nullable
    public GameProfile func_152655_a(String string) {
        GameProfile \u26033;
        string2 = string.toLowerCase(Locale.ROOT);
        ProfileEntry profileEntry = this.field_152661_c.get(string2);
        boolean \u26032 = false;
        if (profileEntry != null && new Date().getTime() >= profileEntry.field_152673_c.getTime()) {
            this.field_152662_d.remove(profileEntry.func_152668_a().getId());
            this.field_152661_c.remove(profileEntry.func_152668_a().getName().toLowerCase(Locale.ROOT));
            \u26032 = true;
            profileEntry = null;
        }
        if (profileEntry != null) {
            profileEntry.func_242126_a(this.func_242123_d());
            \u26033 = profileEntry.func_152668_a();
        } else {
            String string2;
            \u26033 = PlayerProfileCache.func_187319_a(this.field_187323_g, string2);
            if (\u26033 != null) {
                this.func_152649_a(\u26033);
                \u26032 = false;
            }
        }
        if (\u26032) {
            this.func_152658_c();
        }
        return \u26033;
    }

    @Nullable
    public GameProfile func_152652_a(UUID uUID) {
        ProfileEntry profileEntry = this.field_152662_d.get(uUID);
        if (profileEntry == null) {
            return null;
        }
        profileEntry.func_242126_a(this.func_242123_d());
        return profileEntry.func_152668_a();
    }

    private static DateFormat func_242124_e() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ProfileEntry> func_242116_a() {
        ArrayList arrayList = Lists.newArrayList();
        try (BufferedReader bufferedReader2 = Files.newReader((File)this.field_152665_g, (Charset)StandardCharsets.UTF_8);){
            JsonArray jsonArray = (JsonArray)this.field_152660_b.fromJson((Reader)bufferedReader2, JsonArray.class);
            if (jsonArray == null) {
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            DateFormat \u26032 = PlayerProfileCache.func_242124_e();
            jsonArray.forEach(jsonElement -> {
                ProfileEntry profileEntry = PlayerProfileCache.func_242121_a(jsonElement, \u26032);
                if (profileEntry != null) {
                    arrayList.add(profileEntry);
                }
            });
            return arrayList;
        }
        catch (FileNotFoundException bufferedReader2) {
            return arrayList;
        }
        catch (JsonParseException | IOException throwable) {
            field_242114_a.warn("Failed to load profile cache {}", (Object)this.field_152665_g, (Object)throwable);
        }
        return arrayList;
    }

    public void func_152658_c() {
        JsonArray jsonArray = new JsonArray();
        DateFormat \u26032 = PlayerProfileCache.func_242124_e();
        this.func_242117_a(1000).forEach(profileEntry -> jsonArray.add(PlayerProfileCache.func_242119_a(profileEntry, \u26032)));
        String \u26033 = this.field_152660_b.toJson((JsonElement)jsonArray);
        try (BufferedWriter bufferedWriter = Files.newWriter((File)this.field_152665_g, (Charset)StandardCharsets.UTF_8);){
            bufferedWriter.write(\u26033);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<ProfileEntry> func_242117_a(int n) {
        return ImmutableList.copyOf(this.field_152662_d.values()).stream().sorted(Comparator.comparing(ProfileEntry::func_242128_c).reversed()).limit(n);
    }

    private static JsonElement func_242119_a(ProfileEntry profileEntry, DateFormat dateFormat) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", profileEntry.func_152668_a().getName());
        UUID \u26032 = profileEntry.func_152668_a().getId();
        jsonObject.addProperty("uuid", \u26032 == null ? "" : \u26032.toString());
        jsonObject.addProperty("expiresOn", dateFormat.format(profileEntry.func_152670_b()));
        return jsonObject;
    }

    @Nullable
    private static ProfileEntry func_242121_a(JsonElement jsonElement, DateFormat dateFormat) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement \u26032 = jsonObject.get("name");
            JsonElement \u26033 = jsonObject.get("uuid");
            JsonElement \u26034 = jsonObject.get("expiresOn");
            if (\u26032 == null || \u26033 == null) {
                return null;
            }
            String \u26035 = \u26033.getAsString();
            String \u26036 = \u26032.getAsString();
            Date \u26037 = null;
            if (\u26034 != null) {
                try {
                    \u26037 = dateFormat.parse(\u26034.getAsString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (\u26036 == null || \u26035 == null || \u26037 == null) {
                return null;
            }
            try {
                UUID uUID = UUID.fromString(\u26035);
            }
            catch (Throwable throwable) {
                return null;
            }
            return new ProfileEntry(new GameProfile(uUID, \u26036), \u26037);
        }
        return null;
    }

    static class ProfileEntry {
        private final GameProfile field_152672_b;
        private final Date field_152673_c;
        private volatile long field_242125_c;

        private ProfileEntry(GameProfile gameProfile, Date date) {
            this.field_152672_b = gameProfile;
            this.field_152673_c = date;
        }

        public GameProfile func_152668_a() {
            return this.field_152672_b;
        }

        public Date func_152670_b() {
            return this.field_152673_c;
        }

        public void func_242126_a(long l) {
            this.field_242125_c = l;
        }

        public long func_242128_c() {
            return this.field_242125_c;
        }
    }
}

