/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvRow;
import de.siegmar.fastcsv.reader.RowReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CsvParser
implements Closeable {
    private final RowReader rowReader;
    private final boolean containsHeader;
    private final boolean skipEmptyRows;
    private final boolean errorOnDifferentFieldCount;
    private Map<String, Integer> headerMap;
    private List<String> headerList;
    private long lineNo;
    private int firstLineFieldCount = -1;

    CsvParser(Reader reader, char fieldSeparator, char textDelimiter, boolean containsHeader, boolean skipEmptyRows, boolean errorOnDifferentFieldCount) {
        this.rowReader = new RowReader(reader, fieldSeparator, textDelimiter);
        this.containsHeader = containsHeader;
        this.skipEmptyRows = skipEmptyRows;
        this.errorOnDifferentFieldCount = errorOnDifferentFieldCount;
    }

    public List<String> getHeader() {
        if (!this.containsHeader) {
            throw new IllegalStateException("No header available - header parsing is disabled");
        }
        if (this.lineNo == 0L) {
            throw new IllegalStateException("No header available - call nextRow() first");
        }
        return this.headerList;
    }

    public CsvRow nextRow() throws IOException {
        while (!this.rowReader.isFinished()) {
            long startingLineNo = this.lineNo + 1L;
            RowReader.Line line = this.rowReader.readLine();
            String[] currentFields = line.getFields();
            this.lineNo += (long)line.getLines();
            int fieldCount = currentFields.length;
            if (fieldCount == 0) break;
            if (this.skipEmptyRows && fieldCount == 1 && currentFields[0].isEmpty()) continue;
            if (this.errorOnDifferentFieldCount) {
                if (this.firstLineFieldCount == -1) {
                    this.firstLineFieldCount = fieldCount;
                } else if (fieldCount != this.firstLineFieldCount) {
                    throw new IOException(String.format("Line %d has %d fields, but first line has %d fields", this.lineNo, fieldCount, this.firstLineFieldCount));
                }
            }
            List<String> fieldList = Arrays.asList(currentFields);
            if (this.containsHeader && this.headerList == null) {
                this.initHeader(fieldList);
                continue;
            }
            return new CsvRow(startingLineNo, this.headerMap, fieldList);
        }
        return null;
    }

    private void initHeader(List<String> currentFields) {
        this.headerList = Collections.unmodifiableList(currentFields);
        LinkedHashMap<String, Integer> localHeaderMap = new LinkedHashMap<String, Integer>(currentFields.size());
        for (int i = 0; i < currentFields.size(); ++i) {
            String field = currentFields.get(i);
            if (field == null || field.isEmpty() || localHeaderMap.containsKey(field)) continue;
            localHeaderMap.put(field, i);
        }
        this.headerMap = Collections.unmodifiableMap(localHeaderMap);
    }

    @Override
    public void close() throws IOException {
        this.rowReader.close();
    }
}

