/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Cache> field_210267_b = ThreadLocal.withInitial(() -> new Cache());

    public BlockModelRenderer(BlockColors blockColorsIn) {
        this.field_187499_a = blockColorsIn;
    }

    @Deprecated
    public boolean func_228802_a_(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModel(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag = Minecraft.func_71379_u() && stateIn.getLightValue((IBlockReader)worldIn, posIn) == 0 && modelIn.func_177555_b();
        Vector3d vector3d = stateIn.func_191059_e((IBlockReader)worldIn, posIn);
        matrixIn.func_227861_a_(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
        modelData = modelIn.getModelData(worldIn, posIn, stateIn, modelData);
        try {
            return flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, posIn, stateIn);
            crashreportcategory.func_71507_a("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    public boolean func_228805_b_(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelSmooth(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag = false;
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
        for (Direction direction : Direction.values()) {
            randomIn.setSeed(rand);
            List list = modelIn.getQuads(stateIn, direction, randomIn, modelData);
            if (list.isEmpty() || checkSides && !Block.func_176225_a(stateIn, (IBlockReader)worldIn, posIn, direction)) continue;
            this.func_228799_a_(worldIn, stateIn, posIn, matrixStackIn, buffer, list, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlayIn);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.getQuads(stateIn, null, randomIn, modelData);
        if (!list1.isEmpty()) {
            this.func_228799_a_(worldIn, stateIn, posIn, matrixStackIn, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface, combinedOverlayIn);
            flag = true;
        }
        return flag;
    }

    @Deprecated
    public boolean func_228806_c_(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn) {
        return this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixStackIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelFlat(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        for (Direction direction : Direction.values()) {
            randomIn.setSeed(rand);
            List list = modelIn.getQuads(stateIn, direction, randomIn, modelData);
            if (list.isEmpty() || checkSides && !Block.func_176225_a(stateIn, (IBlockReader)worldIn, posIn, direction)) continue;
            int i = WorldRenderer.func_228420_a_(worldIn, stateIn, posIn.func_177972_a(direction));
            this.func_228798_a_(worldIn, stateIn, posIn, i, combinedOverlayIn, false, matrixStackIn, buffer, list, bitset);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.getQuads(stateIn, null, randomIn, modelData);
        if (!list1.isEmpty()) {
            this.func_228798_a_(worldIn, stateIn, posIn, -1, combinedOverlayIn, true, matrixStackIn, buffer, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private void func_228799_a_(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixStackIn, IVertexBuilder buffer, List<BakedQuad> list, float[] quadBounds, BitSet bitSet, AmbientOcclusionFace aoFace, int combinedOverlayIn) {
        for (BakedQuad bakedquad : list) {
            this.func_228801_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, bitSet);
            aoFace.func_239285_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178210_d(), quadBounds, bitSet, bakedquad.func_239287_f_());
            this.func_228800_a_(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.func_227866_c_(), bakedquad, aoFace.field_178206_b[0], aoFace.field_178206_b[1], aoFace.field_178206_b[2], aoFace.field_178206_b[3], aoFace.field_178207_c[0], aoFace.field_178207_c[1], aoFace.field_178207_c[2], aoFace.field_178207_c[3], combinedOverlayIn);
        }
    }

    private void func_228800_a_(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, IVertexBuilder buffer, MatrixStack.Entry matrixEntry, BakedQuad quadIn, float colorMul0, float colorMul1, float colorMul2, float colorMul3, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float f2;
        float f1;
        float f;
        if (quadIn.func_178212_b()) {
            int i = this.field_187499_a.func_228054_a_(stateIn, blockAccessIn, posIn, quadIn.func_178211_c());
            f = (float)(i >> 16 & 0xFF) / 255.0f;
            f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            f2 = (float)(i & 0xFF) / 255.0f;
        } else {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        }
        buffer.func_227890_a_(matrixEntry, quadIn, new float[]{colorMul0, colorMul1, colorMul2, colorMul3}, f, f1, f2, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true);
    }

    private void func_228801_a_(IBlockDisplayReader blockReaderIn, BlockState stateIn, BlockPos posIn, int[] vertexData, Direction face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 8]);
            float f7 = Float.intBitsToFloat(vertexData[i * 8 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 8 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[Direction.WEST.func_176745_a()] = f;
            quadBounds[Direction.EAST.func_176745_a()] = f3;
            quadBounds[Direction.DOWN.func_176745_a()] = f1;
            quadBounds[Direction.UP.func_176745_a()] = f4;
            quadBounds[Direction.NORTH.func_176745_a()] = f2;
            quadBounds[Direction.SOUTH.func_176745_a()] = f5;
            int j = Direction.values().length;
            quadBounds[Direction.WEST.func_176745_a() + j] = 1.0f - f;
            quadBounds[Direction.EAST.func_176745_a() + j] = 1.0f - f3;
            quadBounds[Direction.DOWN.func_176745_a() + j] = 1.0f - f1;
            quadBounds[Direction.UP.func_176745_a() + j] = 1.0f - f4;
            quadBounds[Direction.NORTH.func_176745_a() + j] = 1.0f - f2;
            quadBounds[Direction.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (face) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f1 < 1.0E-4f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f1 == f4 && (f4 > 0.9999f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f2 == f5 && (f2 < 1.0E-4f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, f2 == f5 && (f5 > 0.9999f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f == f3 && (f < 1.0E-4f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, f == f3 && (f3 > 0.9999f || stateIn.func_235785_r_((IBlockReader)blockReaderIn, posIn)));
            }
        }
    }

    private void func_228798_a_(IBlockDisplayReader blockAccessIn, BlockState stateIn, BlockPos posIn, int brightnessIn, int combinedOverlayIn, boolean ownBrightness, MatrixStack matrixStackIn, IVertexBuilder buffer, List<BakedQuad> list, BitSet bitSet) {
        for (BakedQuad bakedquad : list) {
            if (ownBrightness) {
                this.func_228801_a_(blockAccessIn, stateIn, posIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = WorldRenderer.func_228420_a_(blockAccessIn, stateIn, blockpos);
            }
            float f = blockAccessIn.func_230487_a_(bakedquad.func_178210_d(), bakedquad.func_239287_f_());
            this.func_228800_a_(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.func_227866_c_(), bakedquad, f, f, f, f, brightnessIn, brightnessIn, brightnessIn, brightnessIn, combinedOverlayIn);
        }
    }

    @Deprecated
    public void func_228804_a_(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, @Nullable BlockState state, IBakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn) {
        this.renderModel(matrixEntry, buffer, state, modelIn, red, green, blue, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public void renderModel(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, @Nullable BlockState state, IBakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            BlockModelRenderer.func_228803_a_(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, direction, random, modelData), combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        BlockModelRenderer.func_228803_a_(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, null, random, modelData), combinedLightIn, combinedOverlayIn);
    }

    private static void func_228803_a_(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, float red, float green, float blue, List<BakedQuad> listQuads, int combinedLightIn, int combinedOverlayIn) {
        for (BakedQuad bakedquad : listQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.func_178212_b()) {
                f = MathHelper.func_76131_a((float)red, (float)0.0f, (float)1.0f);
                f1 = MathHelper.func_76131_a((float)green, (float)0.0f, (float)1.0f);
                f2 = MathHelper.func_76131_a((float)blue, (float)0.0f, (float)1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            buffer.func_227889_a_(matrixEntry, bakedquad, f, f1, f2, combinedLightIn, combinedOverlayIn);
        }
    }

    public static void func_211847_a() {
        field_210267_b.get().func_222895_a();
    }

    public static void func_210266_a() {
        field_210267_b.get().func_222897_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] field_178199_k;

        private VertexTranslations(int vert0In, int vert1In, int vert2In, int vert3In) {
            this.field_178191_g = vert0In;
            this.field_178200_h = vert1In;
            this.field_178201_i = vert2In;
            this.field_178198_j = vert3In;
        }

        public static VertexTranslations func_178184_a(Direction facingIn) {
            return field_178199_k[facingIn.func_176745_a()];
        }

        static {
            field_178199_k = (VertexTranslations[])Util.func_200696_a((Object)new VertexTranslations[6], p_209261_0_ -> {
                p_209261_0_[Direction.DOWN.func_176745_a()] = DOWN;
                p_209261_0_[Direction.UP.func_176745_a()] = UP;
                p_209261_0_[Direction.NORTH.func_176745_a()] = NORTH;
                p_209261_0_[Direction.SOUTH.func_176745_a()] = SOUTH;
                p_209261_0_[Direction.WEST.func_176745_a()] = WEST;
                p_209261_0_[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Orientation {
        DOWN(Direction.DOWN, false),
        UP(Direction.UP, false),
        NORTH(Direction.NORTH, false),
        SOUTH(Direction.SOUTH, false),
        WEST(Direction.WEST, false),
        EAST(Direction.EAST, false),
        FLIP_DOWN(Direction.DOWN, true),
        FLIP_UP(Direction.UP, true),
        FLIP_NORTH(Direction.NORTH, true),
        FLIP_SOUTH(Direction.SOUTH, true),
        FLIP_WEST(Direction.WEST, true),
        FLIP_EAST(Direction.EAST, true);

        private final int field_178229_m;

        private Orientation(Direction facingIn, boolean flip) {
            this.field_178229_m = facingIn.func_176745_a() + (flip ? Direction.values().length : 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum NeighborInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final Direction[] field_178276_g;
        private final boolean field_178289_i;
        private final Orientation[] field_178286_j;
        private final Orientation[] field_178287_k;
        private final Orientation[] field_178284_l;
        private final Orientation[] field_178285_m;
        private static final NeighborInfo[] field_178282_n;

        private NeighborInfo(Direction[] cornersIn, float brightness, boolean doNonCubicWeightIn, Orientation[] vert0WeightsIn, Orientation[] vert1WeightsIn, Orientation[] vert2WeightsIn, Orientation[] vert3WeightsIn) {
            this.field_178276_g = cornersIn;
            this.field_178289_i = doNonCubicWeightIn;
            this.field_178286_j = vert0WeightsIn;
            this.field_178287_k = vert1WeightsIn;
            this.field_178284_l = vert2WeightsIn;
            this.field_178285_m = vert3WeightsIn;
        }

        public static NeighborInfo func_178273_a(Direction facing) {
            return field_178282_n[facing.func_176745_a()];
        }

        static {
            field_178282_n = (NeighborInfo[])Util.func_200696_a((Object)new NeighborInfo[6], p_209260_0_ -> {
                p_209260_0_[Direction.DOWN.func_176745_a()] = DOWN;
                p_209260_0_[Direction.UP.func_176745_a()] = UP;
                p_209260_0_[Direction.NORTH.func_176745_a()] = NORTH;
                p_209260_0_[Direction.SOUTH.func_176745_a()] = SOUTH;
                p_209260_0_[Direction.WEST.func_176745_a()] = WEST;
                p_209260_0_[Direction.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Cache {
        private boolean field_222898_a;
        private final Long2IntLinkedOpenHashMap field_222899_b = (Long2IntLinkedOpenHashMap)Util.func_199748_a(() -> {
            Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2intlinkedopenhashmap.defaultReturnValue(Integer.MAX_VALUE);
            return long2intlinkedopenhashmap;
        });
        private final Long2FloatLinkedOpenHashMap field_222900_c = (Long2FloatLinkedOpenHashMap)Util.func_199748_a(() -> {
            Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_rehash_1_) {
                }
            };
            long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
            return long2floatlinkedopenhashmap;
        });

        private Cache() {
        }

        public void func_222895_a() {
            this.field_222898_a = true;
        }

        public void func_222897_b() {
            this.field_222898_a = false;
            this.field_222899_b.clear();
            this.field_222900_c.clear();
        }

        public int func_228810_a_(BlockState blockStateIn, IBlockDisplayReader lightReaderIn, BlockPos blockPosIn) {
            int j;
            long i = blockPosIn.func_218275_a();
            if (this.field_222898_a && (j = this.field_222899_b.get(i)) != Integer.MAX_VALUE) {
                return j;
            }
            int k = WorldRenderer.func_228420_a_(lightReaderIn, blockStateIn, blockPosIn);
            if (this.field_222898_a) {
                if (this.field_222899_b.size() == 100) {
                    this.field_222899_b.removeFirstInt();
                }
                this.field_222899_b.put(i, k);
            }
            return k;
        }

        public float func_228811_b_(BlockState blockStateIn, IBlockDisplayReader lightReaderIn, BlockPos blockPosIn) {
            float f;
            long i = blockPosIn.func_218275_a();
            if (this.field_222898_a && !Float.isNaN(f = this.field_222900_c.get(i))) {
                return f;
            }
            float f1 = blockStateIn.func_215703_d((IBlockReader)lightReaderIn, blockPosIn);
            if (this.field_222898_a) {
                if (this.field_222900_c.size() == 100) {
                    this.field_222900_c.removeFirstFloat();
                }
                this.field_222900_c.put(i, f1);
            }
            return f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class AmbientOcclusionFace {
        private final float[] field_178206_b = new float[4];
        private final int[] field_178207_c = new int[4];

        public void func_239285_a_(IBlockDisplayReader reader, BlockState state, BlockPos pos, Direction direction, float[] vertexes, BitSet bitSet, boolean applyDiffuseLighting) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            boolean flag3;
            BlockPos blockpos = bitSet.get(0) ? pos.func_177972_a(direction) : pos;
            NeighborInfo blockmodelrenderer$neighborinfo = NeighborInfo.func_178273_a(direction);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            Cache blockmodelrenderer$cache = (Cache)field_210267_b.get();
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]);
            BlockState blockstate = reader.func_180495_p((BlockPos)blockpos$mutable);
            int i = blockmodelrenderer$cache.func_228810_a_(blockstate, reader, (BlockPos)blockpos$mutable);
            float f = blockmodelrenderer$cache.func_228811_b_(blockstate, reader, (BlockPos)blockpos$mutable);
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]);
            BlockState blockstate1 = reader.func_180495_p((BlockPos)blockpos$mutable);
            int j = blockmodelrenderer$cache.func_228810_a_(blockstate1, reader, (BlockPos)blockpos$mutable);
            float f1 = blockmodelrenderer$cache.func_228811_b_(blockstate1, reader, (BlockPos)blockpos$mutable);
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[2]);
            BlockState blockstate2 = reader.func_180495_p((BlockPos)blockpos$mutable);
            int k = blockmodelrenderer$cache.func_228810_a_(blockstate2, reader, (BlockPos)blockpos$mutable);
            float f2 = blockmodelrenderer$cache.func_228811_b_(blockstate2, reader, (BlockPos)blockpos$mutable);
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[3]);
            BlockState blockstate3 = reader.func_180495_p((BlockPos)blockpos$mutable);
            int l = blockmodelrenderer$cache.func_228810_a_(blockstate3, reader, (BlockPos)blockpos$mutable);
            float f3 = blockmodelrenderer$cache.func_228811_b_(blockstate3, reader, (BlockPos)blockpos$mutable);
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(direction);
            boolean flag = reader.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutable) == 0;
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(direction);
            boolean flag1 = reader.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutable) == 0;
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[2]).func_189536_c(direction);
            boolean flag2 = reader.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutable) == 0;
            blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[3]).func_189536_c(direction);
            boolean bl = flag3 = reader.func_180495_p((BlockPos)blockpos$mutable).func_200016_a((IBlockReader)reader, (BlockPos)blockpos$mutable) == 0;
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]);
                BlockState blockstate4 = reader.func_180495_p((BlockPos)blockpos$mutable);
                f4 = blockmodelrenderer$cache.func_228811_b_(blockstate4, reader, (BlockPos)blockpos$mutable);
                i1 = blockmodelrenderer$cache.func_228810_a_(blockstate4, reader, (BlockPos)blockpos$mutable);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]);
                BlockState blockstate6 = reader.func_180495_p((BlockPos)blockpos$mutable);
                f5 = blockmodelrenderer$cache.func_228811_b_(blockstate6, reader, (BlockPos)blockpos$mutable);
                j1 = blockmodelrenderer$cache.func_228810_a_(blockstate6, reader, (BlockPos)blockpos$mutable);
            }
            if (!flag2 && !flag1) {
                f6 = f;
                k1 = i;
            } else {
                blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[2]);
                BlockState blockstate7 = reader.func_180495_p((BlockPos)blockpos$mutable);
                f6 = blockmodelrenderer$cache.func_228811_b_(blockstate7, reader, (BlockPos)blockpos$mutable);
                k1 = blockmodelrenderer$cache.func_228810_a_(blockstate7, reader, (BlockPos)blockpos$mutable);
            }
            if (!flag3 && !flag1) {
                f7 = f;
                l1 = i;
            } else {
                blockpos$mutable.func_239622_a_((Vector3i)blockpos, blockmodelrenderer$neighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$neighborinfo.field_178276_g[3]);
                BlockState blockstate8 = reader.func_180495_p((BlockPos)blockpos$mutable);
                f7 = blockmodelrenderer$cache.func_228811_b_(blockstate8, reader, (BlockPos)blockpos$mutable);
                l1 = blockmodelrenderer$cache.func_228810_a_(blockstate8, reader, (BlockPos)blockpos$mutable);
            }
            int i3 = blockmodelrenderer$cache.func_228810_a_(state, reader, pos);
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            BlockState blockstate5 = reader.func_180495_p((BlockPos)blockpos$mutable);
            if (bitSet.get(0) || !blockstate5.func_200015_d((IBlockReader)reader, (BlockPos)blockpos$mutable)) {
                i3 = blockmodelrenderer$cache.func_228810_a_(blockstate5, reader, (BlockPos)blockpos$mutable);
            }
            float f8 = bitSet.get(0) ? blockmodelrenderer$cache.func_228811_b_(reader.func_180495_p(blockpos), reader, blockpos) : blockmodelrenderer$cache.func_228811_b_(reader.func_180495_p(pos), reader, pos);
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.func_178184_a(direction);
            if (bitSet.get(1) && blockmodelrenderer$neighborinfo.field_178289_i) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f31 = (f2 + f + f4 + f8) * 0.25f;
                float f32 = (f2 + f1 + f6 + f8) * 0.25f;
                float f33 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = vertexes[blockmodelrenderer$neighborinfo.field_178286_j[0].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178286_j[1].field_178229_m];
                float f14 = vertexes[blockmodelrenderer$neighborinfo.field_178286_j[2].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178286_j[3].field_178229_m];
                float f15 = vertexes[blockmodelrenderer$neighborinfo.field_178286_j[4].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178286_j[5].field_178229_m];
                float f16 = vertexes[blockmodelrenderer$neighborinfo.field_178286_j[6].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178286_j[7].field_178229_m];
                float f17 = vertexes[blockmodelrenderer$neighborinfo.field_178287_k[0].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178287_k[1].field_178229_m];
                float f18 = vertexes[blockmodelrenderer$neighborinfo.field_178287_k[2].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178287_k[3].field_178229_m];
                float f19 = vertexes[blockmodelrenderer$neighborinfo.field_178287_k[4].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178287_k[5].field_178229_m];
                float f20 = vertexes[blockmodelrenderer$neighborinfo.field_178287_k[6].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178287_k[7].field_178229_m];
                float f21 = vertexes[blockmodelrenderer$neighborinfo.field_178284_l[0].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178284_l[1].field_178229_m];
                float f22 = vertexes[blockmodelrenderer$neighborinfo.field_178284_l[2].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178284_l[3].field_178229_m];
                float f23 = vertexes[blockmodelrenderer$neighborinfo.field_178284_l[4].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178284_l[5].field_178229_m];
                float f24 = vertexes[blockmodelrenderer$neighborinfo.field_178284_l[6].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178284_l[7].field_178229_m];
                float f25 = vertexes[blockmodelrenderer$neighborinfo.field_178285_m[0].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178285_m[1].field_178229_m];
                float f26 = vertexes[blockmodelrenderer$neighborinfo.field_178285_m[2].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178285_m[3].field_178229_m];
                float f27 = vertexes[blockmodelrenderer$neighborinfo.field_178285_m[4].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178285_m[5].field_178229_m];
                float f28 = vertexes[blockmodelrenderer$neighborinfo.field_178285_m[6].field_178229_m] * vertexes[blockmodelrenderer$neighborinfo.field_178285_m[7].field_178229_m];
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f29 * f13 + f31 * f14 + f32 * f15 + f33 * f16;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f29 * f17 + f31 * f18 + f32 * f19 + f33 * f20;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f29 * f21 + f31 * f22 + f32 * f23 + f33 * f24;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f29 * f25 + f31 * f26 + f32 * f27 + f33 * f28;
                int i2 = this.func_147778_a(l, i, j1, i3);
                int j2 = this.func_147778_a(k, i, i1, i3);
                int k2 = this.func_147778_a(k, j, k1, i3);
                int l2 = this.func_147778_a(l, j, l1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.func_178203_a(i2, j2, k2, l2, f13, f14, f15, f16);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.func_178203_a(i2, j2, k2, l2, f17, f18, f19, f20);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.func_178203_a(i2, j2, k2, l2, f21, f22, f23, f24);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.func_178203_a(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.func_147778_a(l, i, j1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.func_147778_a(k, i, i1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.func_147778_a(k, j, k1, i3);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.func_147778_a(l, j, l1, i3);
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f9;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f10;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f11;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f12;
            }
            float f30 = reader.func_230487_a_(direction, applyDiffuseLighting);
            int j3 = 0;
            while (j3 < this.field_178206_b.length) {
                int n = j3++;
                this.field_178206_b[n] = this.field_178206_b[n] * f30;
            }
        }

        private int func_147778_a(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int func_178203_a(int b1, int b2, int b3, int b4, float w1, float w2, float w3, float w4) {
            int i = (int)((float)(b1 >> 16 & 0xFF) * w1 + (float)(b2 >> 16 & 0xFF) * w2 + (float)(b3 >> 16 & 0xFF) * w3 + (float)(b4 >> 16 & 0xFF) * w4) & 0xFF;
            int j = (int)((float)(b1 & 0xFF) * w1 + (float)(b2 & 0xFF) * w2 + (float)(b3 & 0xFF) * w3 + (float)(b4 & 0xFF) * w4) & 0xFF;
            return i << 16 | j;
        }
    }
}

