/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.monster.HoglinTasks;
import net.minecraft.entity.monster.IFlinging;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZoglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class HoglinEntity
extends AnimalEntity
implements IMob,
IFlinging {
    private static final DataParameter<Boolean> field_234356_bw_ = EntityDataManager.func_187226_a(HoglinEntity.class, DataSerializers.field_187198_h);
    private int field_234357_bx_;
    private int field_234358_by_ = 0;
    private boolean field_234359_bz_ = false;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super HoglinEntity>>> field_234354_bu_ = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c, SensorType.field_234132_n_, SensorType.field_234131_m_);
    protected static final ImmutableList<? extends MemoryModuleType<?>> field_234355_bv_ = ImmutableList.of(MemoryModuleType.field_220953_n, MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220949_j, MemoryModuleType.field_234102_l_, MemoryModuleType.field_220951_l, MemoryModuleType.field_220950_k, MemoryModuleType.field_223021_x, MemoryModuleType.field_220954_o, MemoryModuleType.field_234103_o_, MemoryModuleType.field_234104_p_, MemoryModuleType.field_234092_Z_, (Object[])new MemoryModuleType[]{MemoryModuleType.field_234106_z_, MemoryModuleType.field_234094_ab_, MemoryModuleType.field_234095_ac_, MemoryModuleType.field_234091_Y_, MemoryModuleType.field_234075_I_, MemoryModuleType.field_234098_af_, MemoryModuleType.field_234099_ag_});

    public HoglinEntity(EntityType<? extends HoglinEntity> p_i231569_1_, World p_i231569_2_) {
        super(p_i231569_1_, p_i231569_2_);
        this.field_70728_aV = 5;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD();
    }

    public static AttributeModifierMap.MutableAttribute func_234362_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233820_c_, (double)0.6f).func_233815_a_(Attributes.field_233824_g_, 1.0).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!(entityIn instanceof LivingEntity)) {
            return false;
        }
        this.field_234357_bx_ = 10;
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)4);
        this.func_184185_a(SoundEvents.field_232714_fD_, 1.0f, this.func_70647_i());
        HoglinTasks.func_234378_a_((HoglinEntity)this, (LivingEntity)((LivingEntity)entityIn));
        return IFlinging.func_234403_a_((LivingEntity)((Object)this), (LivingEntity)((LivingEntity)entityIn));
    }

    protected void func_213371_e(LivingEntity entityIn) {
        if (this.func_234363_eJ_()) {
            IFlinging.func_234404_b_((LivingEntity)((Object)this), (LivingEntity)entityIn);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (flag && source.func_76346_g() instanceof LivingEntity) {
            HoglinTasks.func_234384_b_((HoglinEntity)this, (LivingEntity)((LivingEntity)source.func_76346_g()));
        }
        return flag;
    }

    protected Brain.BrainCodec<HoglinEntity> func_230289_cH_() {
        return Brain.func_233705_a_(field_234355_bv_, field_234354_bu_);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        return HoglinTasks.func_234376_a_((Brain)this.func_230289_cH_().func_233748_a_(dynamicIn));
    }

    public Brain<HoglinEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    @Override
    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("hoglinBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)((Object)this));
        this.field_70170_p.func_217381_Z().func_76319_b();
        HoglinTasks.func_234377_a_((HoglinEntity)this);
        if (this.func_234364_eK_()) {
            ++this.field_234358_by_;
            if (this.field_234358_by_ > 300 && ForgeEventFactory.canLivingConvert((LivingEntity)((Object)this), EntityType.field_233590_aW_, timer -> {
                this.field_234358_by_ = timer;
            })) {
                this.func_241412_a_(SoundEvents.field_232715_fE_);
                this.func_234360_a_((ServerWorld)this.field_70170_p);
            }
        } else {
            this.field_234358_by_ = 0;
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_234357_bx_ > 0) {
            --this.field_234357_bx_;
        }
        super.func_70636_d();
    }

    protected void func_175500_n() {
        if (this.func_70631_g_()) {
            this.field_70728_aV = 3;
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(0.5);
        } else {
            this.field_70728_aV = 5;
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6.0);
        }
    }

    public static boolean func_234361_c_(EntityType<HoglinEntity> p_234361_0_, IWorld p_234361_1_, SpawnReason p_234361_2_, BlockPos p_234361_3_, Random p_234361_4_) {
        return !p_234361_1_.func_180495_p(p_234361_3_.func_177977_b()).func_203425_a(Blocks.field_189878_dg);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (worldIn.func_201674_k().nextFloat() < 0.2f) {
            this.func_82227_f(true);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_104002_bU();
    }

    @Override
    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        if (HoglinTasks.func_234380_a_((HoglinEntity)this, (BlockPos)pos)) {
            return -1.0f;
        }
        return worldIn.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_235381_mu_) ? 10.0f : 0.0f;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() - (this.func_70631_g_() ? 0.2 : 0.15);
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ActionResultType actionresulttype = super.func_230254_b_(p_230254_1_, p_230254_2_);
        if (actionresulttype.func_226246_a_()) {
            this.func_110163_bv();
        }
        return actionresulttype;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.field_234357_bx_ = 10;
            this.func_184185_a(SoundEvents.field_232714_fD_, 1.0f, this.func_70647_i());
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_230290_eL_() {
        return this.field_234357_bx_;
    }

    protected boolean func_146066_aG() {
        return true;
    }

    @Override
    protected int func_70693_a(PlayerEntity player) {
        return this.field_70728_aV;
    }

    private void func_234360_a_(ServerWorld p_234360_1_) {
        ZoglinEntity zoglinentity = (ZoglinEntity)this.func_233656_b_(EntityType.field_233590_aW_, true);
        if (zoglinentity != null) {
            zoglinentity.func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0));
            ForgeEventFactory.onLivingConvert((LivingEntity)((Object)this), (LivingEntity)zoglinentity);
        }
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_234722_bw_;
    }

    public boolean func_234363_eJ_() {
        return !this.func_70631_g_();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_234356_bw_, false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.func_234368_eV_()) {
            compound.func_74757_a("IsImmuneToZombification", true);
        }
        compound.func_74768_a("TimeInOverworld", this.field_234358_by_);
        if (this.field_234359_bz_) {
            compound.func_74757_a("CannotBeHunted", true);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_234370_t_(compound.func_74767_n("IsImmuneToZombification"));
        this.field_234358_by_ = compound.func_74762_e("TimeInOverworld");
        this.func_234371_u_(compound.func_74767_n("CannotBeHunted"));
    }

    public void func_234370_t_(boolean p_234370_1_) {
        this.func_184212_Q().func_187227_b(field_234356_bw_, p_234370_1_);
    }

    private boolean func_234368_eV_() {
        return this.func_184212_Q().func_187225_a(field_234356_bw_);
    }

    public boolean func_234364_eK_() {
        return !this.field_70170_p.func_230315_m_().func_241509_i_() && !this.func_234368_eV_() && !this.func_175446_cd();
    }

    private void func_234371_u_(boolean p_234371_1_) {
        this.field_234359_bz_ = p_234371_1_;
    }

    public boolean func_234365_eM_() {
        return this.func_234363_eJ_() && !this.field_234359_bz_;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        HoglinEntity hoglinentity = EntityType.field_233588_G_.func_200721_a(p_241840_1_);
        if (hoglinentity != null) {
            hoglinentity.func_110163_bv();
        }
        return hoglinentity;
    }

    @Override
    public boolean func_204701_dC() {
        return !HoglinTasks.func_234386_c_((HoglinEntity)this) && super.func_204701_dC();
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return this.field_70170_p.field_72995_K ? null : HoglinTasks.func_234398_h_((HoglinEntity)this).orElse(null);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_232717_fG_;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232716_fF_;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_232719_fI_, 0.15f, 1.0f);
    }

    protected void func_241412_a_(SoundEvent p_241412_1_) {
        this.func_184185_a(p_241412_1_, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a((LivingEntity)((Object)this));
    }
}

