/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IllusionerEntity
extends SpellcastingIllagerEntity
implements IRangedAttackMob {
    private int field_193099_c;
    private final Vector3d[][] field_193100_bx;

    public IllusionerEntity(EntityType<? extends IllusionerEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 5;
        this.field_193100_bx = new Vector3d[2][4];
        for (int i = 0; i < 4; ++i) {
            this.field_193100_bx[0][i] = Vector3d.field_186680_a;
            this.field_193100_bx[1][i] = Vector3d.field_186680_a;
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new SpellcastingIllagerEntity.CastingASpellGoal((SpellcastingIllagerEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MirrorSpellGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new BlindnessSpellGoal());
        this.field_70714_bg.func_75776_a(6, new RangedBowAttackGoal<IllusionerEntity>(this, 0.5, 20, 15.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)((Object)this), MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), IronGolemEntity.class, false).func_190882_b(300));
    }

    public static AttributeModifierMap.MutableAttribute func_234293_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233821_d_, 0.5).func_233815_a_(Attributes.field_233819_b_, 18.0).func_233815_a_(Attributes.field_233818_a_, 32.0);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151031_f));
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(3.0, 0.0, 3.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.func_82150_aj()) {
            --this.field_193099_c;
            if (this.field_193099_c < 0) {
                this.field_193099_c = 0;
            }
            if (this.field_70737_aN != 1 && this.field_70173_aa % 1200 != 0) {
                if (this.field_70737_aN == this.field_70738_aO - 1) {
                    this.field_193099_c = 3;
                    for (int k = 0; k < 4; ++k) {
                        this.field_193100_bx[0][k] = this.field_193100_bx[1][k];
                        this.field_193100_bx[1][k] = new Vector3d(0.0, 0.0, 0.0);
                    }
                }
            } else {
                this.field_193099_c = 3;
                float f = -6.0f;
                int i = 13;
                for (int j = 0; j < 4; ++j) {
                    this.field_193100_bx[0][j] = this.field_193100_bx[1][j];
                    this.field_193100_bx[1][j] = new Vector3d((double)(-6.0f + (float)this.field_70146_Z.nextInt(13)) * 0.5, Math.max(0, this.field_70146_Z.nextInt(6) - 4), (double)(-6.0f + (float)this.field_70146_Z.nextInt(13)) * 0.5);
                }
                for (int l = 0; l < 16; ++l) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226285_f_(0.5), 0.0, 0.0, 0.0);
                }
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193788_dg, this.func_184176_by(), 1.0f, 1.0f, false);
            }
        }
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_193783_dc;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d[] func_193098_a(float p_193098_1_) {
        if (this.field_193099_c <= 0) {
            return this.field_193100_bx[1];
        }
        double d0 = ((float)this.field_193099_c - p_193098_1_) / 3.0f;
        d0 = Math.pow(d0, 0.25);
        Vector3d[] avector3d = new Vector3d[4];
        for (int i = 0; i < 4; ++i) {
            avector3d[i] = this.field_193100_bx[1][i].func_186678_a(1.0 - d0).func_178787_e(this.field_193100_bx[0][i].func_186678_a(d0));
        }
        return avector3d;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193786_de;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_193787_df;
    }

    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_193784_dd;
    }

    public void func_213660_a(int wave, boolean p_213660_2_) {
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)((Object)this), Items.field_151031_f)));
        AbstractArrowEntity abstractarrowentity = ProjectileHelper.func_221272_a((LivingEntity)((Object)this), itemstack, distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            abstractarrowentity = ((BowItem)((Object)this.func_184614_ca().func_77973_b())).customArrow(abstractarrowentity);
        }
        double d0 = target.func_226277_ct_() - this.func_226277_ct_();
        double d1 = target.func_226283_e_(0.3333333333333333) - abstractarrowentity.func_226278_cu_();
        double d2 = target.func_226281_cx_() - this.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        abstractarrowentity.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)((Object)abstractarrowentity));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllagerEntity.ArmPose func_193077_p() {
        if (this.func_193082_dl()) {
            return AbstractIllagerEntity.ArmPose.SPELLCASTING;
        }
        return this.func_213398_dR() ? AbstractIllagerEntity.ArmPose.BOW_AND_ARROW : AbstractIllagerEntity.ArmPose.CROSSED;
    }

    class MirrorSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private MirrorSpellGoal() {
            super((SpellcastingIllagerEntity)IllusionerEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            return !IllusionerEntity.this.func_70644_a(Effects.field_76441_p);
        }

        protected int func_190869_f() {
            return 20;
        }

        protected int func_190872_i() {
            return 340;
        }

        protected void func_190868_j() {
            IllusionerEntity.this.func_195064_c(new EffectInstance(Effects.field_76441_p, 1200));
        }

        @Nullable
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193790_di;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.DISAPPEAR;
        }
    }

    class BlindnessSpellGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private int field_193325_b;

        private BlindnessSpellGoal() {
            super((SpellcastingIllagerEntity)IllusionerEntity.this);
        }

        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            if (IllusionerEntity.this.func_70638_az() == null) {
                return false;
            }
            if (IllusionerEntity.this.func_70638_az().func_145782_y() == this.field_193325_b) {
                return false;
            }
            return IllusionerEntity.this.field_70170_p.func_175649_E(IllusionerEntity.this.func_233580_cy_()).func_193845_a((float)Difficulty.NORMAL.ordinal());
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.field_193325_b = IllusionerEntity.this.func_70638_az().func_145782_y();
        }

        protected int func_190869_f() {
            return 20;
        }

        protected int func_190872_i() {
            return 180;
        }

        protected void func_190868_j() {
            IllusionerEntity.this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_76440_q, 400));
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_193789_dh;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.BLINDNESS;
        }
    }
}

