/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ShulkerBulletEntity
extends ProjectileEntity {
    private Entity field_184571_b;
    @Nullable
    private Direction field_184573_c;
    private int field_184575_d;
    private double field_184577_e;
    private double field_184578_f;
    private double field_184579_g;
    @Nullable
    private UUID field_184574_at;

    public ShulkerBulletEntity(EntityType<? extends ShulkerBulletEntity> p_i50161_1_, World p_i50161_2_) {
        super(p_i50161_1_, p_i50161_2_);
        this.field_70145_X = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ShulkerBulletEntity(World worldIn, double x, double y, double z, double motionXIn, double motionYIn, double motionZIn) {
        this(EntityType.field_200739_ae, worldIn);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_213293_j(motionXIn, motionYIn, motionZIn);
    }

    public ShulkerBulletEntity(World worldIn, LivingEntity ownerIn, Entity targetIn, Direction.Axis p_i46772_4_) {
        this(EntityType.field_200739_ae, worldIn);
        this.func_212361_a(ownerIn);
        BlockPos blockpos = ownerIn.func_233580_cy_();
        double d0 = (double)blockpos.func_177958_n() + 0.5;
        double d1 = (double)blockpos.func_177956_o() + 0.5;
        double d2 = (double)blockpos.func_177952_p() + 0.5;
        this.func_70012_b(d0, d1, d2, this.field_70177_z, this.field_70125_A);
        this.field_184571_b = targetIn;
        this.field_184573_c = Direction.UP;
        this.func_184569_a(p_i46772_4_);
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_184571_b != null) {
            compound.func_186854_a("Target", this.field_184571_b.func_110124_au());
        }
        if (this.field_184573_c != null) {
            compound.func_74768_a("Dir", this.field_184573_c.func_176745_a());
        }
        compound.func_74768_a("Steps", this.field_184575_d);
        compound.func_74780_a("TXD", this.field_184577_e);
        compound.func_74780_a("TYD", this.field_184578_f);
        compound.func_74780_a("TZD", this.field_184579_g);
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_184575_d = compound.func_74762_e("Steps");
        this.field_184577_e = compound.func_74769_h("TXD");
        this.field_184578_f = compound.func_74769_h("TYD");
        this.field_184579_g = compound.func_74769_h("TZD");
        if (compound.func_150297_b("Dir", 99)) {
            this.field_184573_c = Direction.func_82600_a(compound.func_74762_e("Dir"));
        }
        if (compound.func_186855_b("Target")) {
            this.field_184574_at = compound.func_186857_a("Target");
        }
    }

    protected void func_70088_a() {
    }

    private void func_184568_a(@Nullable Direction directionIn) {
        this.field_184573_c = directionIn;
    }

    private void func_184569_a(@Nullable Direction.Axis p_184569_1_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.field_184571_b == null) {
            blockpos = this.func_233580_cy_().func_177977_b();
        } else {
            d0 = (double)this.field_184571_b.func_213302_cg() * 0.5;
            blockpos = new BlockPos(this.field_184571_b.func_226277_ct_(), this.field_184571_b.func_226278_cu_() + d0, this.field_184571_b.func_226281_cx_());
        }
        double d1 = (double)blockpos.func_177958_n() + 0.5;
        double d2 = (double)blockpos.func_177956_o() + d0;
        double d3 = (double)blockpos.func_177952_p() + 0.5;
        Direction direction = null;
        if (!blockpos.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
            BlockPos blockpos1 = this.func_233580_cy_();
            ArrayList list = Lists.newArrayList();
            if (p_184569_1_ != Direction.Axis.X) {
                if (blockpos1.func_177958_n() < blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177974_f())) {
                    list.add(Direction.EAST);
                } else if (blockpos1.func_177958_n() > blockpos.func_177958_n() && this.field_70170_p.func_175623_d(blockpos1.func_177976_e())) {
                    list.add(Direction.WEST);
                }
            }
            if (p_184569_1_ != Direction.Axis.Y) {
                if (blockpos1.func_177956_o() < blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177984_a())) {
                    list.add(Direction.UP);
                } else if (blockpos1.func_177956_o() > blockpos.func_177956_o() && this.field_70170_p.func_175623_d(blockpos1.func_177977_b())) {
                    list.add(Direction.DOWN);
                }
            }
            if (p_184569_1_ != Direction.Axis.Z) {
                if (blockpos1.func_177952_p() < blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177968_d())) {
                    list.add(Direction.SOUTH);
                } else if (blockpos1.func_177952_p() > blockpos.func_177952_p() && this.field_70170_p.func_175623_d(blockpos1.func_177978_c())) {
                    list.add(Direction.NORTH);
                }
            }
            direction = Direction.func_239631_a_(this.field_70146_Z);
            if (list.isEmpty()) {
                for (int i = 5; !this.field_70170_p.func_175623_d(blockpos1.func_177972_a(direction)) && i > 0; --i) {
                    direction = Direction.func_239631_a_(this.field_70146_Z);
                }
            } else {
                direction = (Direction)((Object)list.get(this.field_70146_Z.nextInt(list.size())));
            }
            d1 = this.func_226277_ct_() + (double)direction.func_82601_c();
            d2 = this.func_226278_cu_() + (double)direction.func_96559_d();
            d3 = this.func_226281_cx_() + (double)direction.func_82599_e();
        }
        this.func_184568_a(direction);
        double d6 = d1 - this.func_226277_ct_();
        double d7 = d2 - this.func_226278_cu_();
        double d4 = d3 - this.func_226281_cx_();
        double d5 = MathHelper.func_76133_a((double)(d6 * d6 + d7 * d7 + d4 * d4));
        if (d5 == 0.0) {
            this.field_184577_e = 0.0;
            this.field_184578_f = 0.0;
            this.field_184579_g = 0.0;
        } else {
            this.field_184577_e = d6 / d5 * 0.15;
            this.field_184578_f = d7 / d5 * 0.15;
            this.field_184579_g = d4 / d5 * 0.15;
        }
        this.field_70160_al = true;
        this.field_184575_d = 10 + this.field_70146_Z.nextInt(5) * 10;
    }

    public void func_70623_bb() {
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            RayTraceResult raytraceresult;
            if (this.field_184571_b == null && this.field_184574_at != null) {
                this.field_184571_b = ((ServerWorld)this.field_70170_p).func_217461_a(this.field_184574_at);
                if (this.field_184571_b == null) {
                    this.field_184574_at = null;
                }
            }
            if (this.field_184571_b == null || !this.field_184571_b.func_70089_S() || this.field_184571_b instanceof PlayerEntity && ((PlayerEntity)this.field_184571_b).func_175149_v()) {
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
                }
            } else {
                this.field_184577_e = MathHelper.func_151237_a((double)(this.field_184577_e * 1.025), (double)-1.0, (double)1.0);
                this.field_184578_f = MathHelper.func_151237_a((double)(this.field_184578_f * 1.025), (double)-1.0, (double)1.0);
                this.field_184579_g = MathHelper.func_151237_a((double)(this.field_184579_g * 1.025), (double)-1.0, (double)1.0);
                Vector3d vector3d = this.func_213322_ci();
                this.func_213317_d(vector3d.func_72441_c((this.field_184577_e - vector3d.field_72450_a) * 0.2, (this.field_184578_f - vector3d.field_72448_b) * 0.2, (this.field_184579_g - vector3d.field_72449_c) * 0.2));
            }
            if ((raytraceresult = ProjectileHelper.func_234618_a_((Entity)((Object)this), this::func_230298_a_)).func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)((Object)this), (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
        }
        this.func_145775_I();
        Vector3d vector3d1 = this.func_213322_ci();
        this.func_70107_b(this.func_226277_ct_() + vector3d1.field_72450_a, this.func_226278_cu_() + vector3d1.field_72448_b, this.func_226281_cx_() + vector3d1.field_72449_c);
        ProjectileHelper.func_188803_a((Entity)((Object)this), 0.5f);
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, this.func_226277_ct_() - vector3d1.field_72450_a, this.func_226278_cu_() - vector3d1.field_72448_b + 0.15, this.func_226281_cx_() - vector3d1.field_72449_c, 0.0, 0.0, 0.0);
        } else if (this.field_184571_b != null && !this.field_184571_b.field_70128_L) {
            if (this.field_184575_d > 0) {
                --this.field_184575_d;
                if (this.field_184575_d == 0) {
                    this.func_184569_a(this.field_184573_c == null ? null : this.field_184573_c.func_176740_k());
                }
            }
            if (this.field_184573_c != null) {
                BlockPos blockpos = this.func_233580_cy_();
                Direction.Axis direction$axis = this.field_184573_c.func_176740_k();
                if (this.field_70170_p.func_217400_a(blockpos.func_177972_a(this.field_184573_c), (Entity)((Object)this))) {
                    this.func_184569_a(direction$axis);
                } else {
                    BlockPos blockpos1 = this.field_184571_b.func_233580_cy_();
                    if (direction$axis == Direction.Axis.X && blockpos.func_177958_n() == blockpos1.func_177958_n() || direction$axis == Direction.Axis.Z && blockpos.func_177952_p() == blockpos1.func_177952_p() || direction$axis == Direction.Axis.Y && blockpos.func_177956_o() == blockpos1.func_177956_o()) {
                        this.func_184569_a(direction$axis);
                    }
                }
            }
        }
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        return super.func_230298_a_(p_230298_1_) && !p_230298_1_.field_70145_X;
    }

    public boolean func_70027_ad() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        super.func_213868_a(p_213868_1_);
        Entity entity = p_213868_1_.func_216348_a();
        Entity entity1 = this.func_234616_v_();
        LivingEntity livingentity = entity1 instanceof LivingEntity ? (LivingEntity)entity1 : null;
        boolean flag = entity.func_70097_a(DamageSource.func_188403_a((Entity)((Object)this), (LivingEntity)livingentity).func_76349_b(), 4.0f);
        if (flag) {
            this.func_174815_a(livingentity, entity);
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_188424_y, 200));
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult p_230299_1_) {
        super.func_230299_a_(p_230299_1_);
        ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2, 0.2, 0.2, 0.2, 0.0);
        this.func_184185_a(SoundEvents.field_187775_eP, 1.0f, 1.0f);
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        this.func_70106_y();
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_187777_eQ, 1.0f, 1.0f);
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197614_g, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.func_70106_y();
        }
        return true;
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)((Object)this));
    }
}

