/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeManager
extends JsonReloadListener {
    private static final Gson field_223401_a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger field_199521_c = LogManager.getLogger();
    private Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> field_199522_d = ImmutableMap.of();
    private boolean field_199523_e;

    public RecipeManager() {
        super(field_223401_a, "recipes");
    }

    protected void func_212853_a_(Map<ResourceLocation, JsonElement> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        this.field_199523_e = false;
        HashMap map = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.func_110623_a().startsWith("_")) continue;
            try {
                if (entry.getValue().isJsonObject() && !CraftingHelper.processConditions((JsonObject)entry.getValue().getAsJsonObject(), (String)"conditions")) {
                    field_199521_c.debug("Skipping loading recipe {} as it's conditions were not met", (Object)resourcelocation);
                    continue;
                }
                IRecipe<?> irecipe = RecipeManager.func_215377_a(resourcelocation, JSONUtils.func_151210_l((JsonElement)entry.getValue(), (String)"top element"));
                if (irecipe == null) {
                    field_199521_c.info("Skipping loading recipe {} as it's serializer returned null", (Object)resourcelocation);
                    continue;
                }
                map.computeIfAbsent(irecipe.func_222127_g(), p_223391_0_ -> ImmutableMap.builder()).put((Object)resourcelocation, irecipe);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                field_199521_c.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.field_199522_d = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_223400_0_ -> ((ImmutableMap.Builder)p_223400_0_.getValue()).build()));
        field_199521_c.info("Loaded {} recipes", (Object)map.size());
    }

    public <C extends IInventory, T extends IRecipe<C>> Optional<T> func_215371_a(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn) {
        return this.func_215366_a(recipeTypeIn).values().stream().flatMap(p_215372_3_ -> Util.func_215081_a((Optional)recipeTypeIn.func_222148_a(p_215372_3_, worldIn, inventoryIn))).findFirst();
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> func_241447_a_(IRecipeType<T> recipeType) {
        return this.func_215366_a(recipeType).values().stream().map(p_241453_0_ -> p_241453_0_).collect(Collectors.toList());
    }

    public <C extends IInventory, T extends IRecipe<C>> List<T> func_215370_b(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn) {
        return this.func_215366_a(recipeTypeIn).values().stream().flatMap(p_215380_3_ -> Util.func_215081_a((Optional)recipeTypeIn.func_222148_a(p_215380_3_, worldIn, inventoryIn))).sorted(Comparator.comparing(p_215379_0_ -> p_215379_0_.func_77571_b().func_77977_a())).collect(Collectors.toList());
    }

    private <C extends IInventory, T extends IRecipe<C>> Map<ResourceLocation, IRecipe<C>> func_215366_a(IRecipeType<T> recipeTypeIn) {
        return this.field_199522_d.getOrDefault(recipeTypeIn, Collections.emptyMap());
    }

    public <C extends IInventory, T extends IRecipe<C>> NonNullList<ItemStack> func_215369_c(IRecipeType<T> recipeTypeIn, C inventoryIn, World worldIn) {
        Optional<T> optional = this.func_215371_a(recipeTypeIn, inventoryIn, worldIn);
        if (optional.isPresent()) {
            return ((IRecipe)optional.get()).func_179532_b(inventoryIn);
        }
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inventoryIn.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)inventoryIn.func_70301_a(i));
        }
        return nonnulllist;
    }

    public Optional<? extends IRecipe<?>> func_215367_a(ResourceLocation recipeId) {
        return this.field_199522_d.values().stream().map(p_215368_1_ -> (IRecipe)p_215368_1_.get(recipeId)).filter(Objects::nonNull).findFirst();
    }

    public Collection<IRecipe<?>> func_199510_b() {
        return this.field_199522_d.values().stream().flatMap(p_215376_0_ -> p_215376_0_.values().stream()).collect(Collectors.toSet());
    }

    public Stream<ResourceLocation> func_215378_c() {
        return this.field_199522_d.values().stream().flatMap(p_215375_0_ -> p_215375_0_.keySet().stream());
    }

    public static IRecipe<?> func_215377_a(ResourceLocation recipeId, JsonObject json) {
        String s = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
        return Registry.field_218368_I.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'")).func_199425_a_(recipeId, json);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_223389_a(Iterable<IRecipe<?>> recipes) {
        this.field_199523_e = false;
        HashMap map = Maps.newHashMap();
        recipes.forEach(p_223392_1_ -> {
            Map map1 = map.computeIfAbsent(p_223392_1_.func_222127_g(), p_223390_0_ -> Maps.newHashMap());
            IRecipe irecipe = map1.put(p_223392_1_.func_199560_c(), p_223392_1_);
            if (irecipe != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + p_223392_1_.func_199560_c());
            }
        });
        this.field_199522_d = ImmutableMap.copyOf((Map)map);
    }
}

