/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTypes;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundNBT
implements INBT {
    public static final Codec<CompoundNBT> field_240597_a_ = Codec.PASSTHROUGH.comapFlatMap(p_240598_0_ -> {
        INBT inbt = (INBT)p_240598_0_.convert((DynamicOps)NBTDynamicOps.field_210820_a).getValue();
        return inbt instanceof CompoundNBT ? DataResult.success((Object)((CompoundNBT)inbt)) : DataResult.error((String)("Not a compound tag: " + inbt));
    }, p_240599_0_ -> new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, p_240599_0_));
    private static final Logger field_191551_b = LogManager.getLogger();
    private static final Pattern field_193583_c = Pattern.compile("[A-Za-z0-9._+-]+");
    public static final INBTType<CompoundNBT> field_229675_a_ = new INBTType<CompoundNBT>(){

        public CompoundNBT func_225649_b_(DataInput input, int depth, NBTSizeTracker accounter) throws IOException {
            byte b0;
            accounter.func_152450_a(384L);
            if (depth > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            HashMap map = Maps.newHashMap();
            while ((b0 = CompoundNBT.func_152447_a(input, accounter)) != 0) {
                String s = CompoundNBT.func_152448_b(input, accounter);
                accounter.func_152450_a(224 + 16 * s.length());
                accounter.func_152450_a(32L);
                INBT inbt = CompoundNBT.func_229680_b_(NBTTypes.func_229710_a_((int)b0), s, input, depth + 1, accounter);
                if (map.put(s, inbt) == null) continue;
                accounter.func_152450_a(288L);
            }
            return new CompoundNBT(map);
        }

        public String func_225648_a_() {
            return "COMPOUND";
        }

        public String func_225650_b_() {
            return "TAG_Compound";
        }
    };
    private final Map<String, INBT> field_74784_a;

    protected CompoundNBT(Map<String, INBT> tagMap) {
        this.field_74784_a = tagMap;
    }

    public CompoundNBT() {
        this(Maps.newHashMap());
    }

    public void func_74734_a(DataOutput output) throws IOException {
        for (String s : this.field_74784_a.keySet()) {
            INBT inbt = this.field_74784_a.get(s);
            CompoundNBT.func_150298_a(s, inbt, output);
        }
        output.writeByte(0);
    }

    public Set<String> func_150296_c() {
        return this.field_74784_a.keySet();
    }

    public byte func_74732_a() {
        return 10;
    }

    public INBTType<CompoundNBT> func_225647_b_() {
        return field_229675_a_;
    }

    public int func_186856_d() {
        return this.field_74784_a.size();
    }

    @Nullable
    public INBT func_218657_a(String key, INBT value) {
        if (value == null) {
            throw new IllegalArgumentException("Invalid null NBT value with key " + key);
        }
        return this.field_74784_a.put(key, value);
    }

    public void func_74774_a(String key, byte value) {
        this.field_74784_a.put(key, (INBT)ByteNBT.func_229671_a_((byte)value));
    }

    public void func_74777_a(String key, short value) {
        this.field_74784_a.put(key, (INBT)ShortNBT.func_229701_a_((short)value));
    }

    public void func_74768_a(String key, int value) {
        this.field_74784_a.put(key, (INBT)IntNBT.func_229692_a_((int)value));
    }

    public void func_74772_a(String key, long value) {
        this.field_74784_a.put(key, (INBT)LongNBT.func_229698_a_((long)value));
    }

    public void func_186854_a(String key, UUID value) {
        this.field_74784_a.put(key, (INBT)NBTUtil.func_240626_a_((UUID)value));
    }

    public UUID func_186857_a(String key) {
        return NBTUtil.func_186860_b((INBT)this.func_74781_a(key));
    }

    public boolean func_186855_b(String key) {
        INBT inbt = this.func_74781_a(key);
        return inbt != null && inbt.func_225647_b_() == IntArrayNBT.field_229690_a_ && ((IntArrayNBT)inbt).func_150302_c().length == 4;
    }

    public void func_74776_a(String key, float value) {
        this.field_74784_a.put(key, (INBT)FloatNBT.func_229689_a_((float)value));
    }

    public void func_74780_a(String key, double value) {
        this.field_74784_a.put(key, (INBT)DoubleNBT.func_229684_a_((double)value));
    }

    public void func_74778_a(String key, String value) {
        this.field_74784_a.put(key, StringNBT.func_229705_a_(value));
    }

    public void func_74773_a(String key, byte[] value) {
        this.field_74784_a.put(key, (INBT)new ByteArrayNBT(value));
    }

    public void func_74783_a(String key, int[] value) {
        this.field_74784_a.put(key, (INBT)new IntArrayNBT(value));
    }

    public void func_197646_b(String key, List<Integer> value) {
        this.field_74784_a.put(key, (INBT)new IntArrayNBT(value));
    }

    public void func_197644_a(String key, long[] value) {
        this.field_74784_a.put(key, (INBT)new LongArrayNBT(value));
    }

    public void func_202168_c(String key, List<Long> value) {
        this.field_74784_a.put(key, (INBT)new LongArrayNBT(value));
    }

    public void func_74757_a(String key, boolean value) {
        this.field_74784_a.put(key, (INBT)ByteNBT.func_229672_a_((boolean)value));
    }

    @Nullable
    public INBT func_74781_a(String key) {
        return this.field_74784_a.get(key);
    }

    public byte func_150299_b(String key) {
        INBT inbt = this.field_74784_a.get(key);
        return inbt == null ? (byte)0 : inbt.func_74732_a();
    }

    public boolean func_74764_b(String key) {
        return this.field_74784_a.containsKey(key);
    }

    public boolean func_150297_b(String key, int type) {
        byte i = this.func_150299_b(key);
        if (i == type) {
            return true;
        }
        if (type != 99) {
            return false;
        }
        return i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6;
    }

    public byte func_74771_c(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150290_f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short func_74765_d(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150289_e();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int func_74762_e(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150287_d();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long func_74763_f(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150291_c();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float func_74760_g(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150288_h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double func_74769_h(String key) {
        try {
            if (this.func_150297_b(key, 99)) {
                return ((NumberNBT)this.field_74784_a.get(key)).func_150286_g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String func_74779_i(String key) {
        try {
            if (this.func_150297_b(key, 8)) {
                return this.field_74784_a.get(key).func_150285_a_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] func_74770_j(String key) {
        try {
            if (this.func_150297_b(key, 7)) {
                return ((ByteArrayNBT)this.field_74784_a.get(key)).func_150292_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(key, ByteArrayNBT.field_229667_a_, classcastexception));
        }
        return new byte[0];
    }

    public int[] func_74759_k(String key) {
        try {
            if (this.func_150297_b(key, 11)) {
                return ((IntArrayNBT)this.field_74784_a.get(key)).func_150302_c();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(key, IntArrayNBT.field_229690_a_, classcastexception));
        }
        return new int[0];
    }

    public long[] func_197645_o(String key) {
        try {
            if (this.func_150297_b(key, 12)) {
                return ((LongArrayNBT)this.field_74784_a.get(key)).func_197652_h();
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(key, LongArrayNBT.field_229696_a_, classcastexception));
        }
        return new long[0];
    }

    public CompoundNBT func_74775_l(String key) {
        try {
            if (this.func_150297_b(key, 10)) {
                return (CompoundNBT)this.field_74784_a.get(key);
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(key, field_229675_a_, classcastexception));
        }
        return new CompoundNBT();
    }

    public ListNBT func_150295_c(String key, int type) {
        try {
            if (this.func_150299_b(key) == 9) {
                ListNBT listnbt = (ListNBT)this.field_74784_a.get(key);
                if (!listnbt.isEmpty() && listnbt.func_230528_d__() != type) {
                    return new ListNBT();
                }
                return listnbt;
            }
        }
        catch (ClassCastException classcastexception) {
            throw new ReportedException(this.func_229677_a_(key, ListNBT.field_229694_a_, classcastexception));
        }
        return new ListNBT();
    }

    public boolean func_74767_n(String key) {
        return this.func_74771_c(key) != 0;
    }

    public void func_82580_o(String key) {
        this.field_74784_a.remove(key);
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(CompoundNBT.func_193582_s(s)).append(':').append(this.field_74784_a.get(s));
        }
        return stringbuilder.append('}').toString();
    }

    public boolean isEmpty() {
        return this.field_74784_a.isEmpty();
    }

    private CrashReport func_229677_a_(String tagName, INBTType<?> type, ClassCastException exception) {
        CrashReport crashreport = CrashReport.func_85055_a(exception, "Reading NBT data");
        CrashReportCategory crashreportcategory = crashreport.func_85057_a("Corrupt NBT tag", 1);
        crashreportcategory.func_189529_a("Tag type found", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_74784_a.get(tagName).func_225647_b_().func_225648_a_()));
        crashreportcategory.func_189529_a("Tag type expected", (ICrashReportDetail<String>)((ICrashReportDetail)() -> type.func_225648_a_()));
        crashreportcategory.func_71507_a("Tag name", tagName);
        return crashreport;
    }

    public CompoundNBT func_74737_b() {
        HashMap map = Maps.newHashMap((Map)Maps.transformValues(this.field_74784_a, INBT::func_74737_b));
        return new CompoundNBT(map);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        return p_equals_1_ instanceof CompoundNBT && Objects.equals(this.field_74784_a, ((CompoundNBT)p_equals_1_).field_74784_a);
    }

    public int hashCode() {
        return this.field_74784_a.hashCode();
    }

    private static void func_150298_a(String name, INBT data, DataOutput output) throws IOException {
        output.writeByte(data.func_74732_a());
        if (data.func_74732_a() != 0) {
            output.writeUTF(name);
            data.func_74734_a(output);
        }
    }

    private static byte func_152447_a(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        sizeTracker.func_152450_a(8L);
        return input.readByte();
    }

    private static String func_152448_b(DataInput input, NBTSizeTracker sizeTracker) throws IOException {
        return sizeTracker.readUTF(input.readUTF());
    }

    private static INBT func_229680_b_(INBTType<?> type, String name, DataInput input, int depth, NBTSizeTracker accounter) {
        try {
            return type.func_225649_b_(input, depth, accounter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.func_85055_a(ioexception, "Loading NBT data");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("NBT Tag");
            crashreportcategory.func_71507_a("Tag name", name);
            crashreportcategory.func_71507_a("Tag type", type.func_225648_a_());
            throw new ReportedException(crashreport);
        }
    }

    public CompoundNBT func_197643_a(CompoundNBT other) {
        for (String s : other.field_74784_a.keySet()) {
            INBT inbt = other.field_74784_a.get(s);
            if (inbt.func_74732_a() == 10) {
                if (this.func_150297_b(s, 10)) {
                    CompoundNBT compoundnbt = this.func_74775_l(s);
                    compoundnbt.func_197643_a((CompoundNBT)inbt);
                    continue;
                }
                this.func_218657_a(s, inbt.func_74737_b());
                continue;
            }
            this.func_218657_a(s, inbt.func_74737_b());
        }
        return this;
    }

    protected static String func_193582_s(String name) {
        return field_193583_c.matcher(name).matches() ? name : StringNBT.func_197654_a(name);
    }

    protected static ITextComponent func_197642_t(String name) {
        if (field_193583_c.matcher(name).matches()) {
            return new StringTextComponent(name).func_240699_a_(field_197638_b);
        }
        String s = StringNBT.func_197654_a(name);
        String s1 = s.substring(0, 1);
        IFormattableTextComponent itextcomponent = new StringTextComponent(s.substring(1, s.length() - 1)).func_240699_a_(field_197638_b);
        return new StringTextComponent(s1).func_230529_a_((ITextComponent)itextcomponent).func_240702_b_(s1);
    }

    public ITextComponent func_199850_a(String indentation, int indentDepth) {
        if (this.field_74784_a.isEmpty()) {
            return new StringTextComponent("{}");
        }
        StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
        Collection<String> collection = this.field_74784_a.keySet();
        if (field_191551_b.isDebugEnabled()) {
            ArrayList list = Lists.newArrayList(this.field_74784_a.keySet());
            Collections.sort(list);
            collection = list;
        }
        if (!indentation.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            IFormattableTextComponent iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)indentation, (int)(indentDepth + 1))).func_230529_a_(CompoundNBT.func_197642_t(s)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.field_74784_a.get(s).func_199850_a(indentation, indentDepth + 1));
            if (iterator.hasNext()) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(indentation.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!indentation.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)indentation, (int)indentDepth));
        }
        iformattabletextcomponent.func_240702_b_("}");
        return iformattabletextcomponent;
    }

    protected Map<String, INBT> func_240600_h_() {
        return Collections.unmodifiableMap(this.field_74784_a);
    }
}

