/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.EmptyBlockReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractBlock
extends ForgeRegistryEntry<Block> {
    protected static final Direction[] field_212556_a = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH, Direction.DOWN, Direction.UP};
    protected final Material field_149764_J;
    protected final boolean field_235688_at_;
    protected final float field_235689_au_;
    protected final boolean field_149789_z;
    protected final SoundType field_149762_H;
    protected final float field_149765_K;
    protected final float field_226886_f_;
    protected final float field_226887_g_;
    protected final boolean field_208621_p;
    protected final Properties field_235684_aB_;
    @Nullable
    protected ResourceLocation field_220085_g;
    private final Supplier<ResourceLocation> lootTableSupplier;

    public AbstractBlock(Properties p_i241196_1_) {
        this.field_149764_J = p_i241196_1_.field_200953_a;
        this.field_235688_at_ = p_i241196_1_.field_200955_c;
        this.field_220085_g = p_i241196_1_.field_222381_j;
        this.field_235689_au_ = p_i241196_1_.field_200958_f;
        this.field_149789_z = p_i241196_1_.field_200960_h;
        this.field_149762_H = p_i241196_1_.field_200956_d;
        this.field_149765_K = p_i241196_1_.field_200961_i;
        this.field_226886_f_ = p_i241196_1_.field_226893_j_;
        this.field_226887_g_ = p_i241196_1_.field_226894_k_;
        this.field_208621_p = p_i241196_1_.field_208772_j;
        this.field_235684_aB_ = p_i241196_1_;
        ResourceLocation lootTableCache = p_i241196_1_.field_222381_j;
        this.lootTableSupplier = lootTableCache != null ? () -> lootTableCache : (p_i241196_1_.lootTableSupplier != null ? p_i241196_1_.lootTableSupplier : () -> new ResourceLocation(this.getRegistryName().func_110624_b(), "blocks/" + this.getRegistryName().func_110623_a()));
    }

    @Deprecated
    public void func_196248_b(BlockState p_196248_1_, IWorld p_196248_2_, BlockPos p_196248_3_, int p_196248_4_, int p_196248_5_) {
    }

    @Deprecated
    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        switch (p_196266_4_) {
            case LAND: {
                return !p_196266_1_.func_235785_r_(p_196266_2_, p_196266_3_);
            }
            case WATER: {
                return p_196266_2_.func_204610_c(p_196266_3_).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return !p_196266_1_.func_235785_r_(p_196266_2_, p_196266_3_);
            }
        }
        return false;
    }

    @Deprecated
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        return p_196271_1_;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState p_200122_1_, BlockState p_200122_2_, Direction p_200122_3_) {
        return false;
    }

    @Deprecated
    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        DebugPacketSender.func_218806_a((World)p_220069_2_, (BlockPos)p_220069_3_);
    }

    @Deprecated
    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
    }

    @Deprecated
    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!(!p_196243_1_.hasTileEntity() || p_196243_1_.func_203425_a(p_196243_4_.func_177230_c()) && p_196243_4_.hasTileEntity())) {
            p_196243_2_.func_175713_t(p_196243_3_);
        }
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        return ActionResultType.PASS;
    }

    @Deprecated
    public boolean func_189539_a(BlockState p_189539_1_, World p_189539_2_, BlockPos p_189539_3_, int p_189539_4_, int p_189539_5_) {
        return false;
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Deprecated
    public boolean func_220074_n(BlockState p_220074_1_) {
        return false;
    }

    @Deprecated
    public boolean func_149744_f(BlockState p_149744_1_) {
        return false;
    }

    @Deprecated
    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return this.field_149764_J.func_186274_m();
    }

    @Deprecated
    public FluidState func_204507_t(BlockState p_204507_1_) {
        return Fluids.field_204541_a.func_207188_f();
    }

    @Deprecated
    public boolean func_149740_M(BlockState p_149740_1_) {
        return false;
    }

    public OffsetType func_176218_Q() {
        return OffsetType.NONE;
    }

    @Deprecated
    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return p_185499_1_;
    }

    @Deprecated
    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_;
    }

    @Deprecated
    public boolean func_196253_a(BlockState p_196253_1_, BlockItemUseContext p_196253_2_) {
        return p_196253_1_.func_185904_a().func_76222_j() && (p_196253_2_.func_195996_i().func_190926_b() || p_196253_2_.func_195996_i().func_77973_b() != this.func_199767_j());
    }

    @Deprecated
    public boolean func_225541_a_(BlockState p_225541_1_, Fluid p_225541_2_) {
        return this.field_149764_J.func_76222_j() || !this.field_149764_J.func_76220_a();
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        ResourceLocation resourcelocation = this.func_220068_i();
        if (resourcelocation == LootTables.field_186419_a) {
            return Collections.emptyList();
        }
        LootContext lootcontext = p_220076_2_.func_216015_a(LootParameters.field_216287_g, p_220076_1_).func_216022_a(LootParameterSets.field_216267_h);
        ServerWorld serverworld = lootcontext.func_202879_g();
        LootTable loottable = serverworld.func_73046_m().func_200249_aQ().func_186521_a(resourcelocation);
        return loottable.func_216113_a(lootcontext);
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState p_209900_1_, BlockPos p_209900_2_) {
        return MathHelper.func_180186_a((Vector3i)p_209900_2_);
    }

    @Deprecated
    public VoxelShape func_196247_c(BlockState p_196247_1_, IBlockReader p_196247_2_, BlockPos p_196247_3_) {
        return p_196247_1_.func_196954_c(p_196247_2_, p_196247_3_);
    }

    @Deprecated
    public VoxelShape func_230335_e_(BlockState p_230335_1_, IBlockReader p_230335_2_, BlockPos p_230335_3_) {
        return this.func_220071_b(p_230335_1_, p_230335_2_, p_230335_3_, ISelectionContext.func_216377_a());
    }

    @Deprecated
    public VoxelShape func_199600_g(BlockState p_199600_1_, IBlockReader p_199600_2_, BlockPos p_199600_3_) {
        return VoxelShapes.func_197880_a();
    }

    @Deprecated
    public int func_200011_d(BlockState p_200011_1_, IBlockReader p_200011_2_, BlockPos p_200011_3_) {
        if (p_200011_1_.func_200015_d(p_200011_2_, p_200011_3_)) {
            return p_200011_2_.func_201572_C();
        }
        return p_200011_1_.func_200131_a(p_200011_2_, p_200011_3_) ? 0 : 1;
    }

    @Nullable
    @Deprecated
    public INamedContainerProvider func_220052_b(BlockState p_220052_1_, World p_220052_2_, BlockPos p_220052_3_) {
        return null;
    }

    @Deprecated
    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return true;
    }

    @Deprecated
    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState p_220080_1_, IBlockReader p_220080_2_, BlockPos p_220080_3_) {
        return p_220080_1_.func_235785_r_(p_220080_2_, p_220080_3_) ? 0.2f : 1.0f;
    }

    @Deprecated
    public int func_180641_l(BlockState p_180641_1_, World p_180641_2_, BlockPos p_180641_3_) {
        return 0;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        return this.field_235688_at_ ? p_220071_1_.func_196954_c(p_220071_2_, p_220071_3_) : VoxelShapes.func_197880_a();
    }

    @Deprecated
    public VoxelShape func_230322_a_(BlockState p_230322_1_, IBlockReader p_230322_2_, BlockPos p_230322_3_, ISelectionContext p_230322_4_) {
        return this.func_220071_b(p_230322_1_, p_230322_2_, p_230322_3_, p_230322_4_);
    }

    @Deprecated
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        this.func_225534_a_(p_225542_1_, p_225542_2_, p_225542_3_, p_225542_4_);
    }

    @Deprecated
    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
    }

    @Deprecated
    public float func_180647_a(BlockState p_180647_1_, PlayerEntity p_180647_2_, IBlockReader p_180647_3_, BlockPos p_180647_4_) {
        float f = p_180647_1_.func_185887_b(p_180647_3_, p_180647_4_);
        if (f == -1.0f) {
            return 0.0f;
        }
        int i = ForgeHooks.canHarvestBlock((BlockState)p_180647_1_, (PlayerEntity)p_180647_2_, (IBlockReader)p_180647_3_, (BlockPos)p_180647_4_) ? 30 : 100;
        return p_180647_2_.getDigSpeed(p_180647_1_, p_180647_4_) / f / (float)i;
    }

    @Deprecated
    public void func_220062_a(BlockState p_220062_1_, ServerWorld p_220062_2_, BlockPos p_220062_3_, ItemStack p_220062_4_) {
    }

    @Deprecated
    public void func_196270_a(BlockState p_196270_1_, World p_196270_2_, BlockPos p_196270_3_, PlayerEntity p_196270_4_) {
    }

    @Deprecated
    public int func_180656_a(BlockState p_180656_1_, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return 0;
    }

    @Deprecated
    public void func_196262_a(BlockState p_196262_1_, World p_196262_2_, BlockPos p_196262_3_, Entity p_196262_4_) {
    }

    @Deprecated
    public int func_176211_b(BlockState p_176211_1_, IBlockReader p_176211_2_, BlockPos p_176211_3_, Direction p_176211_4_) {
        return 0;
    }

    @Deprecated
    public final boolean func_235695_q_() {
        return this instanceof ITileEntityProvider;
    }

    public final ResourceLocation func_220068_i() {
        if (this.field_220085_g == null) {
            this.field_220085_g = this.lootTableSupplier.get();
        }
        return this.field_220085_g;
    }

    @Deprecated
    public void func_220066_a(World p_220066_1_, BlockState p_220066_2_, BlockRayTraceResult p_220066_3_, ProjectileEntity p_220066_4_) {
    }

    public abstract Item func_199767_j();

    protected abstract Block func_230328_p_();

    public MaterialColor func_235697_s_() {
        return (MaterialColor)this.field_235684_aB_.field_235800_b_.apply(this.func_230328_p_().func_176223_P());
    }

    protected boolean isAir(BlockState state) {
        return ((AbstractBlockState)state).field_235702_f_;
    }

    public static class Properties {
        private Material field_200953_a;
        private Function<BlockState, MaterialColor> field_235800_b_;
        private boolean field_200955_c = true;
        private SoundType field_200956_d = SoundType.field_185851_d;
        private ToIntFunction<BlockState> field_235803_e_ = p_235830_0_ -> 0;
        private float field_200958_f;
        private float field_200959_g;
        private boolean field_235806_h_;
        private boolean field_200960_h;
        private float field_200961_i = 0.6f;
        private float field_226893_j_ = 1.0f;
        private float field_226894_k_ = 1.0f;
        private ResourceLocation field_222381_j;
        private boolean field_226895_m_ = true;
        private boolean field_235813_o_;
        private int harvestLevel = -1;
        private ToolType harvestTool;
        private Supplier<ResourceLocation> lootTableSupplier;
        private IExtendedPositionPredicate<EntityType<?>> field_235814_p_ = (p_235832_0_, p_235832_1_, p_235832_2_, p_235832_3_) -> p_235832_0_.func_224755_d(p_235832_1_, p_235832_2_, Direction.UP) && p_235832_0_.getLightValue(p_235832_1_, p_235832_2_) < 14;
        private IPositionPredicate field_235815_q_ = (p_235853_0_, p_235853_1_, p_235853_2_) -> p_235853_0_.func_185904_a().func_76218_k() && p_235853_0_.func_235785_r_(p_235853_1_, p_235853_2_);
        private IPositionPredicate field_235816_r_;
        private IPositionPredicate field_235817_s_ = this.field_235816_r_ = (p_235848_1_, p_235848_2_, p_235848_3_) -> this.field_200953_a.func_76230_c() && p_235848_1_.func_235785_r_(p_235848_2_, p_235848_3_);
        private IPositionPredicate field_235818_t_ = (p_235843_0_, p_235843_1_, p_235843_2_) -> false;
        private IPositionPredicate field_235819_u_ = (p_235831_0_, p_235831_1_, p_235831_2_) -> false;
        private boolean field_208772_j;

        private Properties(Material p_i48616_1_, MaterialColor p_i48616_2_) {
            this(p_i48616_1_, (BlockState p_235837_1_) -> p_i48616_2_);
        }

        private Properties(Material p_i241199_1_, Function<BlockState, MaterialColor> p_i241199_2_) {
            this.field_200953_a = p_i241199_1_;
            this.field_235800_b_ = p_i241199_2_;
        }

        public static Properties func_200945_a(Material p_200945_0_) {
            return Properties.func_200949_a(p_200945_0_, p_200945_0_.func_151565_r());
        }

        public static Properties func_200952_a(Material p_200952_0_, DyeColor p_200952_1_) {
            return Properties.func_200949_a(p_200952_0_, p_200952_1_.func_196055_e());
        }

        public static Properties func_200949_a(Material p_200949_0_, MaterialColor p_200949_1_) {
            return new Properties(p_200949_0_, p_200949_1_);
        }

        public static Properties func_235836_a_(Material p_235836_0_, Function<BlockState, MaterialColor> p_235836_1_) {
            return new Properties(p_235836_0_, p_235836_1_);
        }

        public static Properties func_200950_a(AbstractBlock p_200950_0_) {
            Properties abstractblock$properties = new Properties(p_200950_0_.field_149764_J, p_200950_0_.field_235684_aB_.field_235800_b_);
            abstractblock$properties.field_200953_a = p_200950_0_.field_235684_aB_.field_200953_a;
            abstractblock$properties.field_200959_g = p_200950_0_.field_235684_aB_.field_200959_g;
            abstractblock$properties.field_200958_f = p_200950_0_.field_235684_aB_.field_200958_f;
            abstractblock$properties.field_200955_c = p_200950_0_.field_235684_aB_.field_200955_c;
            abstractblock$properties.field_200960_h = p_200950_0_.field_235684_aB_.field_200960_h;
            abstractblock$properties.field_235803_e_ = p_200950_0_.field_235684_aB_.field_235803_e_;
            abstractblock$properties.field_235800_b_ = p_200950_0_.field_235684_aB_.field_235800_b_;
            abstractblock$properties.field_200956_d = p_200950_0_.field_235684_aB_.field_200956_d;
            abstractblock$properties.field_200961_i = p_200950_0_.field_235684_aB_.field_200961_i;
            abstractblock$properties.field_226893_j_ = p_200950_0_.field_235684_aB_.field_226893_j_;
            abstractblock$properties.field_208772_j = p_200950_0_.field_235684_aB_.field_208772_j;
            abstractblock$properties.field_226895_m_ = p_200950_0_.field_235684_aB_.field_226895_m_;
            abstractblock$properties.field_235813_o_ = p_200950_0_.field_235684_aB_.field_235813_o_;
            abstractblock$properties.field_235806_h_ = p_200950_0_.field_235684_aB_.field_235806_h_;
            abstractblock$properties.harvestLevel = p_200950_0_.field_235684_aB_.harvestLevel;
            abstractblock$properties.harvestTool = p_200950_0_.field_235684_aB_.harvestTool;
            return abstractblock$properties;
        }

        public Properties func_200942_a() {
            this.field_200955_c = false;
            this.field_226895_m_ = false;
            return this;
        }

        public Properties func_226896_b_() {
            this.field_226895_m_ = false;
            return this;
        }

        public Properties harvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Properties harvestTool(ToolType harvestTool) {
            this.harvestTool = harvestTool;
            return this;
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }

        public ToolType getHarvestTool() {
            return this.harvestTool;
        }

        public Properties func_200941_a(float p_200941_1_) {
            this.field_200961_i = p_200941_1_;
            return this;
        }

        public Properties func_226897_b_(float p_226897_1_) {
            this.field_226893_j_ = p_226897_1_;
            return this;
        }

        public Properties func_226898_c_(float p_226898_1_) {
            this.field_226894_k_ = p_226898_1_;
            return this;
        }

        public Properties func_200947_a(SoundType p_200947_1_) {
            this.field_200956_d = p_200947_1_;
            return this;
        }

        public Properties func_235838_a_(ToIntFunction<BlockState> p_235838_1_) {
            this.field_235803_e_ = p_235838_1_;
            return this;
        }

        public Properties func_200948_a(float p_200948_1_, float p_200948_2_) {
            this.field_200959_g = p_200948_1_;
            this.field_200958_f = Math.max(0.0f, p_200948_2_);
            return this;
        }

        public Properties func_200946_b() {
            return this.func_200943_b(0.0f);
        }

        public Properties func_200943_b(float p_200943_1_) {
            this.func_200948_a(p_200943_1_, p_200943_1_);
            return this;
        }

        public Properties func_200944_c() {
            this.field_200960_h = true;
            return this;
        }

        public Properties func_208770_d() {
            this.field_208772_j = true;
            return this;
        }

        public Properties func_222380_e() {
            this.field_222381_j = LootTables.field_186419_a;
            return this;
        }

        @Deprecated
        public Properties func_222379_b(Block p_222379_1_) {
            this.lootTableSupplier = () -> ((Block)((Object)((Object)p_222379_1_.delegate.get()))).func_220068_i();
            return this;
        }

        public Properties lootFrom(Supplier<? extends Block> blockIn) {
            this.lootTableSupplier = () -> ((Block)((Object)((Object)blockIn.get()))).func_220068_i();
            return this;
        }

        public Properties func_235859_g_() {
            this.field_235813_o_ = true;
            return this;
        }

        public Properties func_235827_a_(IExtendedPositionPredicate<EntityType<?>> p_235827_1_) {
            this.field_235814_p_ = p_235827_1_;
            return this;
        }

        public Properties func_235828_a_(IPositionPredicate p_235828_1_) {
            this.field_235815_q_ = p_235828_1_;
            return this;
        }

        public Properties func_235842_b_(IPositionPredicate p_235842_1_) {
            this.field_235816_r_ = p_235842_1_;
            return this;
        }

        public Properties func_235847_c_(IPositionPredicate p_235847_1_) {
            this.field_235817_s_ = p_235847_1_;
            return this;
        }

        public Properties func_235852_d_(IPositionPredicate p_235852_1_) {
            this.field_235818_t_ = p_235852_1_;
            return this;
        }

        public Properties func_235856_e_(IPositionPredicate p_235856_1_) {
            this.field_235819_u_ = p_235856_1_;
            return this;
        }

        public Properties func_235861_h_() {
            this.field_235806_h_ = true;
            return this;
        }
    }

    public static enum OffsetType {
        NONE,
        XZ,
        XYZ;

    }

    public static interface IPositionPredicate {
        public boolean test(BlockState var1, IBlockReader var2, BlockPos var3);
    }

    public static interface IExtendedPositionPredicate<A> {
        public boolean test(BlockState var1, IBlockReader var2, BlockPos var3, A var4);
    }

    public static abstract class AbstractBlockState
    extends StateHolder<Block, BlockState> {
        private final int field_215708_d;
        private final boolean field_215709_e;
        private final boolean field_235702_f_;
        private final Material field_235703_g_;
        private final MaterialColor field_235704_h_;
        private final float field_235705_i_;
        private final boolean field_235706_j_;
        private final boolean field_235707_k_;
        private final IPositionPredicate field_235708_l_;
        private final IPositionPredicate field_235709_m_;
        private final IPositionPredicate field_235710_n_;
        private final IPositionPredicate field_235711_o_;
        private final IPositionPredicate field_235712_p_;
        @Nullable
        protected Cache field_215707_c;

        protected AbstractBlockState(Block p_i231870_1_, ImmutableMap<Property<?>, Comparable<?>> p_i231870_2_, MapCodec<BlockState> p_i231870_3_) {
            super((Object)p_i231870_1_, p_i231870_2_, p_i231870_3_);
            Properties abstractblock$properties = p_i231870_1_.field_235684_aB_;
            this.field_215708_d = abstractblock$properties.field_235803_e_.applyAsInt(this.func_230340_p_());
            this.field_215709_e = p_i231870_1_.func_220074_n(this.func_230340_p_());
            this.field_235702_f_ = abstractblock$properties.field_235813_o_;
            this.field_235703_g_ = abstractblock$properties.field_200953_a;
            this.field_235704_h_ = (MaterialColor)abstractblock$properties.field_235800_b_.apply(this.func_230340_p_());
            this.field_235705_i_ = abstractblock$properties.field_200959_g;
            this.field_235706_j_ = abstractblock$properties.field_235806_h_;
            this.field_235707_k_ = abstractblock$properties.field_226895_m_;
            this.field_235708_l_ = abstractblock$properties.field_235815_q_;
            this.field_235709_m_ = abstractblock$properties.field_235816_r_;
            this.field_235710_n_ = abstractblock$properties.field_235817_s_;
            this.field_235711_o_ = abstractblock$properties.field_235818_t_;
            this.field_235712_p_ = abstractblock$properties.field_235819_u_;
        }

        public void func_215692_c() {
            if (!this.func_177230_c().func_208619_r()) {
                this.field_215707_c = new Cache(this.func_230340_p_());
            }
        }

        public Block func_177230_c() {
            return (Block)((Object)this.field_235892_c_);
        }

        public Material func_185904_a() {
            return this.field_235703_g_;
        }

        public boolean func_215688_a(IBlockReader p_215688_1_, BlockPos p_215688_2_, EntityType<?> p_215688_3_) {
            return this.func_177230_c().field_235684_aB_.field_235814_p_.test(this.func_230340_p_(), p_215688_1_, p_215688_2_, p_215688_3_);
        }

        public boolean func_200131_a(IBlockReader p_200131_1_, BlockPos p_200131_2_) {
            return this.field_215707_c != null ? this.field_215707_c.field_222500_d : this.func_177230_c().func_200123_i(this.func_230340_p_(), p_200131_1_, p_200131_2_);
        }

        public int func_200016_a(IBlockReader p_200016_1_, BlockPos p_200016_2_) {
            return this.field_215707_c != null ? this.field_215707_c.field_222501_e : this.func_177230_c().func_200011_d(this.func_230340_p_(), p_200016_1_, p_200016_2_);
        }

        public VoxelShape func_215702_a(IBlockReader p_215702_1_, BlockPos p_215702_2_, Direction p_215702_3_) {
            return this.field_215707_c != null && this.field_215707_c.field_222502_f != null ? this.field_215707_c.field_222502_f[p_215702_3_.ordinal()] : VoxelShapes.func_216387_a((VoxelShape)this.func_235754_c_(p_215702_1_, p_215702_2_), (Direction)p_215702_3_);
        }

        public VoxelShape func_235754_c_(IBlockReader p_235754_1_, BlockPos p_235754_2_) {
            return this.func_177230_c().func_196247_c(this.func_230340_p_(), p_235754_1_, p_235754_2_);
        }

        public boolean func_215704_f() {
            return this.field_215707_c == null || this.field_215707_c.field_222503_g;
        }

        public boolean func_215691_g() {
            return this.field_215709_e;
        }

        @Deprecated
        public int func_185906_d() {
            return this.field_215708_d;
        }

        @Deprecated
        public boolean func_196958_f() {
            return this.func_177230_c().isAir((BlockState)this);
        }

        public MaterialColor func_185909_g(IBlockReader p_185909_1_, BlockPos p_185909_2_) {
            return this.field_235704_h_;
        }

        @Deprecated
        public BlockState func_185907_a(Rotation p_185907_1_) {
            return this.func_177230_c().func_185499_a(this.func_230340_p_(), p_185907_1_);
        }

        public BlockState func_185902_a(Mirror p_185902_1_) {
            return this.func_177230_c().func_185471_a(this.func_230340_p_(), p_185902_1_);
        }

        public BlockRenderType func_185901_i() {
            return this.func_177230_c().func_149645_b(this.func_230340_p_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_227035_k_(IBlockReader p_227035_1_, BlockPos p_227035_2_) {
            return this.field_235712_p_.test(this.func_230340_p_(), p_227035_1_, p_227035_2_);
        }

        @OnlyIn(value=Dist.CLIENT)
        public float func_215703_d(IBlockReader p_215703_1_, BlockPos p_215703_2_) {
            return this.func_177230_c().func_220080_a(this.func_230340_p_(), p_215703_1_, p_215703_2_);
        }

        public boolean func_215686_e(IBlockReader p_215686_1_, BlockPos p_215686_2_) {
            return this.field_235708_l_.test(this.func_230340_p_(), p_215686_1_, p_215686_2_);
        }

        public boolean func_185897_m() {
            return this.func_177230_c().func_149744_f(this.func_230340_p_());
        }

        public int func_185911_a(IBlockReader p_185911_1_, BlockPos p_185911_2_, Direction p_185911_3_) {
            return this.func_177230_c().func_180656_a(this.func_230340_p_(), p_185911_1_, p_185911_2_, p_185911_3_);
        }

        public boolean func_185912_n() {
            return this.func_177230_c().func_149740_M(this.func_230340_p_());
        }

        public int func_185888_a(World p_185888_1_, BlockPos p_185888_2_) {
            return this.func_177230_c().func_180641_l(this.func_230340_p_(), p_185888_1_, p_185888_2_);
        }

        public float func_185887_b(IBlockReader p_185887_1_, BlockPos p_185887_2_) {
            return this.field_235705_i_;
        }

        public float func_185903_a(PlayerEntity p_185903_1_, IBlockReader p_185903_2_, BlockPos p_185903_3_) {
            return this.func_177230_c().func_180647_a(this.func_230340_p_(), p_185903_1_, p_185903_2_, p_185903_3_);
        }

        public int func_185893_b(IBlockReader p_185893_1_, BlockPos p_185893_2_, Direction p_185893_3_) {
            return this.func_177230_c().func_176211_b(this.func_230340_p_(), p_185893_1_, p_185893_2_, p_185893_3_);
        }

        public PushReaction func_185905_o() {
            return this.func_177230_c().func_149656_h(this.func_230340_p_());
        }

        public boolean func_200015_d(IBlockReader p_200015_1_, BlockPos p_200015_2_) {
            if (this.field_215707_c != null) {
                return this.field_215707_c.field_222499_c;
            }
            BlockState blockstate = this.func_230340_p_();
            return blockstate.func_200132_m() ? Block.func_208062_a(blockstate.func_235754_c_(p_200015_1_, p_200015_2_)) : false;
        }

        public boolean func_200132_m() {
            return this.field_235707_k_;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_200017_a(BlockState p_200017_1_, Direction p_200017_2_) {
            return this.func_177230_c().func_200122_a(this.func_230340_p_(), p_200017_1_, p_200017_2_);
        }

        public VoxelShape func_196954_c(IBlockReader p_196954_1_, BlockPos p_196954_2_) {
            return this.func_215700_a(p_196954_1_, p_196954_2_, ISelectionContext.func_216377_a());
        }

        public VoxelShape func_215700_a(IBlockReader p_215700_1_, BlockPos p_215700_2_, ISelectionContext p_215700_3_) {
            return this.func_177230_c().func_220053_a(this.func_230340_p_(), p_215700_1_, p_215700_2_, p_215700_3_);
        }

        public VoxelShape func_196952_d(IBlockReader p_196952_1_, BlockPos p_196952_2_) {
            return this.field_215707_c != null ? this.field_215707_c.field_230026_g : this.func_215685_b(p_196952_1_, p_196952_2_, ISelectionContext.func_216377_a());
        }

        public VoxelShape func_215685_b(IBlockReader p_215685_1_, BlockPos p_215685_2_, ISelectionContext p_215685_3_) {
            return this.func_177230_c().func_220071_b(this.func_230340_p_(), p_215685_1_, p_215685_2_, p_215685_3_);
        }

        public VoxelShape func_196951_e(IBlockReader p_196951_1_, BlockPos p_196951_2_) {
            return this.func_177230_c().func_230335_e_(this.func_230340_p_(), p_196951_1_, p_196951_2_);
        }

        public VoxelShape func_199611_f(IBlockReader p_199611_1_, BlockPos p_199611_2_, ISelectionContext p_199611_3_) {
            return this.func_177230_c().func_230322_a_(this.func_230340_p_(), p_199611_1_, p_199611_2_, p_199611_3_);
        }

        public VoxelShape func_235777_m_(IBlockReader p_235777_1_, BlockPos p_235777_2_) {
            return this.func_177230_c().func_199600_g(this.func_230340_p_(), p_235777_1_, p_235777_2_);
        }

        public final boolean func_235719_a_(IBlockReader p_235719_1_, BlockPos p_235719_2_, Entity p_235719_3_) {
            return this.func_215682_a(p_235719_1_, p_235719_2_, p_235719_3_, Direction.UP);
        }

        public final boolean func_215682_a(IBlockReader p_215682_1_, BlockPos p_215682_2_, Entity p_215682_3_, Direction p_215682_4_) {
            return Block.func_208061_a(this.func_215685_b(p_215682_1_, p_215682_2_, ISelectionContext.func_216374_a(p_215682_3_)), p_215682_4_);
        }

        public Vector3d func_191059_e(IBlockReader p_191059_1_, BlockPos p_191059_2_) {
            OffsetType abstractblock$offsettype = this.func_177230_c().func_176218_Q();
            if (abstractblock$offsettype == OffsetType.NONE) {
                return Vector3d.field_186680_a;
            }
            long i = MathHelper.func_180187_c((int)p_191059_2_.func_177958_n(), (int)0, (int)p_191059_2_.func_177952_p());
            return new Vector3d(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5, abstractblock$offsettype == OffsetType.XYZ ? ((double)((float)(i >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
        }

        public boolean func_235728_a_(World p_235728_1_, BlockPos p_235728_2_, int p_235728_3_, int p_235728_4_) {
            return this.func_177230_c().func_189539_a(this.func_230340_p_(), p_235728_1_, p_235728_2_, p_235728_3_, p_235728_4_);
        }

        public void func_215697_a(World p_215697_1_, BlockPos p_215697_2_, Block p_215697_3_, BlockPos p_215697_4_, boolean p_215697_5_) {
            this.func_177230_c().func_220069_a(this.func_230340_p_(), p_215697_1_, p_215697_2_, p_215697_3_, p_215697_4_, p_215697_5_);
        }

        public final void func_235734_a_(IWorld p_235734_1_, BlockPos p_235734_2_, int p_235734_3_) {
            this.func_241482_a_(p_235734_1_, p_235734_2_, p_235734_3_, 512);
        }

        public final void func_241482_a_(IWorld p_241482_1_, BlockPos p_241482_2_, int p_241482_3_, int p_241482_4_) {
            this.func_177230_c();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (Direction direction : field_212556_a) {
                blockpos$mutable.func_239622_a_((Vector3i)p_241482_2_, direction);
                BlockState blockstate = p_241482_1_.func_180495_p((BlockPos)blockpos$mutable);
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), this.func_230340_p_(), p_241482_1_, (BlockPos)blockpos$mutable, p_241482_2_);
                Block.func_241468_a_(blockstate, blockstate1, p_241482_1_, (BlockPos)blockpos$mutable, p_241482_3_, p_241482_4_);
            }
        }

        public final void func_196948_b(IWorld p_196948_1_, BlockPos p_196948_2_, int p_196948_3_) {
            this.func_241483_b_(p_196948_1_, p_196948_2_, p_196948_3_, 512);
        }

        public void func_241483_b_(IWorld p_241483_1_, BlockPos p_241483_2_, int p_241483_3_, int p_241483_4_) {
            this.func_177230_c().func_196248_b(this.func_230340_p_(), p_241483_1_, p_241483_2_, p_241483_3_, p_241483_4_);
        }

        public void func_215705_a(World p_215705_1_, BlockPos p_215705_2_, BlockState p_215705_3_, boolean p_215705_4_) {
            this.func_177230_c().func_220082_b(this.func_230340_p_(), p_215705_1_, p_215705_2_, p_215705_3_, p_215705_4_);
        }

        public void func_196947_b(World p_196947_1_, BlockPos p_196947_2_, BlockState p_196947_3_, boolean p_196947_4_) {
            this.func_177230_c().func_196243_a(this.func_230340_p_(), p_196947_1_, p_196947_2_, p_196947_3_, p_196947_4_);
        }

        public void func_227033_a_(ServerWorld p_227033_1_, BlockPos p_227033_2_, Random p_227033_3_) {
            this.func_177230_c().func_225534_a_(this.func_230340_p_(), p_227033_1_, p_227033_2_, p_227033_3_);
        }

        public void func_227034_b_(ServerWorld p_227034_1_, BlockPos p_227034_2_, Random p_227034_3_) {
            this.func_177230_c().func_225542_b_(this.func_230340_p_(), p_227034_1_, p_227034_2_, p_227034_3_);
        }

        public void func_196950_a(World p_196950_1_, BlockPos p_196950_2_, Entity p_196950_3_) {
            this.func_177230_c().func_196262_a(this.func_230340_p_(), p_196950_1_, p_196950_2_, p_196950_3_);
        }

        public void func_215706_a(ServerWorld p_215706_1_, BlockPos p_215706_2_, ItemStack p_215706_3_) {
            this.func_177230_c().func_220062_a(this.func_230340_p_(), p_215706_1_, p_215706_2_, p_215706_3_);
        }

        public List<ItemStack> func_215693_a(LootContext.Builder p_215693_1_) {
            return this.func_177230_c().func_220076_a(this.func_230340_p_(), p_215693_1_);
        }

        public ActionResultType func_227031_a_(World p_227031_1_, PlayerEntity p_227031_2_, Hand p_227031_3_, BlockRayTraceResult p_227031_4_) {
            return this.func_177230_c().func_225533_a_(this.func_230340_p_(), p_227031_1_, p_227031_4_.func_216350_a(), p_227031_2_, p_227031_3_, p_227031_4_);
        }

        public void func_196942_a(World p_196942_1_, BlockPos p_196942_2_, PlayerEntity p_196942_3_) {
            this.func_177230_c().func_196270_a(this.func_230340_p_(), p_196942_1_, p_196942_2_, p_196942_3_);
        }

        public boolean func_229980_m_(IBlockReader p_229980_1_, BlockPos p_229980_2_) {
            return this.field_235709_m_.test(this.func_230340_p_(), p_229980_1_, p_229980_2_);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean func_215696_m(IBlockReader p_215696_1_, BlockPos p_215696_2_) {
            return this.field_235710_n_.test(this.func_230340_p_(), p_215696_1_, p_215696_2_);
        }

        public BlockState func_196956_a(Direction p_196956_1_, BlockState p_196956_2_, IWorld p_196956_3_, BlockPos p_196956_4_, BlockPos p_196956_5_) {
            return this.func_177230_c().func_196271_a(this.func_230340_p_(), p_196956_1_, p_196956_2_, p_196956_3_, p_196956_4_, p_196956_5_);
        }

        public boolean func_196957_g(IBlockReader p_196957_1_, BlockPos p_196957_2_, PathType p_196957_3_) {
            return this.func_177230_c().func_196266_a(this.func_230340_p_(), p_196957_1_, p_196957_2_, p_196957_3_);
        }

        public boolean func_196953_a(BlockItemUseContext p_196953_1_) {
            return this.func_177230_c().func_196253_a(this.func_230340_p_(), p_196953_1_);
        }

        public boolean func_227032_a_(Fluid p_227032_1_) {
            return this.func_177230_c().func_225541_a_(this.func_230340_p_(), p_227032_1_);
        }

        public boolean func_196955_c(IWorldReader p_196955_1_, BlockPos p_196955_2_) {
            return this.func_177230_c().func_196260_a(this.func_230340_p_(), p_196955_1_, p_196955_2_);
        }

        public boolean func_202065_c(IBlockReader p_202065_1_, BlockPos p_202065_2_) {
            return this.field_235711_o_.test(this.func_230340_p_(), p_202065_1_, p_202065_2_);
        }

        @Nullable
        public INamedContainerProvider func_215699_b(World p_215699_1_, BlockPos p_215699_2_) {
            return this.func_177230_c().func_220052_b(this.func_230340_p_(), p_215699_1_, p_215699_2_);
        }

        public boolean func_235714_a_(ITag<Block> p_235714_1_) {
            return this.func_177230_c().func_203417_a(p_235714_1_);
        }

        public boolean func_235715_a_(ITag<Block> p_235715_1_, Predicate<AbstractBlockState> p_235715_2_) {
            return this.func_177230_c().func_203417_a(p_235715_1_) && p_235715_2_.test(this);
        }

        public boolean func_203425_a(Block p_203425_1_) {
            return this.func_177230_c().func_235332_a_(p_203425_1_);
        }

        public FluidState func_204520_s() {
            return this.func_177230_c().func_204507_t(this.func_230340_p_());
        }

        public boolean func_204519_t() {
            return this.func_177230_c().func_149653_t(this.func_230340_p_());
        }

        @OnlyIn(value=Dist.CLIENT)
        public long func_209533_a(BlockPos p_209533_1_) {
            return this.func_177230_c().func_209900_a(this.func_230340_p_(), p_209533_1_);
        }

        public SoundType func_215695_r() {
            return this.func_177230_c().func_220072_p(this.func_230340_p_());
        }

        public void func_215690_a(World p_215690_1_, BlockState p_215690_2_, BlockRayTraceResult p_215690_3_, ProjectileEntity p_215690_4_) {
            this.func_177230_c().func_220066_a(p_215690_1_, p_215690_2_, p_215690_3_, p_215690_4_);
        }

        public boolean func_224755_d(IBlockReader p_224755_1_, BlockPos p_224755_2_, Direction p_224755_3_) {
            return this.func_242698_a(p_224755_1_, p_224755_2_, p_224755_3_, BlockVoxelShape.FULL);
        }

        public boolean func_242698_a(IBlockReader p_242698_1_, BlockPos p_242698_2_, Direction p_242698_3_, BlockVoxelShape p_242698_4_) {
            return this.field_215707_c != null ? this.field_215707_c.func_242700_a(p_242698_3_, p_242698_4_) : p_242698_4_.func_241854_a(this.func_230340_p_(), p_242698_1_, p_242698_2_, p_242698_3_);
        }

        public boolean func_235785_r_(IBlockReader p_235785_1_, BlockPos p_235785_2_) {
            return this.field_215707_c != null ? this.field_215707_c.field_225494_j : Block.func_208062_a(this.func_196952_d(p_235785_1_, p_235785_2_));
        }

        protected abstract BlockState func_230340_p_();

        public boolean func_235783_q_() {
            return this.field_235706_j_;
        }

        static final class Cache {
            private static final Direction[] field_222497_a = Direction.values();
            private static final int field_242699_f = BlockVoxelShape.values().length;
            protected final boolean field_222499_c;
            private final boolean field_222500_d;
            private final int field_222501_e;
            @Nullable
            private final VoxelShape[] field_222502_f;
            protected final VoxelShape field_230026_g;
            protected final boolean field_222503_g;
            private final boolean[] field_225493_i;
            protected final boolean field_225494_j;

            private Cache(BlockState p_i50627_1_) {
                Block block = p_i50627_1_.func_177230_c();
                this.field_222499_c = p_i50627_1_.func_200015_d((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                this.field_222500_d = block.func_200123_i(p_i50627_1_, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                this.field_222501_e = block.func_200011_d(p_i50627_1_, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                if (!p_i50627_1_.func_200132_m()) {
                    this.field_222502_f = null;
                } else {
                    this.field_222502_f = new VoxelShape[field_222497_a.length];
                    VoxelShape voxelshape = block.func_196247_c(p_i50627_1_, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a);
                    Direction[] directionArray = field_222497_a;
                    int n = directionArray.length;
                    for (int i = 0; i < n; ++i) {
                        Direction direction = directionArray[i];
                        this.field_222502_f[direction.ordinal()] = VoxelShapes.func_216387_a((VoxelShape)voxelshape, (Direction)direction);
                    }
                }
                this.field_230026_g = block.func_220071_b(p_i50627_1_, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, ISelectionContext.func_216377_a());
                this.field_222503_g = Arrays.stream(Direction.Axis.values()).anyMatch(p_235796_1_ -> this.field_230026_g.func_197762_b(p_235796_1_) < 0.0 || this.field_230026_g.func_197758_c(p_235796_1_) > 1.0);
                this.field_225493_i = new boolean[field_222497_a.length * field_242699_f];
                for (Direction direction1 : field_222497_a) {
                    for (BlockVoxelShape blockvoxelshape : BlockVoxelShape.values()) {
                        this.field_225493_i[Cache.func_242701_b((Direction)direction1, (BlockVoxelShape)blockvoxelshape)] = blockvoxelshape.func_241854_a(p_i50627_1_, (IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a, direction1);
                    }
                }
                this.field_225494_j = Block.func_208062_a(p_i50627_1_.func_196952_d((IBlockReader)EmptyBlockReader.INSTANCE, BlockPos.field_177992_a));
            }

            public boolean func_242700_a(Direction p_242700_1_, BlockVoxelShape p_242700_2_) {
                return this.field_225493_i[Cache.func_242701_b(p_242700_1_, p_242700_2_)];
            }

            private static int func_242701_b(Direction p_242701_0_, BlockVoxelShape p_242701_1_) {
                return p_242701_0_.ordinal() * field_242699_f + p_242701_1_.ordinal();
            }
        }
    }
}

