/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ShulkerBoxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.ShulkerAABBHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShulkerBoxBlock
extends ContainerBlock {
    public static final EnumProperty<Direction> field_190957_a = DirectionalBlock.field_176387_N;
    public static final ResourceLocation field_220169_b = new ResourceLocation("contents");
    @Nullable
    private final DyeColor field_190958_b;

    public ShulkerBoxBlock(@Nullable DyeColor p_i48334_1_, AbstractBlock.Properties p_i48334_2_) {
        super(p_i48334_2_);
        this.field_190958_b = p_i48334_1_;
        this.func_180632_j((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_190957_a, (Comparable)((Object)Direction.UP))));
    }

    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new ShulkerBoxTileEntity(this.field_190958_b);
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (p_225533_2_.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (p_225533_4_.func_175149_v()) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileentity = p_225533_2_.func_175625_s(p_225533_3_);
        if (tileentity instanceof ShulkerBoxTileEntity) {
            boolean flag;
            ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)tileentity);
            if (shulkerboxtileentity.func_190591_p() == ShulkerBoxTileEntity.AnimationStatus.CLOSED) {
                Direction direction = (Direction)((Object)p_225533_1_.func_177229_b((Property)field_190957_a));
                flag = p_225533_2_.func_226664_a_(ShulkerAABBHelper.func_233539_a_((BlockPos)p_225533_3_, (Direction)direction));
            } else {
                flag = true;
            }
            if (flag) {
                p_225533_4_.func_213829_a((INamedContainerProvider)shulkerboxtileentity);
                p_225533_4_.func_195066_a(Stats.field_191272_ae);
                PiglinTasks.func_234478_a_(p_225533_4_, true);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return (BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_190957_a, (Comparable)((Object)p_196258_1_.func_196000_l())));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_190957_a});
    }

    public void func_176208_a(World p_176208_1_, BlockPos p_176208_2_, BlockState p_176208_3_, PlayerEntity p_176208_4_) {
        TileEntity tileentity = p_176208_1_.func_175625_s(p_176208_2_);
        if (tileentity instanceof ShulkerBoxTileEntity) {
            ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)tileentity);
            if (!p_176208_1_.field_72995_K && p_176208_4_.func_184812_l_() && !shulkerboxtileentity.func_191420_l()) {
                ItemStack itemstack = ShulkerBoxBlock.func_190953_b(this.func_190956_e());
                CompoundNBT compoundnbt = shulkerboxtileentity.func_190580_f(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", compoundnbt);
                }
                if (shulkerboxtileentity.func_145818_k_()) {
                    itemstack.func_200302_a(shulkerboxtileentity.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(p_176208_1_, (double)p_176208_2_.func_177958_n() + 0.5, (double)p_176208_2_.func_177956_o() + 0.5, (double)p_176208_2_.func_177952_p() + 0.5, itemstack);
                itementity.func_174869_p();
                p_176208_1_.func_217376_c(itementity);
            } else {
                shulkerboxtileentity.func_184281_d(p_176208_4_);
            }
        }
        super.func_176208_a(p_176208_1_, p_176208_2_, p_176208_3_, p_176208_4_);
    }

    public List<ItemStack> func_220076_a(BlockState p_220076_1_, LootContext.Builder p_220076_2_) {
        TileEntity tileentity = (TileEntity)((Object)p_220076_2_.func_216019_b(LootParameters.field_216288_h));
        if (tileentity instanceof ShulkerBoxTileEntity) {
            ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)tileentity);
            p_220076_2_ = p_220076_2_.func_216017_a(field_220169_b, (p_220168_1_, p_220168_2_) -> {
                for (int i = 0; i < shulkerboxtileentity.func_70302_i_(); ++i) {
                    p_220168_2_.accept(shulkerboxtileentity.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(p_220076_1_, p_220076_2_);
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        TileEntity tileentity;
        if (p_180633_5_.func_82837_s() && (tileentity = p_180633_1_.func_175625_s(p_180633_2_)) instanceof ShulkerBoxTileEntity) {
            ((ShulkerBoxTileEntity)((Object)tileentity)).func_213903_a(p_180633_5_.func_200301_q());
        }
    }

    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            TileEntity tileentity = p_196243_2_.func_175625_s(p_196243_3_);
            if (tileentity instanceof ShulkerBoxTileEntity) {
                p_196243_2_.func_175666_e(p_196243_3_, p_196243_1_.func_177230_c());
            }
            super.func_196243_a(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack p_190948_1_, @Nullable IBlockReader p_190948_2_, List<ITextComponent> p_190948_3_, ITooltipFlag p_190948_4_) {
        super.func_190948_a(p_190948_1_, p_190948_2_, p_190948_3_, p_190948_4_);
        CompoundNBT compoundnbt = p_190948_1_.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                p_190948_3_.add((ITextComponent)new StringTextComponent("???????"));
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)((Object)ItemStack.field_190927_a));
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    IFormattableTextComponent iformattabletextcomponent = itemstack.func_200301_q().func_230532_e_();
                    iformattabletextcomponent.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                    p_190948_3_.add((ITextComponent)iformattabletextcomponent);
                }
                if (j - i > 0) {
                    p_190948_3_.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", j - i).func_240699_a_(TextFormatting.ITALIC));
                }
            }
        }
    }

    public PushReaction func_149656_h(BlockState p_149656_1_) {
        return PushReaction.DESTROY;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        TileEntity tileentity = p_220053_2_.func_175625_s(p_220053_3_);
        return tileentity instanceof ShulkerBoxTileEntity ? VoxelShapes.func_197881_a((AxisAlignedBB)((ShulkerBoxTileEntity)((Object)tileentity)).func_190584_a(p_220053_1_)) : VoxelShapes.func_197868_b();
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState p_180641_1_, World p_180641_2_, BlockPos p_180641_3_) {
        return Container.func_94526_b((IInventory)p_180641_2_.func_175625_s(p_180641_3_));
    }

    public ItemStack func_185473_a(IBlockReader p_185473_1_, BlockPos p_185473_2_, BlockState p_185473_3_) {
        ItemStack itemstack = super.func_185473_a(p_185473_1_, p_185473_2_, p_185473_3_);
        ShulkerBoxTileEntity shulkerboxtileentity = (ShulkerBoxTileEntity)((Object)p_185473_1_.func_175625_s(p_185473_2_));
        CompoundNBT compoundnbt = shulkerboxtileentity.func_190580_f(new CompoundNBT());
        if (!compoundnbt.isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", compoundnbt);
        }
        return itemstack;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static DyeColor func_190955_b(Item p_190955_0_) {
        return ShulkerBoxBlock.func_190954_c(Block.func_149634_a(p_190955_0_));
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static DyeColor func_190954_c(Block p_190954_0_) {
        return p_190954_0_ instanceof ShulkerBoxBlock ? ((ShulkerBoxBlock)((Object)p_190954_0_)).func_190956_e() : null;
    }

    public static Block func_190952_a(@Nullable DyeColor p_190952_0_) {
        if (p_190952_0_ == null) {
            return Blocks.field_204409_il;
        }
        switch (p_190952_0_) {
            case WHITE: {
                return Blocks.field_190977_dl;
            }
            case ORANGE: {
                return Blocks.field_190978_dm;
            }
            case MAGENTA: {
                return Blocks.field_190979_dn;
            }
            case LIGHT_BLUE: {
                return Blocks.field_190980_do;
            }
            case YELLOW: {
                return Blocks.field_190981_dp;
            }
            case LIME: {
                return Blocks.field_190982_dq;
            }
            case PINK: {
                return Blocks.field_190983_dr;
            }
            case GRAY: {
                return Blocks.field_190984_ds;
            }
            case LIGHT_GRAY: {
                return Blocks.field_196875_ie;
            }
            case CYAN: {
                return Blocks.field_190986_du;
            }
            default: {
                return Blocks.field_190987_dv;
            }
            case BLUE: {
                return Blocks.field_190988_dw;
            }
            case BROWN: {
                return Blocks.field_190989_dx;
            }
            case GREEN: {
                return Blocks.field_190990_dy;
            }
            case RED: {
                return Blocks.field_190991_dz;
            }
            case BLACK: 
        }
        return Blocks.field_190975_dA;
    }

    @Nullable
    public DyeColor func_190956_e() {
        return this.field_190958_b;
    }

    public static ItemStack func_190953_b(@Nullable DyeColor p_190953_0_) {
        return new ItemStack(ShulkerBoxBlock.func_190952_a(p_190953_0_));
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)((Object)p_185499_1_.func_206870_a((Property)field_190957_a, (Comparable)((Object)p_185499_2_.func_185831_a((Direction)((Object)p_185499_1_.func_177229_b((Property)field_190957_a))))));
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)((Object)p_185471_1_.func_177229_b((Property)field_190957_a))));
    }
}

