/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelShapes {
    private final Map<BlockState, IBakedModel> field_178129_a = Maps.newIdentityHashMap();
    private final ModelManager field_178128_c;

    public BlockModelShapes(ModelManager p_i46245_1_) {
        this.field_178128_c = p_i46245_1_;
    }

    @Deprecated
    public TextureAtlasSprite func_178122_a(BlockState p_178122_1_) {
        return this.func_178125_b(p_178122_1_).getParticleTexture((IModelData)EmptyModelData.INSTANCE);
    }

    public TextureAtlasSprite getTexture(BlockState state, World world, BlockPos pos) {
        IModelData data = ModelDataManager.getModelData((World)world, (BlockPos)pos);
        IBakedModel model = this.func_178125_b(state);
        return model.getParticleTexture(model.getModelData((IBlockDisplayReader)world, pos, state, (IModelData)(data == null ? EmptyModelData.INSTANCE : data)));
    }

    public IBakedModel func_178125_b(BlockState p_178125_1_) {
        IBakedModel ibakedmodel = this.field_178129_a.get((Object)p_178125_1_);
        if (ibakedmodel == null) {
            ibakedmodel = this.field_178128_c.func_174951_a();
        }
        return ibakedmodel;
    }

    public ModelManager func_178126_b() {
        return this.field_178128_c;
    }

    public void func_178124_c() {
        this.field_178129_a.clear();
        for (Block block : Registry.field_212618_g) {
            block.func_176194_O().func_177619_a().forEach(p_209551_1_ -> {
                IBakedModel ibakedmodel = this.field_178129_a.put((BlockState)((Object)p_209551_1_), this.field_178128_c.func_174953_a(BlockModelShapes.func_209554_c(p_209551_1_)));
            });
        }
    }

    public static ModelResourceLocation func_209554_c(BlockState p_209554_0_) {
        return BlockModelShapes.func_209553_a(Registry.field_212618_g.func_177774_c((Object)p_209554_0_.func_177230_c()), p_209554_0_);
    }

    public static ModelResourceLocation func_209553_a(ResourceLocation p_209553_0_, BlockState p_209553_1_) {
        return new ModelResourceLocation(p_209553_0_, BlockModelShapes.func_209552_a(p_209553_1_.func_206871_b()));
    }

    public static String func_209552_a(Map<Property<?>, Comparable<?>> p_209552_0_) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<Property<?>, Comparable<?>> entry : p_209552_0_.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(',');
            }
            Property<?> property = entry.getKey();
            stringbuilder.append(property.func_177701_a());
            stringbuilder.append('=');
            stringbuilder.append(BlockModelShapes.func_209555_a(property, entry.getValue()));
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String func_209555_a(Property<T> p_209555_0_, Comparable<?> p_209555_1_) {
        return p_209555_0_.func_177702_a(p_209555_1_);
    }
}

