/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class SilverfishEntity
extends MonsterEntity {
    private SummonSilverfishGoal field_175460_b;

    public SilverfishEntity(EntityType<? extends SilverfishEntity> p_i50195_1_, World p_i50195_2_) {
        super(p_i50195_1_, p_i50195_2_);
    }

    protected void func_184651_r() {
        this.field_175460_b = new SummonSilverfishGoal(this);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(3, (Goal)this.field_175460_b);
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new HideInStoneGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, true));
    }

    public double func_70033_W() {
        return 0.1;
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 0.13f;
    }

    public static AttributeModifierMap.MutableAttribute func_234301_m_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if ((p_70097_1_ instanceof EntityDamageSource || p_70097_1_ == DamageSource.field_76376_m) && this.field_175460_b != null) {
            this.field_175460_b.func_179462_f();
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        super.func_70071_h_();
    }

    public void func_181013_g(float p_181013_1_) {
        this.field_70177_z = p_181013_1_;
        super.func_181013_g(p_181013_1_);
    }

    public float func_205022_a(BlockPos p_205022_1_, IWorldReader p_205022_2_) {
        return SilverfishBlock.func_196466_i((BlockState)p_205022_2_.func_180495_p(p_205022_1_.func_177977_b())) ? 10.0f : super.func_205022_a(p_205022_1_, p_205022_2_);
    }

    public static boolean func_223331_b(EntityType<SilverfishEntity> p_223331_0_, IWorld p_223331_1_, SpawnReason p_223331_2_, BlockPos p_223331_3_, Random p_223331_4_) {
        if (SilverfishEntity.func_223324_d(p_223331_0_, (IWorld)p_223331_1_, (SpawnReason)p_223331_2_, (BlockPos)p_223331_3_, (Random)p_223331_4_)) {
            PlayerEntity playerentity = p_223331_1_.func_217366_a((double)p_223331_3_.func_177958_n() + 0.5, (double)p_223331_3_.func_177956_o() + 0.5, (double)p_223331_3_.func_177952_p() + 0.5, 5.0, true);
            return playerentity == null;
        }
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    static class SummonSilverfishGoal
    extends Goal {
        private final SilverfishEntity field_179464_a;
        private int field_179463_b;

        public SummonSilverfishGoal(SilverfishEntity p_i45826_1_) {
            this.field_179464_a = p_i45826_1_;
        }

        public void func_179462_f() {
            if (this.field_179463_b == 0) {
                this.field_179463_b = 20;
            }
        }

        public boolean func_75250_a() {
            return this.field_179463_b > 0;
        }

        public void func_75246_d() {
            --this.field_179463_b;
            if (this.field_179463_b <= 0) {
                World world = this.field_179464_a.field_70170_p;
                Random random = this.field_179464_a.func_70681_au();
                BlockPos blockpos = this.field_179464_a.func_233580_cy_();
                int i = 0;
                while (i <= 5 && i >= -5) {
                    int j = 0;
                    while (j <= 10 && j >= -10) {
                        int k = 0;
                        while (k <= 10 && k >= -10) {
                            BlockPos blockpos1 = blockpos.func_177982_a(j, i, k);
                            BlockState blockstate = world.func_180495_p(blockpos1);
                            Block block = blockstate.func_177230_c();
                            if (block instanceof SilverfishBlock) {
                                if (ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)((Object)this.field_179464_a))) {
                                    world.func_225521_a_(blockpos1, true, (Entity)((Object)this.field_179464_a));
                                } else {
                                    world.func_180501_a(blockpos1, ((SilverfishBlock)block).func_196468_d().func_176223_P(), 3);
                                }
                                if (random.nextBoolean()) {
                                    return;
                                }
                            }
                            k = (k <= 0 ? 1 : 0) - k;
                        }
                        j = (j <= 0 ? 1 : 0) - j;
                    }
                    i = (i <= 0 ? 1 : 0) - i;
                }
            }
        }
    }

    static class HideInStoneGoal
    extends RandomWalkingGoal {
        private Direction field_179483_b;
        private boolean field_179484_c;

        public HideInStoneGoal(SilverfishEntity p_i45827_1_) {
            super((CreatureEntity)p_i45827_1_, 1.0, 10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.field_75457_a.func_70681_au();
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_75457_a.field_70170_p, (Entity)this.field_75457_a) && random.nextInt(10) == 0) {
                this.field_179483_b = Direction.func_239631_a_(random);
                BlockPos blockpos = new BlockPos(this.field_75457_a.func_226277_ct_(), this.field_75457_a.func_226278_cu_() + 0.5, this.field_75457_a.func_226281_cx_()).func_177972_a(this.field_179483_b);
                BlockState blockstate = this.field_75457_a.field_70170_p.func_180495_p(blockpos);
                if (SilverfishBlock.func_196466_i((BlockState)blockstate)) {
                    this.field_179484_c = true;
                    return true;
                }
            }
            this.field_179484_c = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.field_179484_c ? false : super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.field_179484_c) {
                super.func_75249_e();
            } else {
                World iworld = this.field_75457_a.field_70170_p;
                BlockPos blockpos = new BlockPos(this.field_75457_a.func_226277_ct_(), this.field_75457_a.func_226278_cu_() + 0.5, this.field_75457_a.func_226281_cx_()).func_177972_a(this.field_179483_b);
                BlockState blockstate = iworld.func_180495_p(blockpos);
                if (SilverfishBlock.func_196466_i((BlockState)blockstate)) {
                    iworld.func_180501_a(blockpos, SilverfishBlock.func_196467_h((Block)blockstate.func_177230_c()), 3);
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
            }
        }
    }
}

