/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FallbackResourceManager
implements IResourceManager {
    private static final Logger field_199024_b = LogManager.getLogger();
    public final List<IResourcePack> field_199023_a = Lists.newArrayList();
    private final ResourcePackType field_199025_c;
    private final String field_230027_d;

    public FallbackResourceManager(ResourcePackType p_i226096_1_, String p_i226096_2_) {
        this.field_199025_c = p_i226096_1_;
        this.field_230027_d = p_i226096_2_;
    }

    public void func_199021_a(IResourcePack p_199021_1_) {
        this.field_199023_a.add(p_199021_1_);
    }

    @Override
    public Set<String> func_199001_a() {
        return ImmutableSet.of((Object)this.field_230027_d);
    }

    @Override
    public IResource func_199002_a(ResourceLocation p_199002_1_) throws IOException {
        this.func_199022_d(p_199002_1_);
        IResourcePack iresourcepack = null;
        ResourceLocation resourcelocation = FallbackResourceManager.func_199020_c(p_199002_1_);
        for (int i = this.field_199023_a.size() - 1; i >= 0; --i) {
            IResourcePack iresourcepack1 = this.field_199023_a.get(i);
            if (iresourcepack == null && iresourcepack1.func_195764_b(this.field_199025_c, resourcelocation)) {
                iresourcepack = iresourcepack1;
            }
            if (!iresourcepack1.func_195764_b(this.field_199025_c, p_199002_1_)) continue;
            InputStream inputstream = null;
            if (iresourcepack != null) {
                inputstream = this.func_199019_a(resourcelocation, iresourcepack);
            }
            return new SimpleResource(iresourcepack1.func_195762_a(), p_199002_1_, this.func_199019_a(p_199002_1_, iresourcepack1), inputstream);
        }
        throw new FileNotFoundException(p_199002_1_.toString());
    }

    @Override
    public boolean func_219533_b(ResourceLocation p_219533_1_) {
        if (!this.func_219541_f(p_219533_1_)) {
            return false;
        }
        for (int i = this.field_199023_a.size() - 1; i >= 0; --i) {
            IResourcePack iresourcepack = this.field_199023_a.get(i);
            if (!iresourcepack.func_195764_b(this.field_199025_c, p_219533_1_)) continue;
            return true;
        }
        return false;
    }

    protected InputStream func_199019_a(ResourceLocation p_199019_1_, IResourcePack p_199019_2_) throws IOException {
        InputStream inputstream = p_199019_2_.func_195761_a(this.field_199025_c, p_199019_1_);
        return field_199024_b.isDebugEnabled() ? new LeakComplainerInputStream(inputstream, p_199019_1_, p_199019_2_.func_195762_a()) : inputstream;
    }

    private void func_199022_d(ResourceLocation p_199022_1_) throws IOException {
        if (!this.func_219541_f(p_199022_1_)) {
            throw new IOException("Invalid relative path to resource: " + p_199022_1_);
        }
    }

    private boolean func_219541_f(ResourceLocation p_219541_1_) {
        return !p_219541_1_.func_110623_a().contains("..");
    }

    @Override
    public List<IResource> func_199004_b(ResourceLocation p_199004_1_) throws IOException {
        this.func_199022_d(p_199004_1_);
        ArrayList list = Lists.newArrayList();
        ResourceLocation resourcelocation = FallbackResourceManager.func_199020_c(p_199004_1_);
        for (IResourcePack iresourcepack : this.field_199023_a) {
            if (!iresourcepack.func_195764_b(this.field_199025_c, p_199004_1_)) continue;
            InputStream inputstream = iresourcepack.func_195764_b(this.field_199025_c, resourcelocation) ? this.func_199019_a(resourcelocation, iresourcepack) : null;
            list.add(new SimpleResource(iresourcepack.func_195762_a(), p_199004_1_, this.func_199019_a(p_199004_1_, iresourcepack), inputstream));
        }
        if (list.isEmpty()) {
            throw new FileNotFoundException(p_199004_1_.toString());
        }
        return list;
    }

    @Override
    public Collection<ResourceLocation> func_199003_a(String p_199003_1_, Predicate<String> p_199003_2_) {
        ArrayList list = Lists.newArrayList();
        for (IResourcePack iresourcepack : this.field_199023_a) {
            list.addAll(iresourcepack.func_225637_a_(this.field_199025_c, this.field_230027_d, p_199003_1_, Integer.MAX_VALUE, p_199003_2_));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Stream<IResourcePack> func_230232_b_() {
        return this.field_199023_a.stream();
    }

    static ResourceLocation func_199020_c(ResourceLocation p_199020_0_) {
        return new ResourceLocation(p_199020_0_.func_110624_b(), p_199020_0_.func_110623_a() + ".mcmeta");
    }

    static class LeakComplainerInputStream
    extends FilterInputStream {
        private final String field_198999_b;
        private boolean field_199000_c;

        public LeakComplainerInputStream(InputStream p_i47727_1_, ResourceLocation p_i47727_2_, String p_i47727_3_) {
            super(p_i47727_1_);
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(bytearrayoutputstream));
            this.field_198999_b = "Leaked resource: '" + p_i47727_2_ + "' loaded from pack: '" + p_i47727_3_ + "'\n" + bytearrayoutputstream;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.field_199000_c = true;
        }

        protected void finalize() throws Throwable {
            if (!this.field_199000_c) {
                field_199024_b.warn(this.field_198999_b);
            }
            super.finalize();
        }
    }
}

