/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.OceanMonumentPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class OceanMonumentStructure
extends Structure<NoFeatureConfig> {
    private static final List<MobSpawnInfo.Spawners> field_175803_h = ImmutableList.of((Object)((Object)new MobSpawnInfo.Spawners(EntityType.field_200761_A, 1, 2, 4)));

    public OceanMonumentStructure(Codec<NoFeatureConfig> p_i231975_1_) {
        super(p_i231975_1_);
    }

    @Override
    protected boolean func_230365_b_() {
        return false;
    }

    @Override
    protected boolean func_230363_a_(ChunkGenerator p_230363_1_, BiomeProvider p_230363_2_, long p_230363_3_, SharedSeedRandom p_230363_5_, int p_230363_6_, int p_230363_7_, Biome p_230363_8_, ChunkPos p_230363_9_, NoFeatureConfig p_230363_10_) {
        for (Biome biome : p_230363_2_.func_225530_a_(p_230363_6_ * 16 + 9, p_230363_1_.func_230356_f_(), p_230363_7_ * 16 + 9, 16)) {
            if (biome.func_242440_e().func_242493_a(this)) continue;
            return false;
        }
        for (Biome biome1 : p_230363_2_.func_225530_a_(p_230363_6_ * 16 + 9, p_230363_1_.func_230356_f_(), p_230363_7_ * 16 + 9, 29)) {
            if (biome1.func_201856_r() == Biome.Category.OCEAN || biome1.func_201856_r() == Biome.Category.RIVER) continue;
            return false;
        }
        return true;
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return field_175803_h;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        private boolean field_175790_d;

        public Start(Structure<NoFeatureConfig> p_i225814_1_, int p_i225814_2_, int p_i225814_3_, MutableBoundingBox p_i225814_4_, int p_i225814_5_, long p_i225814_6_) {
            super(p_i225814_1_, p_i225814_2_, p_i225814_3_, p_i225814_4_, p_i225814_5_, p_i225814_6_);
        }

        @Override
        public void func_230364_a_(DynamicRegistries p_230364_1_, ChunkGenerator p_230364_2_, TemplateManager p_230364_3_, int p_230364_4_, int p_230364_5_, Biome p_230364_6_, NoFeatureConfig p_230364_7_) {
            this.func_214633_b(p_230364_4_, p_230364_5_);
        }

        private void func_214633_b(int p_214633_1_, int p_214633_2_) {
            int i = p_214633_1_ * 16 - 29;
            int j = p_214633_2_ * 16 - 29;
            Direction direction = Direction.Plane.HORIZONTAL.func_179518_a((Random)this.field_214631_d);
            this.field_75075_a.add(new OceanMonumentPieces.MonumentBuilding((Random)this.field_214631_d, i, j, direction));
            this.func_202500_a();
            this.field_175790_d = true;
        }

        @Override
        public void func_230366_a_(ISeedReader p_230366_1_, StructureManager p_230366_2_, ChunkGenerator p_230366_3_, Random p_230366_4_, MutableBoundingBox p_230366_5_, ChunkPos p_230366_6_) {
            if (!this.field_175790_d) {
                this.field_75075_a.clear();
                this.func_214633_b(this.func_143019_e(), this.func_143018_f());
            }
            super.func_230366_a_(p_230366_1_, p_230366_2_, p_230366_3_, p_230366_4_, p_230366_5_, p_230366_6_);
        }
    }
}

