/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.IExtensibleEnum;

public class Raid {
    private static final ITextComponent field_221338_b = new TranslationTextComponent("event.minecraft.raid");
    private static final ITextComponent field_221339_c = new TranslationTextComponent("event.minecraft.raid.victory");
    private static final ITextComponent field_221340_d = new TranslationTextComponent("event.minecraft.raid.defeat");
    private static final ITextComponent field_221341_e = field_221338_b.func_230532_e_().func_240702_b_(" - ").func_230529_a_(field_221339_c);
    private static final ITextComponent field_221342_f = field_221338_b.func_230532_e_().func_240702_b_(" - ").func_230529_a_(field_221340_d);
    private final Map<Integer, AbstractRaiderEntity> field_221343_g = Maps.newHashMap();
    private final Map<Integer, Set<AbstractRaiderEntity>> field_221344_h = Maps.newHashMap();
    private final Set<UUID> field_221345_i = Sets.newHashSet();
    private long field_221346_j;
    private BlockPos field_221347_k;
    private final ServerWorld field_221348_l;
    private boolean field_221349_m;
    private final int field_221350_n;
    private float field_221351_o;
    private int field_221352_p;
    private boolean field_221353_q;
    private int field_221354_r;
    private final ServerBossInfo field_221355_s = new ServerBossInfo(field_221338_b, BossInfo.Color.RED, BossInfo.Overlay.NOTCHED_10);
    private int field_221356_t;
    private int field_221357_u;
    private final Random field_221358_v = new Random();
    private final int field_221359_w;
    private Status field_221360_x;
    private int field_221361_y;
    private Optional<BlockPos> field_221362_z = Optional.empty();

    public Raid(int p_i50144_1_, ServerWorld p_i50144_2_, BlockPos p_i50144_3_) {
        this.field_221350_n = p_i50144_1_;
        this.field_221348_l = p_i50144_2_;
        this.field_221353_q = true;
        this.field_221357_u = 300;
        this.field_221355_s.func_186735_a(0.0f);
        this.field_221347_k = p_i50144_3_;
        this.field_221359_w = this.func_221306_a(p_i50144_2_.func_175659_aa());
        this.field_221360_x = Status.ONGOING;
    }

    public Raid(ServerWorld p_i50145_1_, CompoundNBT p_i50145_2_) {
        this.field_221348_l = p_i50145_1_;
        this.field_221350_n = p_i50145_2_.func_74762_e("Id");
        this.field_221349_m = p_i50145_2_.func_74767_n("Started");
        this.field_221353_q = p_i50145_2_.func_74767_n("Active");
        this.field_221346_j = p_i50145_2_.func_74763_f("TicksActive");
        this.field_221352_p = p_i50145_2_.func_74762_e("BadOmenLevel");
        this.field_221354_r = p_i50145_2_.func_74762_e("GroupsSpawned");
        this.field_221357_u = p_i50145_2_.func_74762_e("PreRaidTicks");
        this.field_221356_t = p_i50145_2_.func_74762_e("PostRaidTicks");
        this.field_221351_o = p_i50145_2_.func_74760_g("TotalHealth");
        this.field_221347_k = new BlockPos(p_i50145_2_.func_74762_e("CX"), p_i50145_2_.func_74762_e("CY"), p_i50145_2_.func_74762_e("CZ"));
        this.field_221359_w = p_i50145_2_.func_74762_e("NumGroups");
        this.field_221360_x = Status.func_221275_b(p_i50145_2_.func_74779_i("Status"));
        this.field_221345_i.clear();
        if (p_i50145_2_.func_150297_b("HeroesOfTheVillage", 9)) {
            ListNBT listnbt = p_i50145_2_.func_150295_c("HeroesOfTheVillage", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.field_221345_i.add(NBTUtil.func_186860_b((INBT)listnbt.get(i)));
            }
        }
    }

    public boolean func_221319_a() {
        return this.func_221321_e() || this.func_221336_f();
    }

    public boolean func_221334_b() {
        return this.func_221297_c() && this.func_221303_s() == 0 && this.field_221357_u > 0;
    }

    public boolean func_221297_c() {
        return this.field_221354_r > 0;
    }

    public boolean func_221310_d() {
        return this.field_221360_x == Status.STOPPED;
    }

    public boolean func_221321_e() {
        return this.field_221360_x == Status.VICTORY;
    }

    public boolean func_221336_f() {
        return this.field_221360_x == Status.LOSS;
    }

    public World func_221316_i() {
        return this.field_221348_l;
    }

    public boolean func_221301_k() {
        return this.field_221349_m;
    }

    public int func_221315_l() {
        return this.field_221354_r;
    }

    private Predicate<ServerPlayerEntity> func_221299_x() {
        return p_221302_1_ -> {
            BlockPos blockpos = p_221302_1_.func_233580_cy_();
            return p_221302_1_.func_70089_S() && this.field_221348_l.func_217475_c_(blockpos) == this;
        };
    }

    private void func_221329_y() {
        HashSet set = Sets.newHashSet((Iterable)this.field_221355_s.func_186757_c());
        List<ServerPlayerEntity> list = this.field_221348_l.func_217490_a(this.func_221299_x());
        for (ServerPlayerEntity serverplayerentity : list) {
            if (set.contains((Object)serverplayerentity)) continue;
            this.field_221355_s.func_186760_a(serverplayerentity);
        }
        for (ServerPlayerEntity serverplayerentity1 : set) {
            if (list.contains((Object)serverplayerentity1)) continue;
            this.field_221355_s.func_186761_b(serverplayerentity1);
        }
    }

    public int func_221327_m() {
        return 5;
    }

    public int func_221291_n() {
        return this.field_221352_p;
    }

    public void func_221309_a(PlayerEntity p_221309_1_) {
        if (p_221309_1_.func_70644_a(Effects.field_220309_E)) {
            this.field_221352_p += p_221309_1_.func_70660_b(Effects.field_220309_E).func_76458_c() + 1;
            this.field_221352_p = MathHelper.func_76125_a((int)this.field_221352_p, (int)0, (int)this.func_221327_m());
        }
        p_221309_1_.func_195063_d(Effects.field_220309_E);
    }

    public void func_221295_o() {
        this.field_221353_q = false;
        this.field_221355_s.func_201360_b();
        this.field_221360_x = Status.STOPPED;
    }

    public void func_221307_p() {
        if (!this.func_221310_d()) {
            if (this.field_221360_x == Status.ONGOING) {
                boolean flag = this.field_221353_q;
                this.field_221353_q = this.field_221348_l.func_175667_e(this.field_221347_k);
                if (this.field_221348_l.func_175659_aa() == Difficulty.PEACEFUL) {
                    this.func_221295_o();
                    return;
                }
                if (flag != this.field_221353_q) {
                    this.field_221355_s.func_186758_d(this.field_221353_q);
                }
                if (!this.field_221353_q) {
                    return;
                }
                if (!this.field_221348_l.func_217483_b_(this.field_221347_k)) {
                    this.func_223027_y();
                }
                if (!this.field_221348_l.func_217483_b_(this.field_221347_k)) {
                    if (this.field_221354_r > 0) {
                        this.field_221360_x = Status.LOSS;
                    } else {
                        this.func_221295_o();
                    }
                }
                ++this.field_221346_j;
                if (this.field_221346_j >= 48000L) {
                    this.func_221295_o();
                    return;
                }
                int i = this.func_221303_s();
                if (i == 0 && this.func_221289_z()) {
                    if (this.field_221357_u <= 0) {
                        if (this.field_221357_u == 0 && this.field_221354_r > 0) {
                            this.field_221357_u = 300;
                            this.field_221355_s.func_186739_a(field_221338_b);
                            return;
                        }
                    } else {
                        boolean flag2;
                        boolean flag1 = this.field_221362_z.isPresent();
                        boolean bl = flag2 = !flag1 && this.field_221357_u % 5 == 0;
                        if (flag1 && !this.field_221348_l.func_72863_F().func_222865_a(new ChunkPos(this.field_221362_z.get()))) {
                            flag2 = true;
                        }
                        if (flag2) {
                            int j = 0;
                            if (this.field_221357_u < 100) {
                                j = 1;
                            } else if (this.field_221357_u < 40) {
                                j = 2;
                            }
                            this.field_221362_z = this.func_221313_d(j);
                        }
                        if (this.field_221357_u == 300 || this.field_221357_u % 20 == 0) {
                            this.func_221329_y();
                        }
                        --this.field_221357_u;
                        this.field_221355_s.func_186735_a(MathHelper.func_76131_a((float)((float)(300 - this.field_221357_u) / 300.0f), (float)0.0f, (float)1.0f));
                    }
                }
                if (this.field_221346_j % 20L == 0L) {
                    this.func_221329_y();
                    this.func_221292_E();
                    if (i > 0) {
                        if (i <= 2) {
                            this.field_221355_s.func_186739_a((ITextComponent)field_221338_b.func_230532_e_().func_240702_b_(" - ").func_230529_a_((ITextComponent)new TranslationTextComponent("event.minecraft.raid.raiders_remaining", i)));
                        } else {
                            this.field_221355_s.func_186739_a(field_221338_b);
                        }
                    } else {
                        this.field_221355_s.func_186739_a(field_221338_b);
                    }
                }
                boolean flag3 = false;
                int k = 0;
                while (this.func_221318_F()) {
                    BlockPos blockpos;
                    BlockPos blockPos = blockpos = this.field_221362_z.isPresent() ? this.field_221362_z.get() : this.func_221298_a(k, 20);
                    if (blockpos != null) {
                        this.field_221349_m = true;
                        this.func_221294_b(blockpos);
                        if (!flag3) {
                            this.func_221293_a(blockpos);
                            flag3 = true;
                        }
                    } else {
                        ++k;
                    }
                    if (k <= 3) continue;
                    this.func_221295_o();
                    break;
                }
                if (this.func_221301_k() && !this.func_221289_z() && i == 0) {
                    if (this.field_221356_t < 40) {
                        ++this.field_221356_t;
                    } else {
                        this.field_221360_x = Status.VICTORY;
                        for (UUID uuid : this.field_221345_i) {
                            Entity entity = this.field_221348_l.func_217461_a(uuid);
                            if (!(entity instanceof LivingEntity) || entity.func_175149_v()) continue;
                            LivingEntity livingentity = (LivingEntity)entity;
                            livingentity.func_195064_c(new EffectInstance(Effects.field_220310_F, 48000, this.field_221352_p - 1, false, false, true));
                            if (!(livingentity instanceof ServerPlayerEntity)) continue;
                            ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)livingentity;
                            serverplayerentity.func_195066_a(Stats.field_219742_az);
                            CriteriaTriggers.field_215101_H.func_192215_a(serverplayerentity);
                        }
                    }
                }
                this.func_221331_G();
            } else if (this.func_221319_a()) {
                ++this.field_221361_y;
                if (this.field_221361_y >= 600) {
                    this.func_221295_o();
                    return;
                }
                if (this.field_221361_y % 20 == 0) {
                    this.func_221329_y();
                    this.field_221355_s.func_186758_d(true);
                    if (this.func_221321_e()) {
                        this.field_221355_s.func_186735_a(0.0f);
                        this.field_221355_s.func_186739_a(field_221341_e);
                    } else {
                        this.field_221355_s.func_186739_a(field_221342_f);
                    }
                }
            }
        }
    }

    private void func_223027_y() {
        Stream stream = SectionPos.func_218158_a((SectionPos)SectionPos.func_218167_a((BlockPos)this.field_221347_k), (int)2);
        stream.filter(this.field_221348_l::func_222887_a).map(SectionPos::func_218160_t).min(Comparator.comparingDouble(p_223025_1_ -> p_223025_1_.func_177951_i((Vector3i)this.field_221347_k))).ifPresent(this::func_223024_c);
    }

    private Optional<BlockPos> func_221313_d(int p_221313_1_) {
        for (int i = 0; i < 3; ++i) {
            BlockPos blockpos = this.func_221298_a(p_221313_1_, 1);
            if (blockpos == null) continue;
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }

    private boolean func_221289_z() {
        if (this.func_221328_B()) {
            return !this.func_221314_C();
        }
        return !this.func_221288_A();
    }

    private boolean func_221288_A() {
        return this.func_221315_l() == this.field_221359_w;
    }

    private boolean func_221328_B() {
        return this.field_221352_p > 1;
    }

    private boolean func_221314_C() {
        return this.func_221315_l() > this.field_221359_w;
    }

    private boolean func_221305_D() {
        return this.func_221288_A() && this.func_221303_s() == 0 && this.func_221328_B();
    }

    private void func_221292_E() {
        Iterator<Set<AbstractRaiderEntity>> iterator = this.field_221344_h.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<AbstractRaiderEntity> set1 = iterator.next();
            for (AbstractRaiderEntity abstractraiderentity : set1) {
                BlockPos blockpos = abstractraiderentity.func_233580_cy_();
                if (!abstractraiderentity.field_70128_L && abstractraiderentity.field_70170_p.func_234923_W_() == this.field_221348_l.func_234923_W_() && !(this.field_221347_k.func_177951_i((Vector3i)blockpos) >= 12544.0)) {
                    if (abstractraiderentity.field_70173_aa <= 600) continue;
                    if (this.field_221348_l.func_217461_a(abstractraiderentity.func_110124_au()) == null) {
                        set.add(abstractraiderentity);
                    }
                    if (!this.field_221348_l.func_217483_b_(blockpos) && abstractraiderentity.func_70654_ax() > 2400) {
                        abstractraiderentity.func_213653_b(abstractraiderentity.func_213661_eo() + 1);
                    }
                    if (abstractraiderentity.func_213661_eo() < 30) continue;
                    set.add(abstractraiderentity);
                    continue;
                }
                set.add(abstractraiderentity);
            }
        }
        for (AbstractRaiderEntity abstractraiderentity1 : set) {
            this.func_221322_a(abstractraiderentity1, true);
        }
    }

    private void func_221293_a(BlockPos p_221293_1_) {
        float f = 13.0f;
        int i = 64;
        Collection collection = this.field_221355_s.func_186757_c();
        for (ServerPlayerEntity serverplayerentity : this.field_221348_l.func_217369_A()) {
            Vector3d vector3d = serverplayerentity.func_213303_ch();
            Vector3d vector3d1 = Vector3d.func_237489_a_((Vector3i)p_221293_1_);
            float f1 = MathHelper.func_76133_a((double)((vector3d1.field_72450_a - vector3d.field_72450_a) * (vector3d1.field_72450_a - vector3d.field_72450_a) + (vector3d1.field_72449_c - vector3d.field_72449_c) * (vector3d1.field_72449_c - vector3d.field_72449_c)));
            double d0 = vector3d.field_72450_a + (double)(13.0f / f1) * (vector3d1.field_72450_a - vector3d.field_72450_a);
            double d1 = vector3d.field_72449_c + (double)(13.0f / f1) * (vector3d1.field_72449_c - vector3d.field_72449_c);
            if (!(f1 <= 64.0f) && !collection.contains((Object)serverplayerentity)) continue;
            serverplayerentity.field_71135_a.func_147359_a((IPacket<?>)new SPlaySoundEffectPacket(SoundEvents.field_219690_jn, SoundCategory.NEUTRAL, d0, serverplayerentity.func_226278_cu_(), d1, 64.0f, 1.0f));
        }
    }

    private void func_221294_b(BlockPos p_221294_1_) {
        boolean flag = false;
        int i = this.field_221354_r + 1;
        this.field_221351_o = 0.0f;
        DifficultyInstance difficultyinstance = this.field_221348_l.func_175649_E(p_221294_1_);
        boolean flag1 = this.func_221305_D();
        for (WaveMember raid$wavemember : WaveMember.field_221284_f) {
            int j = this.func_221330_a(raid$wavemember, i, flag1) + this.func_221335_a(raid$wavemember, this.field_221358_v, i, difficultyinstance, flag1);
            int k = 0;
            for (int l = 0; l < j; ++l) {
                AbstractRaiderEntity abstractraiderentity = (AbstractRaiderEntity)raid$wavemember.field_221285_g.func_200721_a(this.field_221348_l);
                if (!flag && abstractraiderentity.func_213637_dY()) {
                    abstractraiderentity.func_213635_r(true);
                    this.func_221324_a(i, abstractraiderentity);
                    flag = true;
                }
                this.func_221317_a(i, abstractraiderentity, p_221294_1_, false);
                if (raid$wavemember.field_221285_g != EntityType.field_220352_aU) continue;
                AbstractRaiderEntity abstractraiderentity1 = null;
                if (i == this.func_221306_a(Difficulty.NORMAL)) {
                    abstractraiderentity1 = (AbstractRaiderEntity)EntityType.field_220350_aJ.func_200721_a(this.field_221348_l);
                } else if (i >= this.func_221306_a(Difficulty.HARD)) {
                    abstractraiderentity1 = k == 0 ? (AbstractRaiderEntity)EntityType.field_200806_t.func_200721_a(this.field_221348_l) : (AbstractRaiderEntity)EntityType.field_200758_ax.func_200721_a(this.field_221348_l);
                }
                ++k;
                if (abstractraiderentity1 == null) continue;
                this.func_221317_a(i, abstractraiderentity1, p_221294_1_, false);
                abstractraiderentity1.func_174828_a(p_221294_1_, 0.0f, 0.0f);
                abstractraiderentity1.func_184220_m((Entity)abstractraiderentity);
            }
        }
        this.field_221362_z = Optional.empty();
        ++this.field_221354_r;
        this.func_221320_q();
        this.func_221331_G();
    }

    public void func_221317_a(int p_221317_1_, AbstractRaiderEntity p_221317_2_, @Nullable BlockPos p_221317_3_, boolean p_221317_4_) {
        boolean flag = this.func_221287_b(p_221317_1_, p_221317_2_);
        if (flag) {
            p_221317_2_.func_213652_a(this);
            p_221317_2_.func_213651_a(p_221317_1_);
            p_221317_2_.func_213644_t(true);
            p_221317_2_.func_213653_b(0);
            if (!p_221317_4_ && p_221317_3_ != null) {
                p_221317_2_.func_70107_b((double)p_221317_3_.func_177958_n() + 0.5, (double)p_221317_3_.func_177956_o() + 1.0, (double)p_221317_3_.func_177952_p() + 0.5);
                p_221317_2_.func_213386_a((IServerWorld)this.field_221348_l, this.field_221348_l.func_175649_E(p_221317_3_), SpawnReason.EVENT, (ILivingEntityData)null, (CompoundNBT)null);
                p_221317_2_.func_213660_a(p_221317_1_, false);
                p_221317_2_.func_230245_c_(true);
                this.field_221348_l.func_242417_l((Entity)p_221317_2_);
            }
        }
    }

    public void func_221320_q() {
        this.field_221355_s.func_186735_a(MathHelper.func_76131_a((float)(this.func_221290_r() / this.field_221351_o), (float)0.0f, (float)1.0f));
    }

    public float func_221290_r() {
        float f = 0.0f;
        for (Set<AbstractRaiderEntity> set : this.field_221344_h.values()) {
            for (AbstractRaiderEntity abstractraiderentity : set) {
                f += abstractraiderentity.func_110143_aJ();
            }
        }
        return f;
    }

    private boolean func_221318_F() {
        return this.field_221357_u == 0 && (this.field_221354_r < this.field_221359_w || this.func_221305_D()) && this.func_221303_s() == 0;
    }

    public int func_221303_s() {
        return this.field_221344_h.values().stream().mapToInt(Set::size).sum();
    }

    public void func_221322_a(AbstractRaiderEntity p_221322_1_, boolean p_221322_2_) {
        boolean flag;
        Set<AbstractRaiderEntity> set = this.field_221344_h.get(p_221322_1_.func_213642_em());
        if (set != null && (flag = set.remove(p_221322_1_))) {
            if (p_221322_2_) {
                this.field_221351_o -= p_221322_1_.func_110143_aJ();
            }
            p_221322_1_.func_213652_a((Raid)null);
            this.func_221320_q();
            this.func_221331_G();
        }
    }

    private void func_221331_G() {
        this.field_221348_l.func_217452_C().func_76185_a();
    }

    public static ItemStack func_221312_H() {
        ItemStack itemstack = new ItemStack(Items.field_196191_eg);
        CompoundNBT compoundnbt = itemstack.func_190925_c("BlockEntityTag");
        ListNBT listnbt = new BannerPattern.Builder().func_222477_a(BannerPattern.RHOMBUS_MIDDLE, DyeColor.CYAN).func_222477_a(BannerPattern.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.STRIPE_CENTER, DyeColor.GRAY).func_222477_a(BannerPattern.BORDER, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.STRIPE_MIDDLE, DyeColor.BLACK).func_222477_a(BannerPattern.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.CIRCLE_MIDDLE, DyeColor.LIGHT_GRAY).func_222477_a(BannerPattern.BORDER, DyeColor.BLACK).func_222476_a();
        compoundnbt.func_218657_a("Patterns", (INBT)listnbt);
        itemstack.func_242395_a(ItemStack.TooltipDisplayFlags.ADDITIONAL);
        itemstack.func_200302_a((ITextComponent)new TranslationTextComponent("block.minecraft.ominous_banner").func_240699_a_(TextFormatting.GOLD));
        return itemstack;
    }

    @Nullable
    public AbstractRaiderEntity func_221332_b(int p_221332_1_) {
        return this.field_221343_g.get(p_221332_1_);
    }

    @Nullable
    private BlockPos func_221298_a(int p_221298_1_, int p_221298_2_) {
        int i = p_221298_1_ == 0 ? 2 : 2 - p_221298_1_;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i1 = 0; i1 < p_221298_2_; ++i1) {
            float f = this.field_221348_l.field_73012_v.nextFloat() * ((float)Math.PI * 2);
            int j = this.field_221347_k.func_177958_n() + MathHelper.func_76141_d((float)(MathHelper.func_76134_b((float)f) * 32.0f * (float)i)) + this.field_221348_l.field_73012_v.nextInt(5);
            int l = this.field_221347_k.func_177952_p() + MathHelper.func_76141_d((float)(MathHelper.func_76126_a((float)f) * 32.0f * (float)i)) + this.field_221348_l.field_73012_v.nextInt(5);
            int k = this.field_221348_l.func_201676_a(Heightmap.Type.WORLD_SURFACE, j, l);
            blockpos$mutable.func_181079_c(j, k, l);
            if (this.field_221348_l.func_217483_b_((BlockPos)blockpos$mutable) && p_221298_1_ < 2 || !this.field_221348_l.func_217344_a(blockpos$mutable.func_177958_n() - 10, blockpos$mutable.func_177956_o() - 10, blockpos$mutable.func_177952_p() - 10, blockpos$mutable.func_177958_n() + 10, blockpos$mutable.func_177956_o() + 10, blockpos$mutable.func_177952_p() + 10) || !this.field_221348_l.func_72863_F().func_222865_a(new ChunkPos((BlockPos)blockpos$mutable)) || !WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)((Object)this.field_221348_l), (BlockPos)blockpos$mutable, EntityType.field_220352_aU) && (!this.field_221348_l.func_180495_p(blockpos$mutable.func_177977_b()).func_203425_a(Blocks.field_150433_aE) || !this.field_221348_l.func_180495_p((BlockPos)blockpos$mutable).func_196958_f())) continue;
            return blockpos$mutable;
        }
        return null;
    }

    private boolean func_221287_b(int p_221287_1_, AbstractRaiderEntity p_221287_2_) {
        return this.func_221300_a(p_221287_1_, p_221287_2_, true);
    }

    public boolean func_221300_a(int p_221300_1_, AbstractRaiderEntity p_221300_2_, boolean p_221300_3_) {
        this.field_221344_h.computeIfAbsent(p_221300_1_, p_221323_0_ -> Sets.newHashSet());
        Set<AbstractRaiderEntity> set = this.field_221344_h.get(p_221300_1_);
        AbstractRaiderEntity abstractraiderentity = null;
        for (AbstractRaiderEntity abstractraiderentity1 : set) {
            if (!abstractraiderentity1.func_110124_au().equals(p_221300_2_.func_110124_au())) continue;
            abstractraiderentity = abstractraiderentity1;
            break;
        }
        if (abstractraiderentity != null) {
            set.remove(abstractraiderentity);
            set.add(p_221300_2_);
        }
        set.add(p_221300_2_);
        if (p_221300_3_) {
            this.field_221351_o += p_221300_2_.func_110143_aJ();
        }
        this.func_221320_q();
        this.func_221331_G();
        return true;
    }

    public void func_221324_a(int p_221324_1_, AbstractRaiderEntity p_221324_2_) {
        this.field_221343_g.put(p_221324_1_, p_221324_2_);
        p_221324_2_.func_184201_a(EquipmentSlotType.HEAD, Raid.func_221312_H());
        p_221324_2_.func_184642_a(EquipmentSlotType.HEAD, 2.0f);
    }

    public void func_221296_c(int p_221296_1_) {
        this.field_221343_g.remove(p_221296_1_);
    }

    public BlockPos func_221304_t() {
        return this.field_221347_k;
    }

    private void func_223024_c(BlockPos p_223024_1_) {
        this.field_221347_k = p_223024_1_;
    }

    public int func_221325_u() {
        return this.field_221350_n;
    }

    private int func_221330_a(WaveMember p_221330_1_, int p_221330_2_, boolean p_221330_3_) {
        return p_221330_3_ ? p_221330_1_.field_221286_h[this.field_221359_w] : p_221330_1_.field_221286_h[p_221330_2_];
    }

    private int func_221335_a(WaveMember p_221335_1_, Random p_221335_2_, int p_221335_3_, DifficultyInstance p_221335_4_, boolean p_221335_5_) {
        int i;
        Difficulty difficulty = p_221335_4_.func_203095_a();
        boolean flag = difficulty == Difficulty.EASY;
        boolean flag1 = difficulty == Difficulty.NORMAL;
        switch (p_221335_1_) {
            case WITCH: {
                if (flag || p_221335_3_ <= 2 || p_221335_3_ == 4) {
                    return 0;
                }
                i = 1;
                break;
            }
            case PILLAGER: 
            case VINDICATOR: {
                if (flag) {
                    i = p_221335_2_.nextInt(2);
                    break;
                }
                if (flag1) {
                    i = 1;
                    break;
                }
                i = 2;
                break;
            }
            case RAVAGER: {
                i = !flag && p_221335_5_ ? 1 : 0;
                break;
            }
            default: {
                return 0;
            }
        }
        return i > 0 ? p_221335_2_.nextInt(i + 1) : 0;
    }

    public boolean func_221333_v() {
        return this.field_221353_q;
    }

    public CompoundNBT func_221326_a(CompoundNBT p_221326_1_) {
        p_221326_1_.func_74768_a("Id", this.field_221350_n);
        p_221326_1_.func_74757_a("Started", this.field_221349_m);
        p_221326_1_.func_74757_a("Active", this.field_221353_q);
        p_221326_1_.func_74772_a("TicksActive", this.field_221346_j);
        p_221326_1_.func_74768_a("BadOmenLevel", this.field_221352_p);
        p_221326_1_.func_74768_a("GroupsSpawned", this.field_221354_r);
        p_221326_1_.func_74768_a("PreRaidTicks", this.field_221357_u);
        p_221326_1_.func_74768_a("PostRaidTicks", this.field_221356_t);
        p_221326_1_.func_74776_a("TotalHealth", this.field_221351_o);
        p_221326_1_.func_74768_a("NumGroups", this.field_221359_w);
        p_221326_1_.func_74778_a("Status", this.field_221360_x.func_221277_a());
        p_221326_1_.func_74768_a("CX", this.field_221347_k.func_177958_n());
        p_221326_1_.func_74768_a("CY", this.field_221347_k.func_177956_o());
        p_221326_1_.func_74768_a("CZ", this.field_221347_k.func_177952_p());
        ListNBT listnbt = new ListNBT();
        for (UUID uuid : this.field_221345_i) {
            listnbt.add((Object)NBTUtil.func_240626_a_((UUID)uuid));
        }
        p_221326_1_.func_218657_a("HeroesOfTheVillage", (INBT)listnbt);
        return p_221326_1_;
    }

    public int func_221306_a(Difficulty p_221306_1_) {
        switch (p_221306_1_) {
            case EASY: {
                return 3;
            }
            case NORMAL: {
                return 5;
            }
            case HARD: {
                return 7;
            }
        }
        return 0;
    }

    public float func_221308_w() {
        int i = this.func_221291_n();
        if (i == 2) {
            return 0.1f;
        }
        if (i == 3) {
            return 0.25f;
        }
        if (i == 4) {
            return 0.5f;
        }
        return i == 5 ? 0.75f : 0.0f;
    }

    public void func_221311_a(Entity p_221311_1_) {
        this.field_221345_i.add(p_221311_1_.func_110124_au());
    }

    public static enum WaveMember implements IExtensibleEnum
    {
        VINDICATOR(EntityType.field_200758_ax, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityType.field_200806_t, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityType.field_220350_aJ, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityType.field_200759_ay, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityType.field_220352_aU, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        private static WaveMember[] field_221284_f;
        private final EntityType<? extends AbstractRaiderEntity> field_221285_g;
        private final int[] field_221286_h;

        private WaveMember(EntityType<? extends AbstractRaiderEntity> p_i50602_3_, int[] p_i50602_4_) {
            this.field_221285_g = p_i50602_3_;
            this.field_221286_h = p_i50602_4_;
        }

        public static WaveMember create(String name, EntityType<? extends AbstractRaiderEntity> typeIn, int[] waveCountsIn) {
            throw new IllegalStateException("Enum not extended");
        }

        @Deprecated
        public void init() {
            field_221284_f = WaveMember.values();
        }

        static {
            field_221284_f = WaveMember.values();
        }
    }

    static enum Status {
        ONGOING,
        VICTORY,
        LOSS,
        STOPPED;

        private static final Status[] field_221278_e;

        private static Status func_221275_b(String p_221275_0_) {
            for (Status raid$status : field_221278_e) {
                if (!p_221275_0_.equalsIgnoreCase(raid$status.name())) continue;
                return raid$status;
            }
            return ONGOING;
        }

        public String func_221277_a() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            field_221278_e = Status.values();
        }
    }
}

