/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class SingleItemRecipeBuilder {
    private final Item field_218649_a;
    private final Ingredient field_218650_b;
    private final int field_218651_c;
    private final Advancement.Builder field_218652_d = Advancement.Builder.func_200278_a();
    private String field_218653_e;
    private final IRecipeSerializer<?> field_218654_f;

    public SingleItemRecipeBuilder(IRecipeSerializer<?> iRecipeSerializer, Ingredient ingredient, IItemProvider iItemProvider, int n) {
        this.field_218654_f = iRecipeSerializer;
        this.field_218649_a = iItemProvider.func_199767_j();
        this.field_218650_b = ingredient;
        this.field_218651_c = n;
    }

    public static SingleItemRecipeBuilder func_218648_a(Ingredient ingredient, IItemProvider iItemProvider) {
        return new SingleItemRecipeBuilder(IRecipeSerializer.field_222175_s, ingredient, iItemProvider, 1);
    }

    public static SingleItemRecipeBuilder func_218644_a(Ingredient ingredient, IItemProvider iItemProvider, int n) {
        return new SingleItemRecipeBuilder(IRecipeSerializer.field_222175_s, ingredient, iItemProvider, n);
    }

    public SingleItemRecipeBuilder func_218643_a(String string, ICriterionInstance iCriterionInstance) {
        this.field_218652_d.func_200275_a(string, iCriterionInstance);
        return this;
    }

    public void func_218645_a(Consumer<IFinishedRecipe> consumer, String string) {
        ResourceLocation resourceLocation = Registry.field_212630_s.func_177774_c(this.field_218649_a);
        if (new ResourceLocation(string).equals(resourceLocation)) {
            throw new IllegalStateException("Single Item Recipe " + string + " should remove its 'save' argument");
        }
        this.func_218647_a(consumer, new ResourceLocation(string));
    }

    public void func_218647_a(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.func_218646_a(resourceLocation);
        this.field_218652_d.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", RecipeUnlockedTrigger.func_235675_a_(resourceLocation)).func_200271_a(AdvancementRewards.Builder.func_200280_c(resourceLocation)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(resourceLocation, this.field_218654_f, this.field_218653_e == null ? "" : this.field_218653_e, this.field_218650_b, this.field_218649_a, this.field_218651_c, this.field_218652_d, new ResourceLocation(resourceLocation.func_110624_b(), "recipes/" + this.field_218649_a.func_77640_w().func_200300_c() + "/" + resourceLocation.func_110623_a())));
    }

    private void func_218646_a(ResourceLocation resourceLocation) {
        if (this.field_218652_d.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation field_218620_a;
        private final String field_218621_b;
        private final Ingredient field_218622_c;
        private final Item field_218623_d;
        private final int field_218624_e;
        private final Advancement.Builder field_218625_f;
        private final ResourceLocation field_218626_g;
        private final IRecipeSerializer<?> field_218627_h;

        public Result(ResourceLocation resourceLocation, IRecipeSerializer<?> iRecipeSerializer, String string, Ingredient ingredient, Item item, int n, Advancement.Builder builder, ResourceLocation resourceLocation2) {
            this.field_218620_a = resourceLocation;
            this.field_218627_h = iRecipeSerializer;
            this.field_218621_b = string;
            this.field_218622_c = ingredient;
            this.field_218623_d = item;
            this.field_218624_e = n;
            this.field_218625_f = builder;
            this.field_218626_g = resourceLocation2;
        }

        @Override
        public void func_218610_a(JsonObject jsonObject) {
            if (!this.field_218621_b.isEmpty()) {
                jsonObject.addProperty("group", this.field_218621_b);
            }
            jsonObject.add("ingredient", this.field_218622_c.func_200304_c());
            jsonObject.addProperty("result", Registry.field_212630_s.func_177774_c(this.field_218623_d).toString());
            jsonObject.addProperty("count", (Number)this.field_218624_e);
        }

        @Override
        public ResourceLocation func_200442_b() {
            return this.field_218620_a;
        }

        @Override
        public IRecipeSerializer<?> func_218609_c() {
            return this.field_218627_h;
        }

        @Override
        @Nullable
        public JsonObject func_200440_c() {
            return this.field_218625_f.func_200273_b();
        }

        @Override
        @Nullable
        public ResourceLocation func_200443_d() {
            return this.field_218626_g;
        }
    }
}

