/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.FeatureJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.ListJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.StructureProcessorList;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class JigsawPiece {
    public static final Codec<JigsawPiece> field_236847_e_ = Registry.field_218365_F.dispatch("element_type", JigsawPiece::func_214853_a, IJigsawDeserializer::codec);
    @Nullable
    private volatile JigsawPattern.PlacementBehaviour field_214855_a;

    protected static <E extends JigsawPiece> RecordCodecBuilder<E, JigsawPattern.PlacementBehaviour> func_236848_d_() {
        return JigsawPattern.PlacementBehaviour.field_236858_c_.fieldOf("projection").forGetter(JigsawPiece::func_214854_c);
    }

    protected JigsawPiece(JigsawPattern.PlacementBehaviour placementBehaviour) {
        this.field_214855_a = placementBehaviour;
    }

    public abstract List<Template.BlockInfo> func_214849_a(TemplateManager var1, BlockPos var2, Rotation var3, Random var4);

    public abstract MutableBoundingBox func_214852_a(TemplateManager var1, BlockPos var2, Rotation var3);

    public abstract boolean func_230378_a_(TemplateManager var1, ISeedReader var2, StructureManager var3, ChunkGenerator var4, BlockPos var5, BlockPos var6, Rotation var7, MutableBoundingBox var8, Random var9, boolean var10);

    public abstract IJigsawDeserializer<?> func_214853_a();

    public void func_214846_a(IWorld iWorld, Template.BlockInfo blockInfo, BlockPos blockPos, Rotation rotation, Random random, MutableBoundingBox mutableBoundingBox) {
    }

    public JigsawPiece func_214845_a(JigsawPattern.PlacementBehaviour placementBehaviour) {
        this.field_214855_a = placementBehaviour;
        return this;
    }

    public JigsawPattern.PlacementBehaviour func_214854_c() {
        JigsawPattern.PlacementBehaviour placementBehaviour = this.field_214855_a;
        if (placementBehaviour == null) {
            throw new IllegalStateException();
        }
        return placementBehaviour;
    }

    public int func_214850_d() {
        return 1;
    }

    public static Function<JigsawPattern.PlacementBehaviour, EmptyJigsawPiece> func_242864_g() {
        return placementBehaviour -> EmptyJigsawPiece.field_214856_a;
    }

    public static Function<JigsawPattern.PlacementBehaviour, LegacySingleJigsawPiece> func_242849_a(String string) {
        return placementBehaviour -> new LegacySingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(string)), () -> ProcessorLists.field_244101_a, (JigsawPattern.PlacementBehaviour)placementBehaviour);
    }

    public static Function<JigsawPattern.PlacementBehaviour, LegacySingleJigsawPiece> func_242851_a(String string, StructureProcessorList structureProcessorList) {
        return placementBehaviour -> new LegacySingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(string)), () -> structureProcessorList, (JigsawPattern.PlacementBehaviour)placementBehaviour);
    }

    public static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> func_242859_b(String string) {
        return placementBehaviour -> new SingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(string)), () -> ProcessorLists.field_244101_a, (JigsawPattern.PlacementBehaviour)placementBehaviour);
    }

    public static Function<JigsawPattern.PlacementBehaviour, SingleJigsawPiece> func_242861_b(String string, StructureProcessorList structureProcessorList) {
        return placementBehaviour -> new SingleJigsawPiece((Either<ResourceLocation, Template>)Either.left((Object)new ResourceLocation(string)), () -> structureProcessorList, (JigsawPattern.PlacementBehaviour)placementBehaviour);
    }

    public static Function<JigsawPattern.PlacementBehaviour, FeatureJigsawPiece> func_242845_a(ConfiguredFeature<?, ?> configuredFeature) {
        return placementBehaviour -> new FeatureJigsawPiece(() -> configuredFeature, (JigsawPattern.PlacementBehaviour)placementBehaviour);
    }

    public static Function<JigsawPattern.PlacementBehaviour, ListJigsawPiece> func_242853_a(List<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>> list) {
        return placementBehaviour -> new ListJigsawPiece(list.stream().map(function -> (JigsawPiece)function.apply(placementBehaviour)).collect(Collectors.toList()), (JigsawPattern.PlacementBehaviour)placementBehaviour);
    }
}

