/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.TRSRTransformer;

public final class ItemLayerModel
implements IModelGeometry<ItemLayerModel> {
    public static final ItemLayerModel INSTANCE = new ItemLayerModel((ImmutableList<RenderMaterial>)ImmutableList.of());
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.UP, Direction.DOWN};
    private static final Direction[] VERTICALS = new Direction[]{Direction.WEST, Direction.EAST};
    private ImmutableList<RenderMaterial> textures;
    private final ImmutableSet<Integer> fullbrightLayers;

    public ItemLayerModel() {
        this(null, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public ItemLayerModel(ImmutableList<RenderMaterial> textures) {
        this(textures, (ImmutableSet<Integer>)ImmutableSet.of());
    }

    public ItemLayerModel(@Nullable ImmutableList<RenderMaterial> textures, ImmutableSet<Integer> fullbrightLayers) {
        this.textures = textures;
        this.fullbrightLayers = fullbrightLayers;
    }

    private static ImmutableList<RenderMaterial> getTextures(IModelConfiguration model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.isTexturePresent("layer" + i)) {
            builder.add((Object)model.resolveTexture("layer" + i));
            ++i;
        }
        return builder.build();
    }

    @Override
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transformMap = PerspectiveMapWrapper.getTransforms(new ModelTransformComposition(owner.getCombinedTransform(), modelTransform));
        TransformationMatrix transform = modelTransform.func_225615_b_();
        TextureAtlasSprite particle = spriteGetter.apply(owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : (RenderMaterial)this.textures.get(0));
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder(owner, particle, overrides, transformMap);
        for (int i = 0; i < this.textures.size(); ++i) {
            TextureAtlasSprite tas = spriteGetter.apply((RenderMaterial)this.textures.get(i));
            boolean fullbright = this.fullbrightLayers.contains((Object)i);
            RenderType rt = ItemLayerModel.getLayerRenderType(fullbright);
            builder.addQuads(rt, (Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite(i, tas, transform, fullbright));
        }
        return builder.build();
    }

    public static RenderType getLayerRenderType(boolean isFullbright) {
        return isFullbright ? ForgeRenderTypes.ITEM_UNSORTED_UNLIT_TRANSLUCENT.get() : ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get();
    }

    public static ImmutableList<BakedQuad> getQuadsForSprites(List<RenderMaterial> textures, TransformationMatrix transform, Function<RenderMaterial, TextureAtlasSprite> spriteGetter) {
        return ItemLayerModel.getQuadsForSprites(textures, transform, spriteGetter, Collections.emptySet());
    }

    public static ImmutableList<BakedQuad> getQuadsForSprites(List<RenderMaterial> textures, TransformationMatrix transform, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, Set<Integer> fullbrights) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size(); ++i) {
            TextureAtlasSprite tas = spriteGetter.apply(textures.get(i));
            builder.addAll(ItemLayerModel.getQuadsForSprite(i, tas, transform, fullbrights.contains(i)));
        }
        return builder.build();
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite sprite, TransformationMatrix transform) {
        return ItemLayerModel.getQuadsForSprite(tint, sprite, transform, false);
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite sprite, TransformationMatrix transform, boolean fullbright) {
        int off;
        int off2;
        boolean face;
        boolean building;
        int u;
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        FaceData faceData = new FaceData(uMax, vMax);
        boolean translucent = false;
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (u = 0; u < uMax; ++u) {
                    boolean t;
                    int alpha = sprite.getPixelRGBA(f, u, vMax - v - 1) >> 24 & 0xFF;
                    boolean bl = t = (float)alpha / 255.0f <= 0.1f;
                    if (!t && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu && !t) {
                        faceData.set(Direction.WEST, u, v);
                    }
                    if (!ptu && t) {
                        faceData.set(Direction.EAST, u - 1, v);
                    }
                    if (ptv[u] && !t) {
                        faceData.set(Direction.UP, u, v);
                    }
                    if (!ptv[u] && t) {
                        faceData.set(Direction.DOWN, u, v - 1);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                faceData.set(Direction.EAST, uMax - 1, v);
            }
            for (int u2 = 0; u2 < uMax; ++u2) {
                if (ptv[u2]) continue;
                faceData.set(Direction.DOWN, u2, vMax - 1);
            }
        }
        for (Direction facing : HORIZONTALS) {
            for (int v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    face = faceData.get(facing, u3, v);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            uStart = u3;
                        }
                        uEnd = u3 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == Direction.DOWN ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, uStart, v + off2, u3 - uStart, fullbright));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    uStart = u3;
                }
                if (!building) continue;
                off = facing == Direction.DOWN ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, uStart, v + off, uEnd - uStart, fullbright));
            }
        }
        for (Direction facing : VERTICALS) {
            for (u = 0; u < uMax; ++u) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v = 0; v < vMax; ++v) {
                    face = faceData.get(facing, u, v);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            vStart = v;
                        }
                        vEnd = v + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == Direction.EAST ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, u + off2, vStart, v - vStart, fullbright));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    vStart = v;
                }
                if (!building) continue;
                off = facing == Direction.EAST ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(transform, facing, tint, sprite, u + off, vStart, vEnd - vStart, fullbright));
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(transform, Direction.NORTH, sprite, tint, fullbright, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
        builder.add((Object)ItemLayerModel.buildQuad(transform, Direction.SOUTH, sprite, tint, fullbright, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
        return builder.build();
    }

    @Override
    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.textures = ItemLayerModel.getTextures(owner);
        return this.textures;
    }

    private static BakedQuad buildSideQuad(TransformationMatrix transform, Direction side, int tint, TextureAtlasSprite sprite, int u, int v, int size, boolean fullbright) {
        float eps = 0.01f;
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.func_176730_m().func_177958_n() * 0.01f / (float)width;
        float dy = (float)side.func_176730_m().func_177956_o() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return ItemLayerModel.buildQuad(transform, ItemLayerModel.remap(side), sprite, tint, fullbright, x0, y0, z0, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z0, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    private static Direction remap(Direction side) {
        return side.func_176740_k() == Direction.Axis.Y ? side.func_176734_d() : side;
    }

    private static BakedQuad buildQuad(TransformationMatrix transform, Direction side, TextureAtlasSprite sprite, int tint, boolean fullbright, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setApplyDiffuseLighting(false);
        boolean hasTransform = !transform.isIdentity();
        IVertexConsumer consumer = hasTransform ? new TRSRTransformer(builder, transform) : builder;
        int vLight = fullbright ? 15 : 0;
        int uLight = vLight;
        ItemLayerModel.putVertex(consumer, side, x0, y0, z0, u0, v0, uLight, vLight);
        ItemLayerModel.putVertex(consumer, side, x1, y1, z1, u1, v1, uLight, vLight);
        ItemLayerModel.putVertex(consumer, side, x2, y2, z2, u2, v2, uLight, vLight);
        ItemLayerModel.putVertex(consumer, side, x3, y3, z3, u3, v3, uLight, vLight);
        return builder.build();
    }

    private static void putVertex(IVertexConsumer consumer, Direction side, float x, float y, float z, float u, float v, int uLight, int vLight) {
        VertexFormat format = consumer.getVertexFormat();
        block10: for (int e = 0; e < format.func_227894_c_().size(); ++e) {
            VertexFormatElement element = (VertexFormatElement)format.func_227894_c_().get(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    consumer.put(e, x, y, z, 1.0f);
                    continue block10;
                }
                case COLOR: {
                    consumer.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block10;
                }
                case NORMAL: {
                    float offX = side.func_82601_c();
                    float offY = side.func_96559_d();
                    float offZ = side.func_82599_e();
                    consumer.put(e, offX, offY, offZ, 0.0f);
                    continue block10;
                }
                case UV: {
                    switch (element.func_177369_e()) {
                        case 0: {
                            consumer.put(e, u, v, 0.0f, 1.0f);
                            continue block10;
                        }
                        case 2: {
                            consumer.put(e, (float)(uLight << 4) / 32768.0f, (float)(vLight << 4) / 32768.0f, 0.0f, 1.0f);
                            continue block10;
                        }
                    }
                }
                default: {
                    consumer.put(e, new float[0]);
                }
            }
        }
    }

    public static class Loader
    implements IModelLoader<ItemLayerModel> {
        public static final Loader INSTANCE = new Loader();

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public ItemLayerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableSet.Builder fullbrightLayers = ImmutableSet.builder();
            if (modelContents.has("fullbright_layers")) {
                JsonArray arr = JSONUtils.func_151214_t((JsonObject)modelContents, (String)"fullbright_layers");
                for (int i = 0; i < arr.size(); ++i) {
                    fullbrightLayers.add((Object)arr.get(i).getAsInt());
                }
            }
            return new ItemLayerModel(null, (ImmutableSet<Integer>)fullbrightLayers.build());
        }
    }

    private static class FaceData {
        private final EnumMap<Direction, BitSet> data = new EnumMap(Direction.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(Direction.WEST, new BitSet(uMax * vMax));
            this.data.put(Direction.EAST, new BitSet(uMax * vMax));
            this.data.put(Direction.UP, new BitSet(uMax * vMax));
            this.data.put(Direction.DOWN, new BitSet(uMax * vMax));
        }

        public void set(Direction facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(Direction facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }
}

