/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.play.server.SCustomPayloadPlayPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLConnectionData;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPacketSplitter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CHANNEL = new ResourceLocation("forge", "split");
    private static final ResourceLocation V11_DUMMY_CHANNEL = new ResourceLocation("forge", "split_11");
    private static final String VERSION = "1.0";
    private static final String VERSION_11 = "1.1";
    private static final int PROTOCOL_MAX = 0x200000;
    private static final int PAYLOAD_TO_CLIENT_MAX = 0x100000;
    private static final int PART_SIZE = 1048570;
    private static final byte STATE_FIRST = 1;
    private static final byte STATE_LAST = 2;
    private static final List<PacketBuffer> receivedBuffers = new ArrayList<PacketBuffer>();

    public static void register() {
        Predicate<String> versionCheck = NetworkRegistry.acceptMissingOr(VERSION);
        EventNetworkChannel channel = NetworkRegistry.newEventChannel(CHANNEL, () -> VERSION, versionCheck, versionCheck);
        channel.addListener(VanillaPacketSplitter::onClientPacket);
        Predicate<String> version11Check = NetworkRegistry.acceptMissingOr(VERSION_11);
        NetworkRegistry.newEventChannel(V11_DUMMY_CHANNEL, () -> VERSION_11, version11Check, version11Check);
    }

    public static void appendPackets(ProtocolType protocol, PacketDirection direction, IPacket<?> packet, List<? super IPacket<?>> out) {
        if (VanillaPacketSplitter.heuristicIsDefinitelySmallEnough(packet)) {
            out.add(packet);
        } else {
            PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
            try {
                packet.func_148840_b(buf);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (buf.readableBytes() <= 0x200000) {
                buf.release();
                out.add(packet);
            } else {
                int parts = (int)Math.ceil((double)buf.readableBytes() / 1048570.0);
                if (parts == 1) {
                    buf.release();
                    out.add(packet);
                } else {
                    for (int part = 0; part < parts; ++part) {
                        ByteBuf partPrefix;
                        if (part == 0) {
                            partPrefix = Unpooled.buffer((int)5);
                            partPrefix.writeByte(1);
                            new PacketBuffer(partPrefix).func_150787_b(protocol.func_179246_a(direction, packet).intValue());
                        } else {
                            partPrefix = Unpooled.buffer((int)1);
                            partPrefix.writeByte(part == parts - 1 ? 2 : 0);
                        }
                        int partSize = Math.min(1048570, buf.readableBytes());
                        ByteBuf partBuf = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{partPrefix, buf.retainedSlice(buf.readerIndex(), partSize)});
                        buf.skipBytes(partSize);
                        out.add((IPacket<?>)new SCustomPayloadPlayPacket(CHANNEL, new PacketBuffer(partBuf)));
                    }
                    buf.release();
                }
            }
        }
    }

    private static boolean heuristicIsDefinitelySmallEnough(IPacket<?> packet) {
        return false;
    }

    private static void onClientPacket(NetworkEvent.ServerCustomPayloadEvent event) {
        NetworkEvent.Context ctx = event.getSource().get();
        PacketDirection direction = ctx.getDirection() == NetworkDirection.PLAY_TO_CLIENT ? PacketDirection.CLIENTBOUND : PacketDirection.SERVERBOUND;
        ProtocolType protocol = ProtocolType.PLAY;
        ctx.setPacketHandled(true);
        PacketBuffer buf = event.getPayload();
        byte state = buf.readByte();
        if (state == 1 && !receivedBuffers.isEmpty()) {
            LOGGER.warn("forge:split received out of order - inbound buffer not empty when receiving first");
            receivedBuffers.clear();
        }
        buf.retain();
        receivedBuffers.add(buf);
        if (state == 2) {
            PacketBuffer full = new PacketBuffer(Unpooled.wrappedBuffer((ByteBuf[])((ByteBuf[])receivedBuffers.toArray(new PacketBuffer[0]))));
            int packetId = full.func_150792_a();
            IPacket packet = protocol.func_179244_a(direction, packetId);
            if (packet == null) {
                LOGGER.error("Received invalid packet ID {} in forge:split", (Object)packetId);
            } else {
                try {
                    packet.func_148837_a(full);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    receivedBuffers.clear();
                    full.release();
                }
                ctx.enqueueWork(() -> packet.func_148833_a((INetHandler)Minecraft.func_71410_x().func_147114_u()));
            }
        }
    }

    public static RemoteCompatibility getRemoteCompatibility(NetworkManager manager) {
        FMLConnectionData connectionData = NetworkHooks.getConnectionData(manager);
        if (connectionData == null) {
            return RemoteCompatibility.ABSENT;
        }
        if (connectionData.getChannels().containsKey((Object)V11_DUMMY_CHANNEL)) {
            return RemoteCompatibility.V11;
        }
        if (connectionData.getChannels().containsKey((Object)CHANNEL)) {
            return RemoteCompatibility.V10_LEGACY;
        }
        return RemoteCompatibility.ABSENT;
    }

    public static boolean isRemoteCompatible(NetworkManager manager) {
        return VanillaPacketSplitter.getRemoteCompatibility(manager) != RemoteCompatibility.ABSENT;
    }

    public static enum RemoteCompatibility {
        ABSENT,
        V10_LEGACY,
        V11;

    }
}

