/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeWorldTypeScreens;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.client.event.ClientPlayerChangeGameModeEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.textures.ForgeTextureMetadata;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fmlclient.ExtendedServerListData;
import net.minecraftforge.fmlclient.registry.ClientRegistry;
import net.minecraftforge.fmllegacy.ForgeI18n;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.resource.VanillaResourceType;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker CLIENTHOOKS = MarkerManager.getMarker((String)"CLIENTHOOKS");
    private static final Stack<Screen> guiLayers = new Stack();
    static final ThreadLocal<RenderType> renderLayer = new ThreadLocal();
    public static String forgeStatusLine;
    static int worldRenderPass;
    private static final Matrix4f flipX;
    private static final Matrix3f flipXNormal;
    private static int slotMainHand;
    private static final Map<ModelLayerLocation, Supplier<LayerDefinition>> layerDefinitions;
    private static final ResourceLocation ICON_SHEET;

    public static void clearGuiLayers(Minecraft minecraft) {
        while (guiLayers.size() > 0) {
            ForgeHooksClient.popGuiLayerInternal(minecraft);
        }
    }

    private static void popGuiLayerInternal(Minecraft minecraft) {
        if (minecraft.f_91080_ != null) {
            minecraft.f_91080_.m_7861_();
        }
        minecraft.f_91080_ = guiLayers.pop();
    }

    public static void pushGuiLayer(Minecraft minecraft, Screen screen) {
        if (minecraft.f_91080_ != null) {
            guiLayers.push(minecraft.f_91080_);
        }
        minecraft.f_91080_ = Objects.requireNonNull(screen);
        screen.m_6575_(minecraft, minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_());
        NarratorChatListener.f_93311_.m_168785_(screen.m_142562_());
    }

    public static void popGuiLayer(Minecraft minecraft) {
        if (guiLayers.size() == 0) {
            minecraft.m_91152_(null);
            return;
        }
        ForgeHooksClient.popGuiLayerInternal(minecraft);
        if (minecraft.f_91080_ != null) {
            NarratorChatListener.f_93311_.m_168785_(minecraft.f_91080_.m_142562_());
        }
    }

    public static float getGuiFarPlane() {
        return 1000.0f + 2000.0f * (float)(1 + guiLayers.size());
    }

    public static String getArmorTexture(Entity entity, ItemStack armor, String _default, EquipmentSlot slot, String type) {
        String result = armor.m_41720_().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static boolean onDrawBlockHighlight(LevelRenderer context, Camera info, HitResult target, float partialTicks, PoseStack matrix, MultiBufferSource buffers) {
        switch (target.m_6662_()) {
            case BLOCK: {
                if (!(target instanceof BlockHitResult)) {
                    return false;
                }
                return MinecraftForge.EVENT_BUS.post((Event)new DrawSelectionEvent.HighlightBlock(context, info, target, partialTicks, matrix, buffers));
            }
            case ENTITY: {
                if (!(target instanceof EntityHitResult)) {
                    return false;
                }
                return MinecraftForge.EVENT_BUS.post((Event)new DrawSelectionEvent.HighlightEntity(context, info, target, partialTicks, matrix, buffers));
            }
        }
        return MinecraftForge.EVENT_BUS.post((Event)new DrawSelectionEvent(context, info, target, partialTicks, matrix, buffers));
    }

    public static void dispatchRenderLast(LevelRenderer context, PoseStack mat, float partialTicks, Matrix4f projectionMatrix, long finishTimeNano) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderWorldLastEvent(context, mat, partialTicks, projectionMatrix, finishTimeNano));
    }

    public static boolean renderSpecificFirstPersonHand(InteractionHand hand, PoseStack mat, MultiBufferSource buffers, int light, float partialTicks, float interpPitch, float swingProgress, float equipProgress, ItemStack stack) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderHandEvent(hand, mat, buffers, light, partialTicks, interpPitch, swingProgress, equipProgress, stack));
    }

    public static void onTextureStitchedPre(TextureAtlas map, Set<ResourceLocation> resourceLocations) {
        StartupMessageManager.mcLoaderConsumer().ifPresent(c -> c.accept("Atlas Stitching : " + map.m_118330_().toString()));
        ModLoader.get().postEvent((Event)new TextureStitchEvent.Pre(map, resourceLocations));
        Sheets.f_110743_.values().stream().filter(rm -> rm.m_119193_().equals((Object)map.m_118330_())).forEach(rm -> resourceLocations.add(rm.m_119203_()));
    }

    public static void onTextureStitchedPost(TextureAtlas map) {
        ModLoader.get().postEvent((Event)new TextureStitchEvent.Post(map));
    }

    public static void onBlockColorsInit(BlockColors blockColors) {
        ModLoader.get().postEvent((Event)new ColorHandlerEvent.Block(blockColors));
    }

    public static void onItemColorsInit(ItemColors itemColors, BlockColors blockColors) {
        ModLoader.get().postEvent((Event)new ColorHandlerEvent.Item(itemColors, blockColors));
    }

    public static void setRenderLayer(RenderType layer) {
        renderLayer.set(layer);
    }

    public static <A extends HumanoidModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot slot, A _default) {
        A model = RenderProperties.get(itemStack).getArmorModel(entityLiving, itemStack, slot, _default);
        return model == null ? _default : model;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ":" + base + name;
        }
        return base + name;
    }

    public static float getOffsetFOV(Player entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post((Event)fovUpdateEvent);
        return fovUpdateEvent.getNewfov();
    }

    public static double getFOVModifier(GameRenderer renderer, Camera info, double renderPartialTicks, double fov) {
        EntityViewRenderEvent.FOVModifier event = new EntityViewRenderEvent.FOVModifier(renderer, info, renderPartialTicks, fov);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getFOV();
    }

    public static void renderMainMenu(TitleScreen gui, PoseStack mStack, Font font, int width, int height, int alpha) {
        Object line;
        VersionChecker.Status status = ForgeVersion.getStatus();
        if (status == VersionChecker.Status.BETA || status == VersionChecker.Status.BETA_OUTDATED) {
            line = new TranslatableComponent("forge.update.beta.1", new Object[]{ChatFormatting.RED, ChatFormatting.RESET}).m_130940_(ChatFormatting.RED);
            int n = width / 2;
            Objects.requireNonNull(font);
            GuiComponent.m_93215_((PoseStack)mStack, (Font)font, (Component)line, (int)n, (int)(4 + 0 * (9 + 1)), (int)(0xFFFFFF | alpha));
            line = new TranslatableComponent("forge.update.beta.2");
            int n2 = width / 2;
            Objects.requireNonNull(font);
            GuiComponent.m_93215_((PoseStack)mStack, (Font)font, (Component)line, (int)n2, (int)(4 + 1 * (9 + 1)), (int)(0xFFFFFF | alpha));
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = I18n.m_118938_((String)"forge.update.newversion", (Object[])new Object[]{ForgeVersion.getTarget()});
                break;
            }
        }
        forgeStatusLine = line;
    }

    public static SoundInstance playSound(SoundEngine manager, SoundInstance sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getResultSound();
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(Screen screen, PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        mStack.m_85836_();
        guiLayers.forEach(layer -> {
            ForgeHooksClient.drawScreenInternal(layer, mStack, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
            mStack.m_85837_(0.0, 0.0, 2000.0);
        });
        ForgeHooksClient.drawScreenInternal(screen, mStack, mouseX, mouseY, partialTicks);
        mStack.m_85849_();
    }

    private static void drawScreenInternal(Screen screen, PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.DrawScreenEvent.Pre(screen, mStack, mouseX, mouseY, partialTicks))) {
            screen.m_6305_(mStack, mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.DrawScreenEvent.Post(screen, mStack, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(FogRenderer.FogMode type, Camera info, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(type, info, partial, density);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return event.getDensity();
        }
        return -1.0f;
    }

    public static void onFogRender(FogRenderer.FogMode type, Camera info, float partial, float distance) {
        MinecraftForge.EVENT_BUS.post((Event)new EntityViewRenderEvent.RenderFogEvent(type, info, partial, distance));
    }

    public static EntityViewRenderEvent.CameraSetup onCameraSetup(GameRenderer renderer, Camera info, float partial) {
        EntityViewRenderEvent.CameraSetup event = new EntityViewRenderEvent.CameraSetup(renderer, info, partial, info.m_90590_(), info.m_90589_(), 0.0f);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void onModelBake(ModelManager modelManager, Map<ResourceLocation, BakedModel> modelRegistry, ModelLoader modelLoader) {
        ModLoader.get().postEvent((Event)new ModelBakeEvent(modelManager, modelRegistry, modelLoader));
        modelLoader.onPostBakeEvent(modelRegistry);
    }

    public static BakedModel handleCameraTransforms(PoseStack matrixStack, BakedModel model, ItemTransforms.TransformType cameraTransformType, boolean leftHandHackery) {
        PoseStack stack = new PoseStack();
        model = model.handlePerspective(cameraTransformType, stack);
        if (!stack.m_85851_()) {
            Matrix4f tMat = stack.m_85850_().m_85861_();
            Matrix3f nMat = stack.m_85850_().m_85864_();
            if (leftHandHackery) {
                tMat.multiplyBackward(flipX);
                tMat.m_27644_(flipX);
                nMat.multiplyBackward(flipXNormal);
                nMat.m_8178_(flipXNormal);
            }
            matrixStack.m_85850_().m_85861_().m_27644_(tMat);
            matrixStack.m_85850_().m_85864_().m_8178_(nMat);
        }
        return model;
    }

    public static void preDraw(VertexFormatElement.Usage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = (VertexFormatElement)format.m_86023_().get(element);
        int count = attr.getElementCount();
        int constant = attr.m_86041_().m_86076_();
        ((Buffer)buffer).position(format.getOffset(element));
        switch (attrType) {
            case POSITION: {
                GL20.glVertexPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32884);
                break;
            }
            case NORMAL: {
                if (count != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + attr);
                }
                GL20.glNormalPointer((int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32885);
                break;
            }
            case COLOR: {
                GL20.glColorPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32886);
                break;
            }
            case UV: {
                GL13.glClientActiveTexture((int)(33984 + attr.m_86049_()));
                GL20.glTexCoordPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL20.glEnableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray((int)attr.m_86049_());
                GL20.glVertexAttribPointer((int)attr.m_86049_(), (int)count, (int)constant, (boolean)false, (int)stride, (ByteBuffer)buffer);
                break;
            }
            default: {
                LOGGER.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.m_86097_());
            }
        }
    }

    public static void postDraw(VertexFormatElement.Usage attrType, VertexFormat format, int element, int stride, ByteBuffer buffer) {
        VertexFormatElement attr = (VertexFormatElement)format.m_86023_().get(element);
        switch (attrType) {
            case POSITION: {
                GL20.glDisableClientState((int)32884);
                break;
            }
            case NORMAL: {
                GL20.glDisableClientState((int)32885);
                break;
            }
            case COLOR: {
                GL20.glDisableClientState((int)32886);
                break;
            }
            case UV: {
                GL13.glClientActiveTexture((int)(33984 + attr.m_86049_()));
                GL20.glDisableClientState((int)32888);
                GL13.glClientActiveTexture((int)33984);
                break;
            }
            case PADDING: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray((int)attr.m_86049_());
                break;
            }
            default: {
                LOGGER.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.m_86097_());
            }
        }
    }

    public static int getColorIndex(VertexFormat fmt) {
        ImmutableList elements = fmt.m_86023_();
        for (int i = 0; i < elements.size(); ++i) {
            if (((VertexFormatElement)elements.get(i)).m_86048_() != VertexFormatElement.Usage.COLOR) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("There is no COLOR element in the provided VertexFormat.");
    }

    public static TextureAtlasSprite[] getFluidSprites(BlockAndTintGetter world, BlockPos pos, FluidState fluidStateIn) {
        ResourceLocation overlayTexture = fluidStateIn.m_76152_().getAttributes().getOverlayTexture();
        return new TextureAtlasSprite[]{(TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidStateIn.m_76152_().getAttributes().getStillTexture(world, pos)), (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(fluidStateIn.m_76152_().getAttributes().getFlowingTexture(world, pos)), overlayTexture == null ? null : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(overlayTexture)};
    }

    public static void gatherFluidTextures(Set<Material> textures) {
        ForgeRegistries.FLUIDS.getValues().stream().flatMap(ForgeHooksClient::getFluidMaterials).forEach(textures::add);
    }

    public static Stream<Material> getFluidMaterials(Fluid fluid) {
        return fluid.getAttributes().getTextures().filter(Objects::nonNull).map(ForgeHooksClient::getBlockMaterial);
    }

    public static Material getBlockMaterial(ResourceLocation loc) {
        return new Material(TextureAtlas.f_118259_, loc);
    }

    public static void fillNormal(int[] faceData, Direction facing) {
        Vector3f v1 = ForgeHooksClient.getVertexPos(faceData, 3);
        Vector3f t1 = ForgeHooksClient.getVertexPos(faceData, 1);
        Vector3f v2 = ForgeHooksClient.getVertexPos(faceData, 2);
        Vector3f t2 = ForgeHooksClient.getVertexPos(faceData, 0);
        v1.m_122267_(t1);
        v2.m_122267_(t2);
        v2.m_122279_(v1);
        v2.m_122278_();
        int x = (byte)Math.round(v2.m_122239_() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.m_122260_() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.m_122269_() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 8 + 7] = normal;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 8;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static void loadEntityShader(Entity entity, GameRenderer entityRenderer) {
        ResourceLocation shader;
        if (entity != null && (shader = ClientRegistry.getEntityShader(entity.getClass())) != null) {
            entityRenderer.m_109128_(shader);
        }
    }

    public static boolean shouldCauseReequipAnimation(@Nonnull ItemStack from, @Nonnull ItemStack to, int slot) {
        boolean fromInvalid = from.m_41619_();
        boolean toInvalid = to.m_41619_();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.m_41720_().shouldCauseReequipAnimation(from, to, changed);
    }

    public static RenderGameOverlayEvent.BossInfo bossBarRenderPre(PoseStack mStack, Window res, LerpingBossEvent bossInfo, int x, int y, int increment) {
        RenderGameOverlayEvent.BossInfo evt = new RenderGameOverlayEvent.BossInfo(mStack, new RenderGameOverlayEvent(mStack, Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO, bossInfo, x, y, increment);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static void bossBarRenderPost(PoseStack mStack, Window res) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.Post(mStack, new RenderGameOverlayEvent(mStack, Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO));
    }

    public static ScreenshotEvent onScreenshot(NativeImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void onClientChangeGameMode(PlayerInfo info, GameType currentGameMode, GameType newGameMode) {
        if (currentGameMode != newGameMode) {
            ClientPlayerChangeGameModeEvent evt = new ClientPlayerChangeGameModeEvent(info, currentGameMode, newGameMode);
            MinecraftForge.EVENT_BUS.post((Event)evt);
        }
    }

    public static BakedModel handlePerspective(BakedModel model, ItemTransforms.TransformType type, PoseStack stack) {
        Transformation tr = TransformationHelper.toTransformation(model.m_7442_().m_111808_(type));
        if (!tr.isIdentity()) {
            tr.push(stack);
        }
        return model;
    }

    public static void onInputUpdate(Player player, Input movementInput) {
        MinecraftForge.EVENT_BUS.post((Event)new InputUpdateEvent(player, movementInput));
    }

    public static void refreshResources(Minecraft mc, VanillaResourceType ... types) {
        mc.m_91391_();
    }

    public static boolean onGuiMouseClickedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseClickedEvent.Pre event = new GuiScreenEvent.MouseClickedEvent.Pre(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseClickedPost(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseClickedEvent.Post event = new GuiScreenEvent.MouseClickedEvent.Post(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseReleasedPre(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseReleasedEvent.Pre event = new GuiScreenEvent.MouseReleasedEvent.Pre(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseReleasedPost(Screen guiScreen, double mouseX, double mouseY, int button) {
        GuiScreenEvent.MouseReleasedEvent.Post event = new GuiScreenEvent.MouseReleasedEvent.Post(guiScreen, mouseX, mouseY, button);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseDragPre(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        GuiScreenEvent.MouseDragEvent.Pre event = new GuiScreenEvent.MouseDragEvent.Pre(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseDragPost(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        GuiScreenEvent.MouseDragEvent.Post event = new GuiScreenEvent.MouseDragEvent.Post(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseScrollPre(MouseHandler mouseHelper, Screen guiScreen, double scrollDelta) {
        Window mainWindow = guiScreen.getMinecraft().m_91268_();
        double mouseX = mouseHelper.m_91589_() * (double)mainWindow.m_85445_() / (double)mainWindow.m_85443_();
        double mouseY = mouseHelper.m_91594_() * (double)mainWindow.m_85446_() / (double)mainWindow.m_85444_();
        GuiScreenEvent.MouseScrollEvent.Pre event = new GuiScreenEvent.MouseScrollEvent.Pre(guiScreen, mouseX, mouseY, scrollDelta);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiMouseScrollPost(MouseHandler mouseHelper, Screen guiScreen, double scrollDelta) {
        Window mainWindow = guiScreen.getMinecraft().m_91268_();
        double mouseX = mouseHelper.m_91589_() * (double)mainWindow.m_85445_() / (double)mainWindow.m_85443_();
        double mouseY = mouseHelper.m_91594_() * (double)mainWindow.m_85446_() / (double)mainWindow.m_85444_();
        GuiScreenEvent.MouseScrollEvent.Post event = new GuiScreenEvent.MouseScrollEvent.Post(guiScreen, mouseX, mouseY, scrollDelta);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyPressedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyPressedEvent.Pre event = new GuiScreenEvent.KeyboardKeyPressedEvent.Pre(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyPressedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyPressedEvent.Post event = new GuiScreenEvent.KeyboardKeyPressedEvent.Post(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyReleasedPre(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyReleasedEvent.Pre event = new GuiScreenEvent.KeyboardKeyReleasedEvent.Pre(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiKeyReleasedPost(Screen guiScreen, int keyCode, int scanCode, int modifiers) {
        GuiScreenEvent.KeyboardKeyReleasedEvent.Post event = new GuiScreenEvent.KeyboardKeyReleasedEvent.Post(guiScreen, keyCode, scanCode, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiCharTypedPre(Screen guiScreen, char codePoint, int modifiers) {
        GuiScreenEvent.KeyboardCharTypedEvent.Pre event = new GuiScreenEvent.KeyboardCharTypedEvent.Pre(guiScreen, codePoint, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onGuiCharTypedPost(Screen guiScreen, char codePoint, int modifiers) {
        GuiScreenEvent.KeyboardCharTypedEvent.Post event = new GuiScreenEvent.KeyboardCharTypedEvent.Post(guiScreen, codePoint, modifiers);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void onRecipesUpdated(RecipeManager mgr) {
        RecipesUpdatedEvent event = new RecipesUpdatedEvent(mgr);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static void fireMouseInput(int button, int action, int mods) {
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.MouseInputEvent(button, action, mods));
    }

    public static void fireKeyInput(int key, int scanCode, int action, int modifiers) {
        MinecraftForge.EVENT_BUS.post((Event)new InputEvent.KeyInputEvent(key, scanCode, action, modifiers));
    }

    public static boolean onMouseScroll(MouseHandler mouseHelper, double scrollDelta) {
        InputEvent.MouseScrollEvent event = new InputEvent.MouseScrollEvent(scrollDelta, mouseHelper.m_91560_(), mouseHelper.m_168090_(), mouseHelper.m_91584_(), mouseHelper.m_91589_(), mouseHelper.m_91594_());
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onRawMouseClicked(int button, int action, int mods) {
        return MinecraftForge.EVENT_BUS.post((Event)new InputEvent.RawMouseEvent(button, action, mods));
    }

    public static InputEvent.ClickInputEvent onClickInput(int button, KeyMapping keyBinding, InteractionHand hand) {
        InputEvent.ClickInputEvent event = new InputEvent.ClickInputEvent(button, keyBinding, hand);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static void drawItemLayered(ItemRenderer renderer, BakedModel modelIn, ItemStack itemStackIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, boolean fabulous) {
        for (com.mojang.datafixers.util.Pair layerModel : modelIn.getLayerModels(itemStackIn, fabulous)) {
            BakedModel layer = (BakedModel)layerModel.getFirst();
            RenderType rendertype = (RenderType)layerModel.getSecond();
            ForgeHooksClient.setRenderLayer(rendertype);
            VertexConsumer ivertexbuilder = fabulous ? ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.m_41790_());
            renderer.m_115189_(layer, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
        }
        ForgeHooksClient.setRenderLayer(null);
    }

    public static boolean isNameplateInRenderDistance(Entity entity, double squareDistance) {
        AttributeInstance attribute;
        if (entity instanceof LivingEntity && (attribute = ((LivingEntity)entity).m_21051_((Attribute)ForgeMod.NAMETAG_DISTANCE.get())) != null) {
            return !(squareDistance > attribute.m_22135_() * attribute.m_22135_());
        }
        return !(squareDistance > 4096.0);
    }

    public static void renderPistonMovedBlocks(BlockPos pos, BlockState state, PoseStack stack, MultiBufferSource buffer, Level world, boolean checkSides, int combinedOverlay, BlockRenderDispatcher blockRenderer) {
        RenderType.m_110506_().stream().filter(t -> ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)t)).forEach(rendertype -> {
            ForgeHooksClient.setRenderLayer(rendertype);
            VertexConsumer ivertexbuilder = buffer.m_6299_(rendertype == RenderType.m_110466_() ? RenderType.m_110469_() : rendertype);
            blockRenderer.m_110937_().m_111047_((BlockAndTintGetter)world, blockRenderer.m_110910_(state), state, pos, stack, ivertexbuilder, checkSides, new Random(), state.m_60726_(pos), combinedOverlay);
        });
        ForgeHooksClient.setRenderLayer(null);
    }

    public static void registerForgeWorldTypeScreens() {
        ForgeWorldTypeScreens.registerTypes();
    }

    public static WorldPreset.PresetEditor getBiomeGeneratorTypeScreenFactory(Optional<WorldPreset> generator, @Nullable WorldPreset.PresetEditor biomegeneratortypescreens$ifactory) {
        return ForgeWorldTypeScreens.getGeneratorScreenFactory(generator, biomegeneratortypescreens$ifactory);
    }

    public static boolean hasBiomeGeneratorSettingsOptionsScreen(Optional<WorldPreset> generator) {
        return ForgeHooksClient.getBiomeGeneratorTypeScreenFactory(generator, null) != null;
    }

    public static Optional<WorldPreset> getWorldTypeFromGenerator(WorldGenSettings dimensionGeneratorSettings) {
        return WorldPreset.m_101524_((WorldGenSettings)dimensionGeneratorSettings);
    }

    public static Optional<WorldPreset> getDefaultWorldType() {
        return Optional.of(ForgeWorldTypeScreens.getDefaultGenerator());
    }

    public static boolean shouldRender(MobEffectInstance effectInstance) {
        return RenderProperties.getEffectRenderer(effectInstance).shouldRender(effectInstance);
    }

    @Nullable
    public static TextureAtlasSprite loadTextureAtlasSprite(TextureAtlas textureAtlas, ResourceManager resourceManager, TextureAtlasSprite.Info textureInfo, Resource resource, int atlasWidth, int atlasHeight, int spriteX, int spriteY, int mipmapLevel, NativeImage image) {
        ForgeTextureMetadata metadata = ForgeTextureMetadata.forResource(resource);
        return metadata.getLoader() == null ? null : metadata.getLoader().load(textureAtlas, resourceManager, textureInfo, resource, atlasWidth, atlasHeight, spriteX, spriteY, mipmapLevel, image);
    }

    public static void registerLayerDefinition(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
        layerDefinitions.put(layerLocation, supplier);
    }

    public static void loadLayerDefinitions(ImmutableMap.Builder<ModelLayerLocation, LayerDefinition> builder) {
        layerDefinitions.forEach((k, v) -> builder.put(k, (Object)((LayerDefinition)v.get())));
    }

    public static void processForgeListPingData(ServerStatus packet, ServerData target) {
        if (packet.getForgeData() != null) {
            Map<String, String> mods = packet.getForgeData().getRemoteModData();
            Map<ResourceLocation, Pair<String, Boolean>> remoteChannels = packet.getForgeData().getRemoteChannels();
            int fmlver = packet.getForgeData().getFMLNetworkVersion();
            boolean fmlNetMatches = fmlver == 2;
            boolean channelsMatch = NetworkRegistry.checkListPingCompatibilityForClient(remoteChannels);
            AtomicBoolean result = new AtomicBoolean(true);
            ArrayList extraClientMods = new ArrayList();
            ModList.get().forEachModContainer((modid, mc) -> mc.getCustomExtension(IExtensionPoint.DisplayTest.class).ifPresent(ext -> {
                boolean foundModOnServer = ext.remoteVersionTest().test((String)mods.get(modid), true);
                result.compareAndSet(true, foundModOnServer);
                if (!foundModOnServer) {
                    extraClientMods.add(modid);
                }
            }));
            boolean modsMatch = result.get();
            Map<String, String> extraServerMods = mods.entrySet().stream().filter(e -> !Objects.equals("OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", e.getValue())).filter(e -> !ModList.get().isLoaded((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            LOGGER.debug(CLIENTHOOKS, "Received FML ping data from server at {}: FMLNETVER={}, mod list is compatible : {}, channel list is compatible: {}, extra server mods: {}", (Object)target.f_105363_, (Object)fmlver, (Object)modsMatch, (Object)channelsMatch, extraServerMods);
            String extraReason = null;
            if (!extraServerMods.isEmpty()) {
                extraReason = "fml.menu.multiplayer.extraservermods";
                LOGGER.info(CLIENTHOOKS, ForgeI18n.parseMessage(extraReason, new Object[0]) + ": {}", (Object)extraServerMods.entrySet().stream().map(e -> (String)e.getKey() + "@" + (String)e.getValue()).collect(Collectors.joining(", ")));
            }
            if (!modsMatch) {
                extraReason = "fml.menu.multiplayer.modsincompatible";
                LOGGER.info(CLIENTHOOKS, "Client has mods that are missing on server: {}", extraClientMods);
            }
            if (!channelsMatch) {
                extraReason = "fml.menu.multiplayer.networkincompatible";
            }
            if (fmlver < 2) {
                extraReason = "fml.menu.multiplayer.serveroutdated";
            }
            if (fmlver > 2) {
                extraReason = "fml.menu.multiplayer.clientoutdated";
            }
            target.forgeData = new ExtendedServerListData("FML", extraServerMods.isEmpty() && fmlNetMatches && channelsMatch && modsMatch, mods.size(), extraReason, packet.getForgeData().isTruncated());
        } else {
            target.forgeData = new ExtendedServerListData("VANILLA", NetworkRegistry.canConnectToVanillaServer(), 0, null);
        }
    }

    public static void drawForgePingInfo(JoinMultiplayerScreen gui, ServerData target, PoseStack mStack, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        Object tooltip;
        int idx;
        if (target.forgeData == null) {
            return;
        }
        switch (target.forgeData.type) {
            case "FML": {
                if (target.forgeData.isCompatible) {
                    idx = 0;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.compatible", target.forgeData.numberOfMods);
                } else {
                    idx = 16;
                    if (target.forgeData.extraReason != null) {
                        String extraReason = ForgeI18n.parseMessage(target.forgeData.extraReason, new Object[0]);
                        tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible.extra", extraReason);
                    } else {
                        tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.incompatible", new Object[0]);
                    }
                }
                if (!target.forgeData.truncated) break;
                tooltip = (String)tooltip + "\n" + ForgeI18n.parseMessage("fml.menu.multiplayer.truncated", new Object[0]);
                break;
            }
            case "VANILLA": {
                if (target.forgeData.isCompatible) {
                    idx = 48;
                    tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla", new Object[0]);
                    break;
                }
                idx = 80;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.vanilla.incompatible", new Object[0]);
                break;
            }
            default: {
                idx = 64;
                tooltip = ForgeI18n.parseMessage("fml.menu.multiplayer.unknown", target.forgeData.type);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICON_SHEET);
        GuiComponent.m_93160_((PoseStack)mStack, (int)(x + width - 18), (int)(y + 10), (int)16, (int)16, (float)0.0f, (float)idx, (int)16, (int)16, (int)256, (int)256);
        if (relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26) {
            gui.m_99707_(Arrays.stream(((String)tooltip).split("\n")).map(TextComponent::new).collect(Collectors.toList()));
        }
    }

    private static Connection getClientToServerNetworkManager() {
        return Minecraft.m_91087_().m_91403_() != null ? Minecraft.m_91087_().m_91403_().m_6198_() : null;
    }

    public static void handleClientWorldClosing(ClientLevel world) {
        Connection client = ForgeHooksClient.getClientToServerNetworkManager();
        if (client != null && !client.m_129531_()) {
            GameData.revertToFrozen();
        }
    }

    public static void firePlayerLogin(MultiPlayerGameMode pc, LocalPlayer player, Connection networkManager) {
        MinecraftForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggedInEvent(pc, player, networkManager));
    }

    public static void firePlayerLogout(MultiPlayerGameMode pc, LocalPlayer player) {
        MinecraftForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.LoggedOutEvent(pc, player, player != null ? (player.f_108617_ != null ? player.f_108617_.m_6198_() : null) : null));
    }

    public static void firePlayerRespawn(MultiPlayerGameMode pc, LocalPlayer oldPlayer, LocalPlayer newPlayer, Connection networkManager) {
        MinecraftForge.EVENT_BUS.post((Event)new ClientPlayerNetworkEvent.RespawnEvent(pc, oldPlayer, newPlayer, networkManager));
    }

    static {
        flipX = Matrix4f.m_27632_((float)-1.0f, (float)1.0f, (float)1.0f);
        flipXNormal = new Matrix3f(flipX);
        slotMainHand = 0;
        layerDefinitions = new HashMap<ModelLayerLocation, Supplier<LayerDefinition>>();
        ICON_SHEET = new ResourceLocation("forge", "textures/gui/icons.png");
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="forge", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientEvents {
        @Nullable
        private static ShaderInstance rendertypeEntityTranslucentUnlitShader;

        public static ShaderInstance getEntityTranslucentUnlitShader() {
            return Objects.requireNonNull(rendertypeEntityTranslucentUnlitShader, "Attempted to call getEntityTranslucentUnlitShader before shaders have finished loading.");
        }

        @SubscribeEvent
        public static void registerShaders(RegisterShadersEvent event) throws IOException {
            event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), new ResourceLocation("forge", "rendertype_entity_unlit_translucent"), DefaultVertexFormat.f_85812_), p_172645_ -> {
                rendertypeEntityTranslucentUnlitShader = p_172645_;
            });
        }
    }
}

