/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;
import org.apache.commons.lang3.tuple.Pair;

public class MinecraftForgeClient {
    private static BitSet stencilBits = new BitSet(8);
    private static final LoadingCache<Pair<Level, BlockPos>, Optional<RenderChunkRegion>> regionCache;
    private static HashMap<ResourceLocation, Supplier<NativeImage>> bufferedImageSuppliers;
    private static final Map<ResourceLocation, ITextureAtlasSpriteLoader> textureAtlasSpriteLoaders;

    public static RenderType getRenderLayer() {
        return ForgeHooksClient.renderLayer.get();
    }

    public static Locale getLocale() {
        return Minecraft.m_91087_().m_91102_().m_118983_().getJavaLocale();
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < stencilBits.length()) {
            stencilBits.set(bit);
        }
    }

    public static void onRebuildChunk(Level world, BlockPos position, RenderChunkRegion cache) {
        if (cache == null) {
            regionCache.invalidate((Object)Pair.of((Object)world, (Object)position));
        } else {
            regionCache.put((Object)Pair.of((Object)world, (Object)position), Optional.of(cache));
        }
    }

    @Nullable
    public static RenderChunkRegion getRegionRenderCache(Level world, BlockPos pos) {
        return MinecraftForgeClient.getRegionRenderCacheOptional(world, pos).orElse(null);
    }

    public static Optional<RenderChunkRegion> getRegionRenderCacheOptional(Level world, BlockPos pos) {
        int x = pos.m_123341_() & 0xFFFFFFF0;
        int y = pos.m_123342_() & 0xFFFFFFF0;
        int z = pos.m_123343_() & 0xFFFFFFF0;
        return (Optional)regionCache.getUnchecked((Object)Pair.of((Object)world, (Object)new BlockPos(x, y, z)));
    }

    public static void clearRenderCache() {
        regionCache.invalidateAll();
        regionCache.cleanUp();
    }

    public static void registerImageLayerSupplier(ResourceLocation resourceLocation, Supplier<NativeImage> supplier) {
        bufferedImageSuppliers.put(resourceLocation, supplier);
    }

    @Nonnull
    public static NativeImage getImageLayer(ResourceLocation resourceLocation, ResourceManager resourceManager) throws IOException {
        Supplier<NativeImage> supplier = bufferedImageSuppliers.get(resourceLocation);
        if (supplier != null) {
            return supplier.get();
        }
        Resource iresource1 = resourceManager.m_142591_(resourceLocation);
        return NativeImage.m_85058_((InputStream)iresource1.m_6679_());
    }

    public static void registerTextureAtlasSpriteLoader(ResourceLocation name, ITextureAtlasSpriteLoader loader) {
        textureAtlasSpriteLoaders.put(name, loader);
    }

    @Nullable
    public static ITextureAtlasSpriteLoader getTextureAtlasSpriteLoader(ResourceLocation name) {
        return textureAtlasSpriteLoaders.get(name);
    }

    static {
        stencilBits.set(0, 8);
        regionCache = CacheBuilder.newBuilder().maximumSize(500L).concurrencyLevel(5).expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<Level, BlockPos>, Optional<RenderChunkRegion>>(){

            public Optional<RenderChunkRegion> load(Pair<Level, BlockPos> key) {
                return Optional.ofNullable(RenderChunkRegion.m_112920_((Level)((Level)key.getLeft()), (BlockPos)((BlockPos)key.getRight()).m_142082_(-1, -1, -1), (BlockPos)((BlockPos)key.getRight()).m_142082_(16, 16, 16), (int)1));
            }
        });
        bufferedImageSuppliers = new HashMap();
        textureAtlasSpriteLoaders = new ConcurrentHashMap<ResourceLocation, ITextureAtlasSpriteLoader>();
    }
}

