/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoadingException;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.b3d.B3DClip;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.property.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum B3DLoader {
    INSTANCE;

    private static final Logger LOGGER;
    private ResourceManager manager;
    private final Set<String> enabledDomains = new HashSet<String>();
    private final Map<ResourceLocation, B3DModel> cache = new HashMap<ResourceLocation, B3DModel>();

    public UnbakedModel loadModel(ResourceLocation modelLocation) throws Exception {
        B3DModel model;
        ResourceLocation file = new ResourceLocation(modelLocation.m_135827_(), modelLocation.m_135815_());
        if (!this.cache.containsKey(file)) {
            Resource resource = null;
            try {
                try {
                    resource = this.manager.m_142591_(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.m_135815_().startsWith("models/block/")) {
                        resource = this.manager.m_142591_(new ResourceLocation(file.m_135827_(), "models/item/" + file.m_135815_().substring("models/block/".length())));
                    }
                    if (modelLocation.m_135815_().startsWith("models/item/")) {
                        resource = this.manager.m_142591_(new ResourceLocation(file.m_135827_(), "models/block/" + file.m_135815_().substring("models/item/".length())));
                    }
                    throw e;
                }
                B3DModel.Parser parser = new B3DModel.Parser(resource.m_6679_());
                B3DModel model2 = parser.parse();
                this.cache.put(file, model2);
            }
            catch (IOException e) {
                try {
                    this.cache.put(file, null);
                    throw e;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(resource);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
        if ((model = this.cache.get(file)) == null) {
            throw new ModelLoadingException("Error loading model previously: " + file);
        }
        if (!(model.getRoot().getKind() instanceof B3DModel.Mesh)) {
            return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of(), true, true, true, 1);
        }
        return new ModelWrapper(modelLocation, model, (ImmutableSet<String>)ImmutableSet.of((Object)model.getRoot().getName()), true, true, true, 1);
    }

    static {
        LOGGER = LogManager.getLogger();
    }

    private static final class ModelWrapper
    implements UnbakedModel {
        private final ResourceLocation modelLocation;
        private final B3DModel model;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, String> textures;
        private final boolean smooth;
        private final boolean gui3d;
        private final boolean isSideLit;
        private final int defaultKey;

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, boolean isSideLit, int defaultKey) {
            this(modelLocation, model, meshes, smooth, gui3d, isSideLit, defaultKey, ModelWrapper.buildTextures(model.getTextures()));
        }

        public ModelWrapper(ResourceLocation modelLocation, B3DModel model, ImmutableSet<String> meshes, boolean smooth, boolean gui3d, boolean isSideLit, int defaultKey, ImmutableMap<String, String> textures) {
            this.modelLocation = modelLocation;
            this.model = model;
            this.meshes = meshes;
            this.isSideLit = isSideLit;
            this.textures = textures;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.defaultKey = defaultKey;
        }

        private static ImmutableMap<String, String> buildTextures(List<B3DModel.Texture> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (B3DModel.Texture t : textures) {
                String path = t.getPath();
                Object location = ModelWrapper.getLocation(path);
                if (!((String)location).startsWith("#")) {
                    location = "#" + (String)location;
                }
                builder.put((Object)path, location);
            }
            return builder.build();
        }

        private static String getLocation(String path) {
            if (path.endsWith(".png")) {
                path = path.substring(0, path.length() - ".png".length());
            }
            return path;
        }

        public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            return this.textures.values().stream().filter(loc -> !loc.startsWith("#")).map(t -> new Material(TextureAtlas.f_118259_, new ResourceLocation(t))).collect(Collectors.toList());
        }

        public Collection<ResourceLocation> m_7970_() {
            return Collections.emptyList();
        }

        @Nullable
        public BakedModel m_7611_(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            TextureAtlasSprite missing = spriteGetter.apply(new Material(TextureAtlas.f_118259_, MissingTextureAtlasSprite.m_118071_()));
            for (Map.Entry e : this.textures.entrySet()) {
                if (((String)e.getValue()).startsWith("#")) {
                    LOGGER.fatal("unresolved texture '{}' for b3d model '{}'", e.getValue(), (Object)this.modelLocation);
                    builder.put((Object)((String)e.getKey()), (Object)missing);
                    continue;
                }
                builder.put((Object)((String)e.getKey()), (Object)spriteGetter.apply(new Material(TextureAtlas.f_118259_, new ResourceLocation((String)e.getValue()))));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new BakedWrapper(this.model.getRoot(), modelTransform, this.smooth, this.gui3d, this.isSideLit, this.meshes, (ImmutableMap<String, TextureAtlasSprite>)builder.build());
        }

        public ModelWrapper retexture(ImmutableMap<String, String> textures) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry e : this.textures.entrySet()) {
                String path = (String)e.getKey();
                String loc = ModelWrapper.getLocation(path);
                if (loc.startsWith("#") && (textures.containsKey((Object)loc) || textures.containsKey((Object)loc.substring(1)))) {
                    String alt = loc.substring(1);
                    String newLoc = (String)textures.get((Object)loc);
                    if (newLoc == null) {
                        newLoc = (String)textures.get((Object)alt);
                    }
                    if (newLoc == null) {
                        newLoc = path.substring(1);
                    }
                    builder.put((Object)((String)e.getKey()), (Object)newLoc);
                    continue;
                }
                builder.put(e);
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, this.gui3d, this.isSideLit, this.defaultKey, (ImmutableMap<String, String>)builder.build());
        }

        public ModelWrapper process(ImmutableMap<String, String> data) {
            JsonElement e;
            ImmutableSet newMeshes = this.meshes;
            int newDefaultKey = this.defaultKey;
            boolean hasChanged = false;
            if (data.containsKey((Object)"mesh")) {
                e = new JsonParser().parse((String)data.get((Object)"mesh"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
                    return new ModelWrapper(this.modelLocation, this.model, (ImmutableSet<String>)ImmutableSet.of((Object)e.getAsString()), this.smooth, this.gui3d, this.isSideLit, this.defaultKey, this.textures);
                }
                if (e.isJsonArray()) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (JsonElement s : e.getAsJsonArray()) {
                        if (s.isJsonPrimitive() && s.getAsJsonPrimitive().isString()) {
                            builder.add((Object)s.getAsString());
                            continue;
                        }
                        LOGGER.fatal("unknown mesh definition '{}' in array for b3d model '{}'", (Object)s.toString(), (Object)this.modelLocation);
                        return this;
                    }
                    newMeshes = builder.build();
                    hasChanged = true;
                } else {
                    LOGGER.fatal("unknown mesh definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            if (data.containsKey((Object)"key")) {
                e = new JsonParser().parse((String)data.get((Object)"key"));
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    newDefaultKey = e.getAsNumber().intValue();
                    hasChanged = true;
                } else {
                    LOGGER.fatal("unknown keyframe definition '{}' for b3d model '{}'", (Object)e.toString(), (Object)this.modelLocation);
                    return this;
                }
            }
            return hasChanged ? new ModelWrapper(this.modelLocation, this.model, newMeshes, this.smooth, this.gui3d, this.isSideLit, newDefaultKey, this.textures) : this;
        }

        public Optional<IClip> getClip(String name) {
            if (name.equals("main")) {
                return Optional.of(B3DClip.INSTANCE);
            }
            return Optional.empty();
        }

        public ModelState getDefaultState() {
            return new B3DState(this.model.getRoot().getAnimation(), this.defaultKey, this.defaultKey, 0.0f);
        }

        public ModelWrapper smoothLighting(boolean value) {
            if (value == this.smooth) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, value, this.gui3d, this.isSideLit, this.defaultKey, this.textures);
        }

        public ModelWrapper gui3d(boolean value) {
            if (value == this.gui3d) {
                return this;
            }
            return new ModelWrapper(this.modelLocation, this.model, this.meshes, this.smooth, value, this.isSideLit, this.defaultKey, this.textures);
        }
    }

    private static final class BakedWrapper
    implements IDynamicBakedModel {
        private final B3DModel.Node<?> node;
        private final ModelState state;
        private final boolean smooth;
        private final boolean gui3d;
        private final boolean isSideLit;
        private final ImmutableSet<String> meshes;
        private final ImmutableMap<String, TextureAtlasSprite> textures;
        private final LoadingCache<Integer, B3DState> cache;
        private ImmutableList<BakedQuad> quads;

        public BakedWrapper(final B3DModel.Node<?> node, final ModelState state, boolean smooth, boolean gui3d, boolean isSideLit, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures) {
            this(node, state, smooth, gui3d, isSideLit, meshes, textures, (LoadingCache<Integer, B3DState>)CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Integer, B3DState>(){

                public B3DState load(Integer frame) throws Exception {
                    ModelState parent = state;
                    B3DModel.Animation newAnimation = node.getAnimation();
                    if (parent instanceof B3DState) {
                        B3DState ps = (B3DState)parent;
                        parent = ps.getParent();
                    }
                    return new B3DState(newAnimation, frame, frame, 0.0f, parent);
                }
            }));
        }

        public BakedWrapper(B3DModel.Node<?> node, ModelState state, boolean smooth, boolean gui3d, boolean isSideLit, ImmutableSet<String> meshes, ImmutableMap<String, TextureAtlasSprite> textures, LoadingCache<Integer, B3DState> cache) {
            this.node = node;
            this.state = state;
            this.smooth = smooth;
            this.gui3d = gui3d;
            this.isSideLit = isSideLit;
            this.meshes = meshes;
            this.textures = textures;
            this.cache = cache;
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            ImmutableList.Builder builder;
            if (side != null) {
                return ImmutableList.of();
            }
            Object modelState = this.state;
            ModelState newState = data.getData(Properties.AnimationProperty);
            if (newState != null) {
                ModelState parent = this.state;
                if (parent instanceof B3DState) {
                    B3DState ps = (B3DState)parent;
                    parent = ps.getParent();
                }
                modelState = parent == null ? newState : new CompositeModelState(parent, newState);
            }
            if (this.quads == null) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, this.state, (ImmutableList<String>)ImmutableList.of());
                this.quads = builder.build();
            }
            if (this.state != modelState) {
                builder = ImmutableList.builder();
                this.generateQuads((ImmutableList.Builder<BakedQuad>)builder, this.node, (ModelState)modelState, (ImmutableList<String>)ImmutableList.of());
                return builder.build();
            }
            return this.quads;
        }

        private void generateQuads(ImmutableList.Builder<BakedQuad> builder, B3DModel.Node<?> node, final ModelState state, ImmutableList<String> path) {
            ImmutableList.Builder pathBuilder = ImmutableList.builder();
            pathBuilder.addAll(path);
            pathBuilder.add((Object)node.getName());
            ImmutableList newPath = pathBuilder.build();
            for (B3DModel.Node child : node.getNodes().values()) {
                this.generateQuads(builder, child, state, (ImmutableList<String>)newPath);
            }
            if (node.getKind() instanceof B3DModel.Mesh && this.meshes.contains((Object)node.getName()) && state.getPartTransformation(Models.getHiddenModelPart((ImmutableList<String>)newPath)).isIdentity()) {
                B3DModel.Mesh mesh = (B3DModel.Mesh)node.getKind();
                ImmutableList<B3DModel.Face> faces = mesh.bake(new Function<B3DModel.Node<?>, Matrix4f>(){
                    private final Transformation global;
                    private final LoadingCache<B3DModel.Node<?>, Transformation> localCache;
                    {
                        this.global = state.m_6189_();
                        this.localCache = CacheBuilder.newBuilder().maximumSize(32L).build(new CacheLoader<B3DModel.Node<?>, Transformation>(){

                            public Transformation load(B3DModel.Node<?> node) throws Exception {
                                return state.getPartTransformation((Object)new NodeJoint(node));
                            }
                        });
                    }

                    @Override
                    public Matrix4f apply(B3DModel.Node<?> node) {
                        return this.global.m_121096_((Transformation)this.localCache.getUnchecked(node)).m_121104_();
                    }
                });
                for (B3DModel.Face f : faces) {
                    List<B3DModel.Texture> textures = null;
                    if (f.getBrush() != null) {
                        textures = f.getBrush().getTextures();
                    }
                    TextureAtlasSprite sprite = textures == null || textures.isEmpty() ? (TextureAtlasSprite)this.textures.get((Object)"missingno") : (textures.get(0) == B3DModel.Texture.White ? ModelLoader.White.instance() : (TextureAtlasSprite)this.textures.get((Object)textures.get(0).getPath()));
                    BakedQuadBuilder quadBuilder = new BakedQuadBuilder(sprite);
                    quadBuilder.setContractUVs(true);
                    quadBuilder.setQuadOrientation(Direction.m_122372_((float)f.getNormal().m_122239_(), (float)f.getNormal().m_122260_(), (float)f.getNormal().m_122269_()));
                    this.putVertexData(quadBuilder, f.getV1(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV2(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    this.putVertexData(quadBuilder, f.getV3(), f.getNormal(), sprite);
                    builder.add((Object)quadBuilder.build());
                }
            }
        }

        private final void putVertexData(IVertexConsumer consumer, B3DModel.Vertex v, Vector3f faceNormal, TextureAtlasSprite sprite) {
            ImmutableList vertexFormatElements = consumer.getVertexFormat().m_86023_();
            block6: for (int e = 0; e < vertexFormatElements.size(); ++e) {
                switch (((VertexFormatElement)vertexFormatElements.get(e)).m_86048_()) {
                    case POSITION: {
                        consumer.put(e, v.getPos().m_122239_(), v.getPos().m_122260_(), v.getPos().m_122269_(), 1.0f);
                        continue block6;
                    }
                    case COLOR: {
                        if (v.getColor() != null) {
                            consumer.put(e, v.getColor().m_123601_(), v.getColor().m_123615_(), v.getColor().m_123616_(), v.getColor().m_123617_());
                            continue block6;
                        }
                        consumer.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                        continue block6;
                    }
                    case UV: {
                        if (((VertexFormatElement)vertexFormatElements.get(e)).m_86049_() < v.getTexCoords().length) {
                            consumer.put(e, sprite.m_118367_((double)(v.getTexCoords()[0].m_123601_() * 16.0f)), sprite.m_118393_((double)(v.getTexCoords()[0].m_123615_() * 16.0f)), 0.0f, 1.0f);
                            continue block6;
                        }
                        consumer.put(e, 0.0f, 0.0f, 0.0f, 1.0f);
                        continue block6;
                    }
                    case NORMAL: {
                        if (v.getNormal() != null) {
                            consumer.put(e, v.getNormal().m_122239_(), v.getNormal().m_122260_(), v.getNormal().m_122269_(), 0.0f);
                            continue block6;
                        }
                        consumer.put(e, faceNormal.m_122239_(), faceNormal.m_122260_(), faceNormal.m_122269_(), 0.0f);
                        continue block6;
                    }
                    default: {
                        consumer.put(e, new float[0]);
                    }
                }
            }
        }

        public boolean m_7541_() {
            return this.smooth;
        }

        public boolean m_7539_() {
            return this.gui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return (TextureAtlasSprite)this.textures.values().asList().get(0);
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
            return PerspectiveMapWrapper.handlePerspective((BakedModel)this, this.state, cameraTransformType, poseStack);
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }
    }

    static final class NodeJoint
    implements IJoint {
        private final B3DModel.Node<?> node;

        public NodeJoint(B3DModel.Node<?> node) {
            this.node = node;
        }

        @Override
        public Transformation getInvBindPose() {
            Matrix4f m = new Transformation(this.node.getPos(), this.node.getRot(), this.node.getScale(), null).m_121104_();
            m.m_27657_();
            Transformation pose = new Transformation(m);
            if (this.node.getParent() != null) {
                Transformation parent = new NodeJoint(this.node.getParent()).getInvBindPose();
                pose = pose.m_121096_(parent);
            }
            return pose;
        }

        public Optional<NodeJoint> getParent() {
            if (this.node.getParent() == null) {
                return Optional.empty();
            }
            return Optional.of(new NodeJoint(this.node.getParent()));
        }

        public B3DModel.Node<?> getNode() {
            return this.node;
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeJoint other = (NodeJoint)obj;
            return Objects.equal(this.node, other.node);
        }
    }

    public static final class B3DState
    implements ModelState {
        @Nullable
        private final B3DModel.Animation animation;
        private final int frame;
        private final int nextFrame;
        private final float progress;
        @Nullable
        private final ModelState parent;
        private static LoadingCache<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, Transformation> cache = CacheBuilder.newBuilder().maximumSize(16384L).expireAfterAccess(2L, TimeUnit.MINUTES).build(new CacheLoader<Triple<B3DModel.Animation, B3DModel.Node<?>, Integer>, Transformation>(){

            public Transformation load(Triple<B3DModel.Animation, B3DModel.Node<?>, Integer> key) throws Exception {
                return B3DState.getNodeMatrix((B3DModel.Animation)key.getLeft(), (B3DModel.Node)key.getMiddle(), (Integer)key.getRight());
            }
        });

        public B3DState(@Nullable B3DModel.Animation animation, int frame) {
            this(animation, frame, frame, 0.0f);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, ModelState parent) {
            this(animation, frame, frame, 0.0f, parent);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress) {
            this(animation, frame, nextFrame, progress, null);
        }

        public B3DState(@Nullable B3DModel.Animation animation, int frame, int nextFrame, float progress, @Nullable ModelState parent) {
            this.animation = animation;
            this.frame = frame;
            this.nextFrame = nextFrame;
            this.progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
            this.parent = this.getParent(parent);
        }

        @Nullable
        private ModelState getParent(@Nullable ModelState parent) {
            if (parent == null) {
                return null;
            }
            if (parent instanceof B3DState) {
                return ((B3DState)parent).parent;
            }
            return parent;
        }

        @Nullable
        public B3DModel.Animation getAnimation() {
            return this.animation;
        }

        public int getFrame() {
            return this.frame;
        }

        public int getNextFrame() {
            return this.nextFrame;
        }

        public float getProgress() {
            return this.progress;
        }

        @Nullable
        public ModelState getParent() {
            return this.parent;
        }

        public Transformation m_6189_() {
            if (this.parent != null) {
                return this.parent.m_6189_();
            }
            return Transformation.m_121093_();
        }

        public Transformation getPartTransformation(Object part) {
            Transformation nodeTransform;
            if (!(part instanceof NodeJoint)) {
                return Transformation.m_121093_();
            }
            B3DModel.Node<?> node = ((NodeJoint)part).getNode();
            if ((double)this.progress < 1.0E-5 || this.frame == this.nextFrame) {
                nodeTransform = this.getNodeMatrix(node, this.frame);
            } else if ((double)this.progress > 0.99999) {
                nodeTransform = this.getNodeMatrix(node, this.nextFrame);
            } else {
                nodeTransform = this.getNodeMatrix(node, this.frame);
                nodeTransform = TransformationHelper.slerp(nodeTransform, this.getNodeMatrix(node, this.nextFrame), this.progress);
            }
            if (this.parent != null && node.getParent() == null) {
                return this.parent.getPartTransformation(part).m_121096_(nodeTransform);
            }
            return nodeTransform;
        }

        public Transformation getNodeMatrix(B3DModel.Node<?> node) {
            return this.getNodeMatrix(node, this.frame);
        }

        public Transformation getNodeMatrix(B3DModel.Node<?> node, int frame) {
            return (Transformation)cache.getUnchecked((Object)Triple.of((Object)this.animation, node, (Object)frame));
        }

        public static Transformation getNodeMatrix(@Nullable B3DModel.Animation animation, B3DModel.Node<?> node, int frame) {
            Transformation ret = Transformation.m_121093_();
            B3DModel.Key key = null;
            if (animation != null) {
                key = (B3DModel.Key)animation.getKeys().get((Object)frame, node);
            } else if (node.getAnimation() != null) {
                key = (B3DModel.Key)node.getAnimation().getKeys().get((Object)frame, node);
            }
            if (key != null) {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    Transformation pm = (Transformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.m_121096_(pm);
                    ret = ret.m_121096_(new Transformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.m_121096_(new Transformation(key.getPos(), key.getRot(), key.getScale(), null));
                Transformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.m_121096_(invBind);
            } else {
                B3DModel.Node<B3DModel.IKind<?>> parent = node.getParent();
                if (parent != null) {
                    Transformation pm = (Transformation)cache.getUnchecked((Object)Triple.of((Object)animation, node.getParent(), (Object)frame));
                    ret = ret.m_121096_(pm);
                    ret = ret.m_121096_(new Transformation(parent.getPos(), parent.getRot(), parent.getScale(), null));
                }
                ret = ret.m_121096_(new Transformation(node.getPos(), node.getRot(), node.getScale(), null));
                Transformation invBind = new NodeJoint(node).getInvBindPose();
                ret = ret.m_121096_(invBind);
            }
            return ret;
        }
    }
}

