/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class BakedQuadBuilder
implements IVertexConsumer {
    private static final int SIZE = DefaultVertexFormat.f_85811_.m_86023_().size();
    private final float[][][] unpackedData = new float[4][SIZE][4];
    private int tint = -1;
    private Direction orientation;
    private TextureAtlasSprite texture;
    private boolean applyDiffuseLighting = true;
    private int vertices = 0;
    private int elements = 0;
    private boolean full = false;
    private boolean contractUVs = false;
    private final float eps = 0.00390625f;

    public BakedQuadBuilder() {
    }

    public BakedQuadBuilder(TextureAtlasSprite texture) {
        this.texture = texture;
    }

    public void setContractUVs(boolean value) {
        this.contractUVs = value;
    }

    @Override
    public VertexFormat getVertexFormat() {
        return DefaultVertexFormat.f_85811_;
    }

    @Override
    public void setQuadTint(int tint) {
        this.tint = tint;
    }

    @Override
    public void setQuadOrientation(Direction orientation) {
        this.orientation = orientation;
    }

    @Override
    public void setTexture(TextureAtlasSprite texture) {
        this.texture = texture;
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
        this.applyDiffuseLighting = diffuse;
    }

    @Override
    public void put(int element, float ... data) {
        for (int i = 0; i < 4; ++i) {
            this.unpackedData[this.vertices][element][i] = i < data.length ? data[i] : 0.0f;
        }
        ++this.elements;
        if (this.elements == SIZE) {
            ++this.vertices;
            this.elements = 0;
        }
        if (this.vertices == 4) {
            this.full = true;
        }
    }

    public BakedQuad build() {
        if (!this.full) {
            throw new IllegalStateException("not enough data");
        }
        if (this.texture == null) {
            throw new IllegalStateException("texture not set");
        }
        if (this.contractUVs) {
            int i;
            int v;
            VertexFormatElement e;
            int uve;
            float tY;
            float tX = (float)this.texture.m_118405_() / (this.texture.m_118410_() - this.texture.m_118409_());
            float tS = tX > (tY = (float)this.texture.m_118408_() / (this.texture.m_118412_() - this.texture.m_118411_())) ? tX : tY;
            float ep = 1.0f / (tS * 256.0f);
            ImmutableList elements = DefaultVertexFormat.f_85811_.m_86023_();
            for (uve = 0; uve < elements.size() && ((e = (VertexFormatElement)elements.get(uve)).m_86048_() != VertexFormatElement.Usage.UV || e.m_86049_() != 0); ++uve) {
            }
            if (uve == elements.size()) {
                throw new IllegalStateException("Can't contract UVs: format doesn't contain UVs");
            }
            float[] uvc = new float[4];
            for (v = 0; v < 4; ++v) {
                for (i = 0; i < 4; ++i) {
                    int n = i;
                    uvc[n] = uvc[n] + this.unpackedData[v][uve][i] / 4.0f;
                }
            }
            for (v = 0; v < 4; ++v) {
                for (i = 0; i < 4; ++i) {
                    float uo = this.unpackedData[v][uve][i];
                    float un = uo * 0.99609375f + uvc[i] * 0.00390625f;
                    float ud = uo - un;
                    float aud = ud;
                    if (aud < 0.0f) {
                        aud = -aud;
                    }
                    if (aud < ep) {
                        float udc = uo - uvc[i];
                        if (udc < 0.0f) {
                            udc = -udc;
                        }
                        un = udc < 2.0f * ep ? (uo + uvc[i]) / 2.0f : uo + (ud < 0.0f ? ep : -ep);
                    }
                    this.unpackedData[v][uve][i] = un;
                }
            }
        }
        int[] packed = new int[DefaultVertexFormat.f_85811_.m_86017_() * 4];
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < SIZE; ++e) {
                LightUtil.pack(this.unpackedData[v][e], packed, DefaultVertexFormat.f_85811_, v, e);
            }
        }
        return new BakedQuad(packed, this.tint, this.orientation, this.texture, this.applyDiffuseLighting);
    }
}

