/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

public class VertexLighterFlat
extends QuadGatheringTransformer {
    protected static final VertexFormatElement NORMAL_4F = new VertexFormatElement(0, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.NORMAL, 4);
    private static final int LIGHTMAP_PACKING_FACTOR = (256 << 8 * (DefaultVertexFormat.f_85808_.m_86041_().m_86074_() - 1)) - 1 >>> 1;
    private static final int LIGHTMAP_MAX = 240;
    private static final float LIGHTMAP_RESCALE = Math.nextAfter((float)LIGHTMAP_PACKING_FACTOR / 240.0f, (double)LIGHTMAP_PACKING_FACTOR);
    protected final BlockInfo blockInfo;
    private int tint = -1;
    private boolean diffuse = true;
    protected int posIndex = -1;
    protected int normalIndex = -1;
    protected int colorIndex = -1;
    protected int lightmapIndex = -1;
    protected VertexFormat baseFormat;
    protected PoseStack.Pose pose;

    public VertexLighterFlat(BlockColors colors) {
        this.blockInfo = new BlockInfo(colors);
    }

    @Override
    public void setParent(IVertexConsumer parent) {
        super.setParent(parent);
        this.setVertexFormat(parent.getVertexFormat());
    }

    public void setTransform(PoseStack.Pose pose) {
        this.pose = pose;
    }

    private void updateIndices() {
        block6: for (int i = 0; i < this.getVertexFormat().m_86023_().size(); ++i) {
            switch (((VertexFormatElement)this.getVertexFormat().m_86023_().get(i)).m_86048_()) {
                case POSITION: {
                    this.posIndex = i;
                    continue block6;
                }
                case NORMAL: {
                    this.normalIndex = i;
                    continue block6;
                }
                case COLOR: {
                    this.colorIndex = i;
                    continue block6;
                }
                case UV: {
                    if (((VertexFormatElement)this.getVertexFormat().m_86023_().get(i)).m_86049_() != 2) continue block6;
                    this.lightmapIndex = i;
                    continue block6;
                }
            }
        }
        if (this.posIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with position");
        }
        if (this.lightmapIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with lightmap");
        }
        if (this.colorIndex == -1) {
            throw new IllegalArgumentException("vertex lighter needs format with color");
        }
    }

    @Override
    public void setVertexFormat(VertexFormat format) {
        if (Objects.equals(format, this.baseFormat)) {
            return;
        }
        this.baseFormat = format;
        super.setVertexFormat(VertexLighterFlat.withNormal(format));
        this.updateIndices();
    }

    static VertexFormat withNormal(VertexFormat format) {
        if (format == DefaultVertexFormat.f_85811_) {
            return DefaultVertexFormat.f_85811_;
        }
        return VertexLighterFlat.withNormalUncached(format);
    }

    private static VertexFormat withNormalUncached(VertexFormat format) {
        if (format == null || format.hasNormal()) {
            return format;
        }
        HashMap m = Maps.newHashMap((Map)format.getElementMapping());
        m.put("Normal", NORMAL_4F);
        return new VertexFormat(ImmutableMap.copyOf((Map)m));
    }

    @Override
    protected void processQuad() {
        int v;
        float[][] position = this.quadData[this.posIndex];
        float[][] normal = null;
        float[][] lightmap = this.quadData[this.lightmapIndex];
        float[][] color = this.quadData[this.colorIndex];
        if (this.dataLength[this.normalIndex] >= 3 && (this.quadData[this.normalIndex][0][0] != 0.0f || this.quadData[this.normalIndex][0][1] != 0.0f || this.quadData[this.normalIndex][0][2] != 0.0f)) {
            normal = this.quadData[this.normalIndex];
        } else {
            normal = new float[4][4];
            Vector3f v1 = new Vector3f(position[3]);
            Vector3f t = new Vector3f(position[1]);
            Vector3f v2 = new Vector3f(position[2]);
            v1.m_122267_(t);
            t.set(position[0]);
            v2.m_122267_(t);
            v2.m_122279_(v1);
            v2.m_122278_();
            for (v = 0; v < 4; ++v) {
                normal[v][0] = v2.m_122239_();
                normal[v][1] = v2.m_122260_();
                normal[v][2] = v2.m_122269_();
                normal[v][3] = 0.0f;
            }
        }
        int multiplier = -1;
        if (this.tint != -1) {
            multiplier = this.blockInfo.getColorMultiplier(this.tint);
        }
        VertexFormat format = this.parent.getVertexFormat();
        int count = format.m_86023_().size();
        for (v = 0; v < 4; ++v) {
            float x = position[v][0] - 0.5f;
            float y = position[v][1] - 0.5f;
            float z = position[v][2] - 0.5f;
            float blockLight = lightmap[v][0] * LIGHTMAP_RESCALE;
            float skyLight = lightmap[v][1] * LIGHTMAP_RESCALE;
            this.updateLightmap(normal[v], lightmap[v], x += normal[v][0] * 0.5f, y += normal[v][1] * 0.5f, z += normal[v][2] * 0.5f);
            if (this.dataLength[this.lightmapIndex] > 1) {
                if (blockLight > lightmap[v][0]) {
                    lightmap[v][0] = blockLight;
                }
                if (skyLight > lightmap[v][1]) {
                    lightmap[v][1] = skyLight;
                }
            }
            this.updateColor(normal[v], color[v], x, y, z, this.tint, multiplier);
            if (this.diffuse) {
                float d = LightUtil.diffuseLight(normal[v][0], normal[v][1], normal[v][2]);
                int i = 0;
                while (i < 3) {
                    float[] fArray = color[v];
                    int n = i++;
                    fArray[n] = fArray[n] * d;
                }
            }
            block9: for (int e = 0; e < count; ++e) {
                VertexFormatElement element = (VertexFormatElement)format.m_86023_().get(e);
                switch (element.m_86048_()) {
                    case POSITION: {
                        Vector4f pos = new Vector4f(position[v][0], position[v][1], position[v][2], 1.0f);
                        pos.m_123607_(this.pose.m_85861_());
                        position[v][0] = pos.m_123601_();
                        position[v][1] = pos.m_123615_();
                        position[v][2] = pos.m_123616_();
                        this.parent.put(e, position[v]);
                        continue block9;
                    }
                    case NORMAL: {
                        Vector3f norm = new Vector3f(normal[v]);
                        norm.m_122249_(this.pose.m_85864_());
                        normal[v][0] = norm.m_122239_();
                        normal[v][1] = norm.m_122260_();
                        normal[v][2] = norm.m_122269_();
                        this.parent.put(e, normal[v]);
                        continue block9;
                    }
                    case COLOR: {
                        this.parent.put(e, color[v]);
                        continue block9;
                    }
                    case UV: {
                        if (element.m_86049_() == 2) {
                            this.parent.put(e, lightmap[v]);
                            continue block9;
                        }
                    }
                    default: {
                        this.parent.put(e, this.quadData[e][v]);
                    }
                }
            }
        }
        this.tint = -1;
    }

    protected void updateLightmap(float[] normal, float[] lightmap, float x, float y, float z) {
        float e1 = 0.99f;
        float e2 = 0.95f;
        boolean full = this.blockInfo.isFullCube();
        Direction side = null;
        if ((full || y < -0.99f) && normal[1] < -0.95f) {
            side = Direction.DOWN;
        } else if ((full || y > 0.99f) && normal[1] > 0.95f) {
            side = Direction.UP;
        } else if ((full || z < -0.99f) && normal[2] < -0.95f) {
            side = Direction.NORTH;
        } else if ((full || z > 0.99f) && normal[2] > 0.95f) {
            side = Direction.SOUTH;
        } else if ((full || x < -0.99f) && normal[0] < -0.95f) {
            side = Direction.WEST;
        } else if ((full || x > 0.99f) && normal[0] > 0.95f) {
            side = Direction.EAST;
        }
        int i = side == null ? 0 : side.ordinal() + 1;
        int brightness = this.blockInfo.getPackedLight()[i];
        lightmap[0] = (float)LightTexture.m_109883_((int)brightness) / 15.0f;
        lightmap[1] = (float)LightTexture.m_109894_((int)brightness) / 15.0f;
    }

    protected void updateColor(float[] normal, float[] color, float x, float y, float z, float tint, int multiplier) {
        if (tint != -1.0f) {
            color[0] = color[0] * ((float)(multiplier >> 16 & 0xFF) / 255.0f);
            color[1] = color[1] * ((float)(multiplier >> 8 & 0xFF) / 255.0f);
            color[2] = color[2] * ((float)(multiplier & 0xFF) / 255.0f);
        }
    }

    @Override
    public void setQuadTint(int tint) {
        this.tint = tint;
    }

    @Override
    public void setQuadOrientation(Direction orientation) {
    }

    public void setQuadCulled() {
    }

    @Override
    public void setTexture(TextureAtlasSprite texture) {
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
        this.diffuse = diffuse;
    }

    public void setWorld(BlockAndTintGetter world) {
        this.blockInfo.setWorld(world);
    }

    public void setState(BlockState state) {
        this.blockInfo.setState(state);
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockInfo.setBlockPos(blockPos);
    }

    public void resetBlockInfo() {
        this.blockInfo.reset();
    }

    public void updateBlockInfo() {
        this.blockInfo.updateFlatLighting();
    }
}

