/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class CapabilityDispatcher
implements INBTSerializable<CompoundTag>,
ICapabilityProvider {
    private ICapabilityProvider[] caps;
    private INBTSerializable<Tag>[] writers;
    private String[] names;
    private final List<Runnable> listeners;

    public CapabilityDispatcher(Map<ResourceLocation, ICapabilityProvider> list, List<Runnable> listeners) {
        this(list, listeners, null);
    }

    public CapabilityDispatcher(Map<ResourceLocation, ICapabilityProvider> list, List<Runnable> listeners, @Nullable ICapabilityProvider parent) {
        ArrayList lstCaps = Lists.newArrayList();
        ArrayList lstWriters = Lists.newArrayList();
        ArrayList lstNames = Lists.newArrayList();
        this.listeners = listeners;
        if (parent != null) {
            lstCaps.add(parent);
            if (parent instanceof INBTSerializable) {
                lstWriters.add((INBTSerializable)((Object)parent));
                lstNames.add("Parent");
            }
        }
        for (Map.Entry<ResourceLocation, ICapabilityProvider> entry : list.entrySet()) {
            ICapabilityProvider prov = entry.getValue();
            lstCaps.add(prov);
            if (!(prov instanceof INBTSerializable)) continue;
            lstWriters.add((INBTSerializable)((Object)prov));
            lstNames.add(entry.getKey().toString());
        }
        this.caps = lstCaps.toArray(new ICapabilityProvider[lstCaps.size()]);
        this.writers = lstWriters.toArray(new INBTSerializable[lstWriters.size()]);
        this.names = lstNames.toArray(new String[lstNames.size()]);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        for (ICapabilityProvider c : this.caps) {
            LazyOptional<T> ret = c.getCapability(cap, side);
            if (ret == null) {
                throw new RuntimeException(String.format("Provider %s.getCapability() returned null; return LazyOptional.empty() instead!", c.getClass().getTypeName()));
            }
            if (!ret.isPresent()) continue;
            return ret;
        }
        return LazyOptional.empty();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (int x = 0; x < this.writers.length; ++x) {
            nbt.m_128365_(this.names[x], this.writers[x].serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        for (int x = 0; x < this.writers.length; ++x) {
            if (!nbt.m_128441_(this.names[x])) continue;
            this.writers[x].deserializeNBT(nbt.m_128423_(this.names[x]));
        }
    }

    public boolean areCompatible(@Nullable CapabilityDispatcher other) {
        if (other == null) {
            return this.writers.length == 0;
        }
        if (this.writers.length == 0) {
            return other.writers.length == 0;
        }
        return this.serializeNBT().equals((Object)other.serializeNBT());
    }

    public void invalidate() {
        this.listeners.forEach(Runnable::run);
    }
}

