/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CapabilityProvider<B extends CapabilityProvider<B>>
implements ICapabilityProvider {
    @VisibleForTesting
    static boolean SUPPORTS_LAZY_CAPABILITIES = true;
    @Nonnull
    private final Class<B> baseClass;
    @Nullable
    private CapabilityDispatcher capabilities;
    private boolean valid = true;
    private boolean isLazy = false;
    private Supplier<ICapabilityProvider> lazyParentSupplier = null;
    private CompoundTag lazyData = null;
    private boolean initialized = false;

    protected CapabilityProvider(Class<B> baseClass) {
        this(baseClass, false);
    }

    protected CapabilityProvider(Class<B> baseClass, boolean isLazy) {
        this.baseClass = baseClass;
        this.isLazy = SUPPORTS_LAZY_CAPABILITIES && isLazy;
    }

    protected final void gatherCapabilities() {
        this.gatherCapabilities(() -> null);
    }

    protected final void gatherCapabilities(@Nullable ICapabilityProvider parent) {
        this.gatherCapabilities(() -> parent);
    }

    protected final void gatherCapabilities(@Nullable Supplier<ICapabilityProvider> parent) {
        if (this.isLazy && !this.initialized) {
            this.lazyParentSupplier = parent == null ? () -> null : parent;
            return;
        }
        this.doGatherCapabilities(parent == null ? null : parent.get());
    }

    private void doGatherCapabilities(@Nullable ICapabilityProvider parent) {
        this.capabilities = ForgeEventFactory.gatherCapabilities(this.baseClass, this, parent);
        this.initialized = true;
    }

    @Nullable
    protected final CapabilityDispatcher getCapabilities() {
        if (this.isLazy && !this.initialized) {
            this.doGatherCapabilities(this.lazyParentSupplier == null ? null : this.lazyParentSupplier.get());
            if (this.lazyData != null) {
                this.deserializeCaps(this.lazyData);
            }
        }
        return this.capabilities;
    }

    public final boolean areCapsCompatible(CapabilityProvider<B> other) {
        return this.areCapsCompatible(other.getCapabilities());
    }

    public final boolean areCapsCompatible(@Nullable CapabilityDispatcher other) {
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp == null) {
            if (other == null) {
                return true;
            }
            return other.areCompatible(null);
        }
        return disp.areCompatible(other);
    }

    @Nullable
    protected final CompoundTag serializeCaps() {
        if (this.isLazy && !this.initialized) {
            return this.lazyData;
        }
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            return disp.serializeNBT();
        }
        return null;
    }

    protected final void deserializeCaps(CompoundTag tag) {
        if (this.isLazy && !this.initialized) {
            this.lazyData = tag;
            return;
        }
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            disp.deserializeNBT(tag);
        }
    }

    public void invalidateCaps() {
        this.valid = false;
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            disp.invalidate();
        }
    }

    public void reviveCaps() {
        this.valid = true;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        CapabilityDispatcher disp = this.getCapabilities();
        return !this.valid || disp == null ? LazyOptional.empty() : disp.getCapability(cap, side);
    }
}

