/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class CompoundIngredient
extends Ingredient {
    private List<Ingredient> children;
    private ItemStack[] stacks;
    private IntList itemIds;
    private final boolean isSimple;

    protected CompoundIngredient(List<Ingredient> children) {
        super(Stream.of(new Ingredient.Value[0]));
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(Ingredient::isSimple);
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (this.stacks == null) {
            ArrayList tmp = Lists.newArrayList();
            for (Ingredient child : this.children) {
                Collections.addAll(tmp, child.m_43908_());
            }
            this.stacks = tmp.toArray(new ItemStack[tmp.size()]);
        }
        return this.stacks;
    }

    @Nonnull
    public IntList m_43931_() {
        if (this.itemIds == null) {
            this.itemIds = new IntArrayList();
            for (Ingredient child : this.children) {
                this.itemIds.addAll(child.m_43931_());
            }
            this.itemIds.sort((Comparator)IntComparators.NATURAL_COMPARATOR);
        }
        return this.itemIds;
    }

    public boolean test(@Nullable ItemStack target) {
        if (target == null) {
            return false;
        }
        return this.children.stream().anyMatch(c -> c.test(target));
    }

    protected void invalidate() {
        this.itemIds = null;
        this.stacks = null;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @Nonnull
    public Collection<Ingredient> getChildren() {
        return this.children;
    }

    public JsonElement m_43942_() {
        if (this.children.size() == 1) {
            return this.children.get(0).m_43942_();
        }
        JsonArray json = new JsonArray();
        this.children.stream().forEach(e -> json.add(e.m_43942_()));
        return json;
    }

    public boolean m_43947_() {
        return this.m_43908_().length == 0;
    }

    public static class Serializer
    implements IIngredientSerializer<CompoundIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public CompoundIngredient parse(FriendlyByteBuf buffer) {
            return new CompoundIngredient(Stream.generate(() -> Ingredient.m_43940_((FriendlyByteBuf)buffer)).limit(buffer.m_130242_()).collect(Collectors.toList()));
        }

        @Override
        public CompoundIngredient parse(JsonObject json) {
            throw new JsonSyntaxException("CompoundIngredient should not be directly referenced in json, just use an array of ingredients.");
        }

        @Override
        public void write(FriendlyByteBuf buffer, CompoundIngredient ingredient) {
            buffer.m_130130_(ingredient.children.size());
            ingredient.children.forEach(c -> c.m_43923_(buffer));
        }
    }
}

