/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public final class ForgeItemTagsProvider
extends ItemTagsProvider {
    public ForgeItemTagsProvider(DataGenerator gen, BlockTagsProvider blockTagProvider, ExistingFileHelper existingFileHelper) {
        super(gen, blockTagProvider, "forge", existingFileHelper);
    }

    public void m_6577_() {
        this.m_126533_(Tags.Blocks.BARRELS, Tags.Items.BARRELS);
        this.m_126533_(Tags.Blocks.BARRELS_WOODEN, Tags.Items.BARRELS_WOODEN);
        this.m_126548_(Tags.Items.BONES).m_126582_((Object)Items.f_42500_);
        this.m_126548_(Tags.Items.BOOKSHELVES).m_126582_((Object)Items.f_41997_);
        this.m_126533_(Tags.Blocks.CHESTS, Tags.Items.CHESTS);
        this.m_126533_(Tags.Blocks.CHESTS_ENDER, Tags.Items.CHESTS_ENDER);
        this.m_126533_(Tags.Blocks.CHESTS_TRAPPED, Tags.Items.CHESTS_TRAPPED);
        this.m_126533_(Tags.Blocks.CHESTS_WOODEN, Tags.Items.CHESTS_WOODEN);
        this.m_126533_(Tags.Blocks.COBBLESTONE, Tags.Items.COBBLESTONE);
        this.m_126548_(Tags.Items.CROPS).addTags(new Tag.Named[]{Tags.Items.CROPS_BEETROOT, Tags.Items.CROPS_CARROT, Tags.Items.CROPS_NETHER_WART, Tags.Items.CROPS_POTATO, Tags.Items.CROPS_WHEAT});
        this.m_126548_(Tags.Items.CROPS_BEETROOT).m_126582_((Object)Items.f_42732_);
        this.m_126548_(Tags.Items.CROPS_CARROT).m_126582_((Object)Items.f_42619_);
        this.m_126548_(Tags.Items.CROPS_NETHER_WART).m_126582_((Object)Items.f_42588_);
        this.m_126548_(Tags.Items.CROPS_POTATO).m_126582_((Object)Items.f_42620_);
        this.m_126548_(Tags.Items.CROPS_WHEAT).m_126582_((Object)Items.f_42405_);
        this.m_126548_(Tags.Items.DUSTS).addTags(new Tag.Named[]{Tags.Items.DUSTS_GLOWSTONE, Tags.Items.DUSTS_PRISMARINE, Tags.Items.DUSTS_REDSTONE});
        this.m_126548_(Tags.Items.DUSTS_GLOWSTONE).m_126582_((Object)Items.f_42525_);
        this.m_126548_(Tags.Items.DUSTS_PRISMARINE).m_126582_((Object)Items.f_42695_);
        this.m_126548_(Tags.Items.DUSTS_REDSTONE).m_126582_((Object)Items.f_42451_);
        this.addColored(arg_0 -> ForgeItemTagsProvider.lambda$addTags$0(this.m_126548_(Tags.Items.DYES), arg_0), Tags.Items.DYES, "{color}_dye");
        this.m_126548_(Tags.Items.EGGS).m_126582_((Object)Items.f_42521_);
        this.m_126533_(Tags.Blocks.END_STONES, Tags.Items.END_STONES);
        this.m_126548_(Tags.Items.ENDER_PEARLS).m_126582_((Object)Items.f_42584_);
        this.m_126548_(Tags.Items.FEATHERS).m_126582_((Object)Items.f_42402_);
        this.m_126533_(Tags.Blocks.FENCE_GATES, Tags.Items.FENCE_GATES);
        this.m_126533_(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN);
        this.m_126533_(Tags.Blocks.FENCES, Tags.Items.FENCES);
        this.m_126533_(Tags.Blocks.FENCES_NETHER_BRICK, Tags.Items.FENCES_NETHER_BRICK);
        this.m_126533_(Tags.Blocks.FENCES_WOODEN, Tags.Items.FENCES_WOODEN);
        this.m_126548_(Tags.Items.GEMS).addTags(new Tag.Named[]{Tags.Items.GEMS_DIAMOND, Tags.Items.GEMS_EMERALD, Tags.Items.GEMS_LAPIS, Tags.Items.GEMS_PRISMARINE, Tags.Items.GEMS_QUARTZ});
        this.m_126548_(Tags.Items.GEMS_DIAMOND).m_126582_((Object)Items.f_42415_);
        this.m_126548_(Tags.Items.GEMS_EMERALD).m_126582_((Object)Items.f_42616_);
        this.m_126548_(Tags.Items.GEMS_LAPIS).m_126582_((Object)Items.f_42534_);
        this.m_126548_(Tags.Items.GEMS_PRISMARINE).m_126582_((Object)Items.f_42696_);
        this.m_126548_(Tags.Items.GEMS_QUARTZ).m_126582_((Object)Items.f_42692_);
        this.m_126533_(Tags.Blocks.GLASS, Tags.Items.GLASS);
        this.func_240521_a_Colored(Tags.Blocks.GLASS, Tags.Items.GLASS);
        this.m_126533_(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES);
        this.func_240521_a_Colored(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES);
        this.m_126533_(Tags.Blocks.GRAVEL, Tags.Items.GRAVEL);
        this.m_126548_(Tags.Items.GUNPOWDER).m_126582_((Object)Items.f_42403_);
        this.m_126548_(Tags.Items.HEADS).m_126584_((Object[])new Item[]{Items.f_42682_, Items.f_42683_, Items.f_42680_, Items.f_42678_, Items.f_42679_, Items.f_42681_});
        this.m_126548_(Tags.Items.INGOTS).addTags(new Tag.Named[]{Tags.Items.INGOTS_IRON, Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_BRICK, Tags.Items.INGOTS_NETHER_BRICK, Tags.Items.INGOTS_NETHERITE});
        this.m_126548_(Tags.Items.INGOTS_BRICK).m_126582_((Object)Items.f_42460_);
        this.m_126548_(Tags.Items.INGOTS_GOLD).m_126582_((Object)Items.f_42417_);
        this.m_126548_(Tags.Items.INGOTS_IRON).m_126582_((Object)Items.f_42416_);
        this.m_126548_(Tags.Items.INGOTS_NETHERITE).m_126582_((Object)Items.f_42418_);
        this.m_126548_(Tags.Items.INGOTS_NETHER_BRICK).m_126582_((Object)Items.f_42691_);
        this.m_126548_(Tags.Items.LEATHER).m_126582_((Object)Items.f_42454_);
        this.m_126548_(Tags.Items.MUSHROOMS).m_126584_((Object[])new Item[]{Items.f_41952_, Items.f_41953_});
        this.m_126548_(Tags.Items.NETHER_STARS).m_126582_((Object)Items.f_42686_);
        this.m_126533_(Tags.Blocks.NETHERRACK, Tags.Items.NETHERRACK);
        this.m_126548_(Tags.Items.NUGGETS).addTags(new Tag.Named[]{Tags.Items.NUGGETS_IRON, Tags.Items.NUGGETS_GOLD});
        this.m_126548_(Tags.Items.NUGGETS_IRON).m_126582_((Object)Items.f_42749_);
        this.m_126548_(Tags.Items.NUGGETS_GOLD).m_126582_((Object)Items.f_42587_);
        this.m_126533_(Tags.Blocks.OBSIDIAN, Tags.Items.OBSIDIAN);
        this.m_126533_(Tags.Blocks.ORES, Tags.Items.ORES);
        this.m_126533_(Tags.Blocks.ORES_COAL, Tags.Items.ORES_COAL);
        this.m_126533_(Tags.Blocks.ORES_DIAMOND, Tags.Items.ORES_DIAMOND);
        this.m_126533_(Tags.Blocks.ORES_EMERALD, Tags.Items.ORES_EMERALD);
        this.m_126533_(Tags.Blocks.ORES_GOLD, Tags.Items.ORES_GOLD);
        this.m_126533_(Tags.Blocks.ORES_IRON, Tags.Items.ORES_IRON);
        this.m_126533_(Tags.Blocks.ORES_LAPIS, Tags.Items.ORES_LAPIS);
        this.m_126533_(Tags.Blocks.ORES_QUARTZ, Tags.Items.ORES_QUARTZ);
        this.m_126533_(Tags.Blocks.ORES_REDSTONE, Tags.Items.ORES_REDSTONE);
        this.m_126533_(Tags.Blocks.ORES_NETHERITE_SCRAP, Tags.Items.ORES_NETHERITE_SCRAP);
        this.m_126548_(Tags.Items.RODS).addTags(new Tag.Named[]{Tags.Items.RODS_BLAZE, Tags.Items.RODS_WOODEN});
        this.m_126548_(Tags.Items.RODS_BLAZE).m_126582_((Object)Items.f_42585_);
        this.m_126548_(Tags.Items.RODS_WOODEN).m_126582_((Object)Items.f_42398_);
        this.m_126533_(Tags.Blocks.SAND, Tags.Items.SAND);
        this.m_126533_(Tags.Blocks.SAND_COLORLESS, Tags.Items.SAND_COLORLESS);
        this.m_126533_(Tags.Blocks.SAND_RED, Tags.Items.SAND_RED);
        this.m_126533_(Tags.Blocks.SANDSTONE, Tags.Items.SANDSTONE);
        this.m_126548_(Tags.Items.SEEDS).addTags(new Tag.Named[]{Tags.Items.SEEDS_BEETROOT, Tags.Items.SEEDS_MELON, Tags.Items.SEEDS_PUMPKIN, Tags.Items.SEEDS_WHEAT});
        this.m_126548_(Tags.Items.SEEDS_BEETROOT).m_126582_((Object)Items.f_42733_);
        this.m_126548_(Tags.Items.SEEDS_MELON).m_126582_((Object)Items.f_42578_);
        this.m_126548_(Tags.Items.SEEDS_PUMPKIN).m_126582_((Object)Items.f_42577_);
        this.m_126548_(Tags.Items.SEEDS_WHEAT).m_126582_((Object)Items.f_42404_);
        this.m_126548_(Tags.Items.SHEARS).m_126582_((Object)Items.f_42574_);
        this.m_126548_(Tags.Items.SLIMEBALLS).m_126582_((Object)Items.f_42518_);
        this.m_126533_(Tags.Blocks.STAINED_GLASS, Tags.Items.STAINED_GLASS);
        this.m_126533_(Tags.Blocks.STAINED_GLASS_PANES, Tags.Items.STAINED_GLASS_PANES);
        this.m_126533_(Tags.Blocks.STONE, Tags.Items.STONE);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Items.STORAGE_BLOCKS_COAL);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Items.STORAGE_BLOCKS_DIAMOND);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Items.STORAGE_BLOCKS_EMERALD);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Items.STORAGE_BLOCKS_GOLD);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Items.STORAGE_BLOCKS_IRON);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Items.STORAGE_BLOCKS_LAPIS);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Items.STORAGE_BLOCKS_QUARTZ);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Items.STORAGE_BLOCKS_REDSTONE);
        this.m_126533_(Tags.Blocks.STORAGE_BLOCKS_NETHERITE, Tags.Items.STORAGE_BLOCKS_NETHERITE);
        this.m_126548_(Tags.Items.STRING).m_126582_((Object)Items.f_42401_);
    }

    private void addColored(Consumer<Tag.Named<Item>> consumer, Tag.Named<Item> group, String pattern) {
        String prefix = group.m_6979_().m_135815_().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.m_41065_()));
            Tag.Named<Item> tag = this.getForgeItemTag(prefix + color.m_41065_());
            Item item = ForgeRegistries.ITEMS.getValue(key);
            if (item == null || item == Items.f_41852_) {
                throw new IllegalStateException("Unknown vanilla item: " + key.toString());
            }
            this.m_126548_(tag).m_126582_((Object)item);
            consumer.accept(tag);
        }
    }

    private void func_240521_a_Colored(Tag.Named<Block> blockGroup, Tag.Named<Item> itemGroup) {
        String blockPre = blockGroup.m_6979_().m_135815_().toUpperCase(Locale.ENGLISH) + "_";
        String itemPre = itemGroup.m_6979_().m_135815_().toUpperCase(Locale.ENGLISH) + "_";
        for (DyeColor color : DyeColor.values()) {
            Tag.Named<Block> from = this.getForgeBlockTag(blockPre + color.m_41065_());
            Tag.Named<Item> to = this.getForgeItemTag(itemPre + color.m_41065_());
            this.m_126533_(from, to);
        }
        this.m_126533_(this.getForgeBlockTag(blockPre + "colorless"), this.getForgeItemTag(itemPre + "colorless"));
    }

    private Tag.Named<Block> getForgeBlockTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (Tag.Named)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    private Tag.Named<Item> getForgeItemTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (Tag.Named)Tags.Items.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Items.class.getName() + " is missing tag name: " + name);
        }
    }

    public String m_6055_() {
        return "Forge Item Tags";
    }

    private static /* synthetic */ void lambda$addTags$0(TagsProvider.TagAppender rec$, Tag.Named xva$0) {
        rec$.addTags(new Tag.Named[]{xva$0});
    }
}

