/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.CompositeEntryBase;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.AlternativeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public final class ForgeLootTableProvider
extends LootTableProvider {
    public ForgeLootTableProvider(DataGenerator gen) {
        super(gen);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return super.getTables().stream().map(pair -> new Pair(() -> this.replaceAndFilterChangesOnly((Consumer)((Supplier)pair.getFirst()).get()), (Object)((LootContextParamSet)pair.getSecond()))).collect(Collectors.toList());
    }

    private Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> replaceAndFilterChangesOnly(Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> consumer) {
        return newConsumer -> consumer.accept((resourceLocation, builder) -> {
            if (this.findAndReplaceInLootTableBuilder((LootTable.Builder)builder, Items.f_42574_, ToolActions.SHEARS_DIG)) {
                newConsumer.accept(resourceLocation, builder);
            }
        });
    }

    private boolean findAndReplaceInLootTableBuilder(LootTable.Builder builder, Item from, ToolAction toolAction) {
        List lootPools = (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.Builder.class, (Object)builder, (String)"f_79156_");
        boolean found = false;
        if (lootPools == null) {
            throw new IllegalStateException(LootTable.Builder.class.getName() + " is missing field f_79156_");
        }
        for (LootPool lootPool : lootPools) {
            if (!this.findAndReplaceInLootPool(lootPool, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootPool(LootPool lootPool, Item from, ToolAction toolAction) {
        List lootEntries = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)lootPool, (String)"f_79023_");
        List lootConditions = (List)ObfuscationReflectionHelper.getPrivateValue(LootPool.class, (Object)lootPool, (String)"f_79024_");
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(LootPool.class.getName() + " is missing field f_79023_");
        }
        for (LootPoolEntryContainer lootEntry : lootEntries) {
            if (!(lootEntry instanceof CompositeEntryBase) || !this.findAndReplaceInParentedLootEntry((CompositeEntryBase)lootEntry, from, toolAction)) continue;
            found = true;
        }
        if (lootConditions == null) {
            throw new IllegalStateException(LootPool.class.getName() + " is missing field f_79024_");
        }
        for (int i = 0; i < lootConditions.size(); ++i) {
            LootItemCondition lootCondition = (LootItemCondition)lootConditions.get(i);
            if (lootCondition instanceof MatchTool && this.checkMatchTool((MatchTool)lootCondition, from)) {
                lootConditions.set(i, CanToolPerformAction.canToolPerformAction(toolAction).m_6409_());
                found = true;
                continue;
            }
            if (!(lootCondition instanceof InvertedLootItemCondition)) continue;
            LootItemCondition invLootCondition = (LootItemCondition)ObfuscationReflectionHelper.getPrivateValue(InvertedLootItemCondition.class, (Object)((InvertedLootItemCondition)lootCondition), (String)"f_81681_");
            if (invLootCondition instanceof MatchTool && this.checkMatchTool((MatchTool)invLootCondition, from)) {
                lootConditions.set(i, InvertedLootItemCondition.m_81694_((LootItemCondition.Builder)CanToolPerformAction.canToolPerformAction(toolAction)).m_6409_());
                found = true;
                continue;
            }
            if (!(invLootCondition instanceof AlternativeLootItemCondition) || !this.findAndReplaceInAlternative((AlternativeLootItemCondition)invLootCondition, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInParentedLootEntry(CompositeEntryBase entry, Item from, ToolAction toolAction) {
        LootPoolEntryContainer[] lootEntries = (LootPoolEntryContainer[])ObfuscationReflectionHelper.getPrivateValue(CompositeEntryBase.class, (Object)entry, (String)"f_79428_");
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(CompositeEntryBase.class.getName() + " is missing field f_79428_");
        }
        for (LootPoolEntryContainer lootEntry : lootEntries) {
            if (!this.findAndReplaceInLootEntry(lootEntry, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootEntry(LootPoolEntryContainer entry, Item from, ToolAction toolAction) {
        LootItemCondition[] lootConditions = (LootItemCondition[])ObfuscationReflectionHelper.getPrivateValue(LootPoolEntryContainer.class, (Object)entry, (String)"f_79636_");
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(LootPoolEntryContainer.class.getName() + " is missing field f_79636_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            if (lootConditions[i] instanceof AlternativeLootItemCondition && this.findAndReplaceInAlternative((AlternativeLootItemCondition)lootConditions[i], from, toolAction)) {
                found = true;
                continue;
            }
            if (!(lootConditions[i] instanceof MatchTool) || !this.checkMatchTool((MatchTool)lootConditions[i], from)) continue;
            lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).m_6409_();
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInAlternative(AlternativeLootItemCondition alternative, Item from, ToolAction toolAction) {
        LootItemCondition[] lootConditions = (LootItemCondition[])ObfuscationReflectionHelper.getPrivateValue(AlternativeLootItemCondition.class, (Object)alternative, (String)"f_81468_");
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(AlternativeLootItemCondition.class.getName() + " is missing field f_81468_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            if (!(lootConditions[i] instanceof MatchTool) || !this.checkMatchTool((MatchTool)lootConditions[i], from)) continue;
            lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).m_6409_();
            found = true;
        }
        return found;
    }

    private boolean checkMatchTool(MatchTool lootCondition, Item expected) {
        ItemPredicate predicate = (ItemPredicate)ObfuscationReflectionHelper.getPrivateValue(MatchTool.class, (Object)lootCondition, (String)"f_81993_");
        Set items = (Set)ObfuscationReflectionHelper.getPrivateValue(ItemPredicate.class, (Object)predicate, (String)"f_151427_");
        return items != null && items.contains(expected);
    }
}

