/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import com.google.common.collect.BiMap;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public interface IForgeBlock {
    private Block self() {
        return (Block)this;
    }

    default public float getFriction(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.self().m_49958_();
    }

    default public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60791_();
    }

    default public boolean isLadder(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return state.m_60620_((Tag)BlockTags.f_13082_);
    }

    default public boolean makesOpenTrapdoorAboveClimbable(BlockState state, LevelReader world, BlockPos pos, BlockState trapdoorState) {
        return state.m_60734_() instanceof LadderBlock && state.m_61143_((Property)LadderBlock.f_54337_) == trapdoorState.m_61143_((Property)TrapDoorBlock.f_54117_);
    }

    default public boolean isBurning(BlockState state, BlockGetter world, BlockPos pos) {
        return this == Blocks.f_50083_ || this == Blocks.f_49991_;
    }

    default public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return ForgeHooks.isCorrectToolForDrops(state, player);
    }

    default public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.self().m_5707_(world, pos, state, player);
        return world.m_7731_(pos, fluid.m_76188_(), world.f_46443_ ? 11 : 3);
    }

    default public boolean isBed(BlockState state, BlockGetter world, BlockPos pos, @Nullable Entity player) {
        return this.self() instanceof BedBlock;
    }

    default public Optional<Vec3> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader world, BlockPos pos, float orientation, @Nullable LivingEntity entity) {
        Level level;
        LevelReader levelReader;
        if (this.isBed(state, (BlockGetter)world, pos, (Entity)entity) && (levelReader = world) instanceof Level && BedBlock.m_49488_((Level)(level = (Level)levelReader))) {
            return BedBlock.m_49458_(type, (CollisionGetter)world, (BlockPos)pos, (float)orientation);
        }
        return Optional.empty();
    }

    default public boolean canCreatureSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return state.m_60643_(world, pos, entityType);
    }

    default public void setBedOccupied(BlockState state, Level world, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)BedBlock.f_49441_, (Comparable)Boolean.valueOf(occupied)), 3);
    }

    default public Direction getBedDirection(BlockState state, LevelReader world, BlockPos pos) {
        return (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
    }

    default public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return this.self().m_7325_();
    }

    default public ItemStack getPickBlock(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.self().m_7397_(world, pos, state);
    }

    default public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return false;
    }

    default public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean canSustainPlant(BlockState var1, BlockGetter var2, BlockPos var3, Direction var4, IPlantable var5);

    default public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_60713_(Blocks.f_50093_)) {
            return (Integer)state.m_61143_((Property)FarmBlock.f_53243_) > 0;
        }
        return false;
    }

    default public boolean isConduitFrame(BlockState state, LevelReader world, BlockPos pos, BlockPos conduit) {
        return state.m_60734_() == Blocks.f_50377_ || state.m_60734_() == Blocks.f_50378_ || state.m_60734_() == Blocks.f_50386_ || state.m_60734_() == Blocks.f_50379_;
    }

    default public boolean isPortalFrame(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_60713_(Blocks.f_50080_);
    }

    default public int getExpDrop(BlockState state, LevelReader world, BlockPos pos, int fortune, int silktouch) {
        return 0;
    }

    default public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return state.m_60717_(direction);
    }

    default public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        return state.m_60713_(Blocks.f_50078_) ? 1.0f : 0.0f;
    }

    default public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
    }

    default public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return state.m_60796_((BlockGetter)world, pos);
    }

    default public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return false;
    }

    default public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return this.self().m_49962_(state);
    }

    @Nullable
    default public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        if (this.self() instanceof BeaconBeamBlock) {
            return ((BeaconBeamBlock)this.self()).m_7988_().m_41068_();
        }
        return null;
    }

    default public BlockState getStateAtViewpoint(BlockState state, BlockGetter world, BlockPos pos, Vec3 viewpoint) {
        return state;
    }

    @Nullable
    default public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return state.m_60734_() == Blocks.f_49991_ ? BlockPathTypes.LAVA : (state.isBurning(world, pos) ? BlockPathTypes.DAMAGE_FIRE : null);
    }

    default public boolean isSlimeBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50374_;
    }

    default public boolean isStickyBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50374_ || state.m_60734_() == Blocks.f_50719_;
    }

    default public boolean canStickTo(BlockState state, BlockState other) {
        if (state.m_60734_() == Blocks.f_50719_ && other.m_60734_() == Blocks.f_50374_) {
            return false;
        }
        if (state.m_60734_() == Blocks.f_50374_ && other.m_60734_() == Blocks.f_50719_) {
            return false;
        }
        return state.isStickyBlock() || other.isStickyBlock();
    }

    default public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.f_50083_).m_53492_(state);
    }

    default public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return state.getFlammability(world, pos, face) > 0;
    }

    default public void catchFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    default public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return ((FireBlock)Blocks.f_50083_).m_53494_(state);
    }

    default public boolean isFireSource(BlockState state, LevelReader world, BlockPos pos, Direction side) {
        return state.m_60620_(world.m_6042_().m_63968_());
    }

    default public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        if (entity instanceof EnderDragon) {
            return !BlockTags.f_13069_.m_8110_((Object)this.self());
        }
        if (entity instanceof WitherBoss || entity instanceof WitherSkull) {
            return state.m_60795_() || WitherBoss.m_31491_((BlockState)state);
        }
        return true;
    }

    default public boolean canDropFromExplosion(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return state.m_60734_().m_6903_(explosion);
    }

    public Set<ResourceLocation> getTags();

    default public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.self().m_7592_(world, pos, explosion);
    }

    default public boolean collisionExtendsVertically(BlockState state, BlockGetter world, BlockPos pos, Entity collidingEntity) {
        return state.m_60620_((Tag)BlockTags.f_13039_) || state.m_60620_((Tag)BlockTags.f_13032_) || this.self() instanceof FenceGateBlock;
    }

    default public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return state.m_60734_() instanceof HalfTransparentBlock || state.m_60734_() instanceof LeavesBlock;
    }

    @Nullable
    default public BlockState getToolModifiedState(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, ToolAction toolAction) {
        if (!stack.canPerformAction(toolAction)) {
            return null;
        }
        if (ToolActions.AXE_STRIP.equals(toolAction)) {
            return AxeItem.getAxeStrippingState((BlockState)state);
        }
        if (ToolActions.AXE_SCRAPE.equals(toolAction)) {
            return WeatheringCopper.m_154899_((BlockState)state).orElse(null);
        }
        if (ToolActions.AXE_WAX_OFF.equals(toolAction)) {
            return Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(p_150694_ -> p_150694_.m_152465_(state)).orElse(null);
        }
        if (ToolActions.SHOVEL_FLATTEN.equals(toolAction)) {
            return ShovelItem.getShovelPathingState((BlockState)state);
        }
        return null;
    }

    default public boolean isScaffolding(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return state.m_60713_(Blocks.f_50616_);
    }

    default public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        if (state.m_60713_(Blocks.f_50088_)) {
            return true;
        }
        if (state.m_60713_(Blocks.f_50146_)) {
            Direction facing = (Direction)state.m_61143_((Property)RepeaterBlock.f_54117_);
            return facing == direction || facing.m_122424_() == direction;
        }
        if (state.m_60713_(Blocks.f_50455_)) {
            return direction == state.m_61143_((Property)ObserverBlock.f_52588_);
        }
        return state.m_60803_() && direction != null;
    }
}

