/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.world;

import net.minecraft.Util;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeWorldType
extends ForgeRegistryEntry<ForgeWorldType> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IChunkGeneratorFactory factory;

    public static ForgeWorldType getDefaultWorldType() {
        String defaultWorldType = ForgeConfig.COMMON.defaultWorldType.get();
        if (StringUtil.m_14408_((String)defaultWorldType) || "default".equals(defaultWorldType)) {
            return null;
        }
        ForgeWorldType def = ForgeRegistries.WORLD_TYPES.getValue(new ResourceLocation(defaultWorldType));
        if (def == null) {
            LOGGER.error("The defaultWorldType '{}' specified in the forge config has not been registered. The vanilla default generator will be used.", (Object)defaultWorldType);
        }
        return def;
    }

    public ForgeWorldType(IChunkGeneratorFactory factory) {
        this.factory = factory;
    }

    public ForgeWorldType(IBasicChunkGeneratorFactory factory) {
        this.factory = factory;
    }

    public String getTranslationKey() {
        return Util.m_137492_((String)"generator", (ResourceLocation)this.getRegistryName());
    }

    public Component getDisplayName() {
        return new TranslatableComponent(this.getTranslationKey());
    }

    public ChunkGenerator createChunkGenerator(Registry<Biome> biomeRegistry, Registry<NoiseGeneratorSettings> dimensionSettingsRegistry, long seed, String generatorSettings) {
        return this.factory.createChunkGenerator(biomeRegistry, dimensionSettingsRegistry, seed, generatorSettings);
    }

    public WorldGenSettings createSettings(RegistryAccess dynamicRegistries, long seed, boolean generateStructures, boolean generateLoot, String generatorSettings) {
        return this.factory.createSettings(dynamicRegistries, seed, generateStructures, generateLoot, generatorSettings);
    }

    public static interface IChunkGeneratorFactory {
        public ChunkGenerator createChunkGenerator(Registry<Biome> var1, Registry<NoiseGeneratorSettings> var2, long var3, String var5);

        default public WorldGenSettings createSettings(RegistryAccess dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest, String generatorSettings) {
            Registry biomeRegistry = dynamicRegistries.m_175515_(Registry.f_122885_);
            Registry dimensionTypeRegistry = dynamicRegistries.m_175515_(Registry.f_122818_);
            Registry dimensionSettingsRegistry = dynamicRegistries.m_175515_(Registry.f_122878_);
            return new WorldGenSettings(seed, generateStructures, bonusChest, WorldGenSettings.m_64633_((Registry)dimensionTypeRegistry, (MappedRegistry)DimensionType.m_63921_((Registry)dimensionTypeRegistry, (Registry)biomeRegistry, (Registry)dimensionSettingsRegistry, (long)seed), (ChunkGenerator)this.createChunkGenerator((Registry<Biome>)biomeRegistry, (Registry<NoiseGeneratorSettings>)dimensionSettingsRegistry, seed, generatorSettings)));
        }
    }

    public static interface IBasicChunkGeneratorFactory
    extends IChunkGeneratorFactory {
        public ChunkGenerator createChunkGenerator(Registry<Biome> var1, Registry<NoiseGeneratorSettings> var2, long var3);

        @Override
        default public ChunkGenerator createChunkGenerator(Registry<Biome> biomeRegistry, Registry<NoiseGeneratorSettings> dimensionSettingsRegistry, long seed, String generatorSettings) {
            return this.createChunkGenerator(biomeRegistry, dimensionSettingsRegistry, seed);
        }
    }
}

