/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.server.ServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public class AddReloadListenerEvent
extends Event {
    private final List<PreparableReloadListener> listeners = new ArrayList<PreparableReloadListener>();
    private final ServerResources dataPackRegistries;

    public AddReloadListenerEvent(ServerResources dataPackRegistries) {
        this.dataPackRegistries = dataPackRegistries;
    }

    public void addListener(PreparableReloadListener listener) {
        this.listeners.add(new WrappedStateAwareListener(listener));
    }

    public List<PreparableReloadListener> getListeners() {
        return ImmutableList.copyOf(this.listeners);
    }

    public ServerResources getDataPackRegistries() {
        return this.dataPackRegistries;
    }

    private static class WrappedStateAwareListener
    implements PreparableReloadListener {
        private final PreparableReloadListener wrapped;

        private WrappedStateAwareListener(PreparableReloadListener wrapped) {
            this.wrapped = wrapped;
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            if (ModLoader.isLoadingStateValid()) {
                return this.wrapped.m_5540_(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

