/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerResources;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingPackSizeEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PermissionsChangedEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.PistonEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;

public class ForgeEventFactory {
    public static boolean onMultiBlockPlace(@Nullable Entity entity, List<BlockSnapshot> blockSnapshots, Direction direction) {
        BlockSnapshot snap = blockSnapshots.get(0);
        BlockState placedAgainst = snap.getWorld().m_8055_(snap.getPos().m_142300_(direction.m_122424_()));
        BlockEvent.EntityMultiPlaceEvent event = new BlockEvent.EntityMultiPlaceEvent(blockSnapshots, placedAgainst, entity);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static boolean onBlockPlace(@Nullable Entity entity, @Nonnull BlockSnapshot blockSnapshot, @Nonnull Direction direction) {
        BlockState placedAgainst = blockSnapshot.getWorld().m_8055_(blockSnapshot.getPos().m_142300_(direction.m_122424_()));
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(blockSnapshot, placedAgainst, entity);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static BlockEvent.NeighborNotifyEvent onNeighborNotify(Level world, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
        BlockEvent.NeighborNotifyEvent event = new BlockEvent.NeighborNotifyEvent(world, pos, state, notifiedSides, forceRedstoneUpdate);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean doPlayerHarvestCheck(Player player, BlockState state, boolean success) {
        PlayerEvent.HarvestCheck event = new PlayerEvent.HarvestCheck(player, state, success);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.canHarvest();
    }

    public static float getBreakSpeed(Player player, BlockState state, float original, BlockPos pos) {
        PlayerEvent.BreakSpeed event = new PlayerEvent.BreakSpeed(player, state, original, pos);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? -1.0f : event.getNewSpeed();
    }

    public static void onPlayerDestroyItem(Player player, @Nonnull ItemStack stack, @Nullable InteractionHand hand) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, stack, hand));
    }

    public static Event.Result canEntitySpawn(Mob entity, LevelAccessor world, double x, double y, double z, BaseSpawner spawner, MobSpawnType spawnReason) {
        if (entity == null) {
            return Event.Result.DEFAULT;
        }
        LivingSpawnEvent.CheckSpawn event = new LivingSpawnEvent.CheckSpawn(entity, world, x, y, z, spawner, spawnReason);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static boolean canEntitySpawnSpawner(Mob entity, Level world, float x, float y, float z, BaseSpawner spawner) {
        Event.Result result = ForgeEventFactory.canEntitySpawn(entity, (LevelAccessor)world, x, y, z, spawner, MobSpawnType.SPAWNER);
        if (result == Event.Result.DEFAULT) {
            return entity.m_5545_((LevelAccessor)world, MobSpawnType.SPAWNER) && entity.m_6914_((LevelReader)world);
        }
        return result == Event.Result.ALLOW;
    }

    public static boolean doSpecialSpawn(Mob entity, Level world, float x, float y, float z, BaseSpawner spawner, MobSpawnType spawnReason) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent.SpecialSpawn(entity, world, x, y, z, spawner, spawnReason));
    }

    public static Event.Result canEntityDespawn(Mob entity) {
        LivingSpawnEvent.AllowDespawn event = new LivingSpawnEvent.AllowDespawn(entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult();
    }

    public static int getItemBurnTime(@Nonnull ItemStack itemStack, int burnTime, @Nullable RecipeType<?> recipeType) {
        FurnaceFuelBurnTimeEvent event = new FurnaceFuelBurnTimeEvent(itemStack, burnTime, recipeType);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getBurnTime();
    }

    public static int getExperienceDrop(LivingEntity entity, Player attackingPlayer, int originalExperience) {
        LivingExperienceDropEvent event = new LivingExperienceDropEvent(entity, attackingPlayer, originalExperience);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        return event.getDroppedExperience();
    }

    public static int getMaxSpawnPackSize(Mob entity) {
        LivingPackSizeEvent maxCanSpawnEvent = new LivingPackSizeEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)maxCanSpawnEvent);
        return maxCanSpawnEvent.getResult() == Event.Result.ALLOW ? maxCanSpawnEvent.getMaxPackSize() : entity.m_5792_();
    }

    public static Component getPlayerDisplayName(Player player, Component username) {
        PlayerEvent.NameFormat event = new PlayerEvent.NameFormat(player, username);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getDisplayname();
    }

    public static Component getPlayerTabListDisplayName(Player player) {
        PlayerEvent.TabListNameFormat event = new PlayerEvent.TabListNameFormat(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getDisplayName();
    }

    public static BlockState fireFluidPlaceBlockEvent(LevelAccessor world, BlockPos pos, BlockPos liquidPos, BlockState state) {
        BlockEvent.FluidPlaceBlockEvent event = new BlockEvent.FluidPlaceBlockEvent(world, pos, liquidPos, state);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewState();
    }

    public static ItemTooltipEvent onItemTooltip(ItemStack itemStack, @Nullable Player entityPlayer, List<Component> list, TooltipFlag flags) {
        ItemTooltipEvent event = new ItemTooltipEvent(itemStack, entityPlayer, list, flags);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static ZombieEvent.SummonAidEvent fireZombieSummonAid(Zombie zombie, Level world, int x, int y, int z, LivingEntity attacker, double summonChance) {
        ZombieEvent.SummonAidEvent summonEvent = new ZombieEvent.SummonAidEvent(zombie, world, x, y, z, attacker, summonChance);
        MinecraftForge.EVENT_BUS.post((Event)summonEvent);
        return summonEvent;
    }

    public static boolean onEntityStruckByLightning(Entity entity, LightningBolt bolt) {
        return MinecraftForge.EVENT_BUS.post((Event)new EntityStruckByLightningEvent(entity, bolt));
    }

    public static int onItemUseStart(LivingEntity entity, ItemStack item, int duration) {
        LivingEntityUseItemEvent.Start event = new LivingEntityUseItemEvent.Start(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? -1 : event.getDuration();
    }

    public static int onItemUseTick(LivingEntity entity, ItemStack item, int duration) {
        LivingEntityUseItemEvent.Tick event = new LivingEntityUseItemEvent.Tick(entity, item, duration);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? -1 : event.getDuration();
    }

    public static boolean onUseItemStop(LivingEntity entity, ItemStack item, int duration) {
        return MinecraftForge.EVENT_BUS.post((Event)new LivingEntityUseItemEvent.Stop(entity, item, duration));
    }

    public static ItemStack onItemUseFinish(LivingEntity entity, ItemStack item, int duration, ItemStack result) {
        LivingEntityUseItemEvent.Finish event = new LivingEntityUseItemEvent.Finish(entity, item, duration, result);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResultStack();
    }

    public static void onStartEntityTracking(Entity entity, Player player) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.StartTracking(player, entity));
    }

    public static void onStopEntityTracking(Entity entity, Player player) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.StopTracking(player, entity));
    }

    public static void firePlayerLoadingEvent(Player player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.LoadFromFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerSavingEvent(Player player, File playerDirectory, String uuidString) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.SaveToFile(player, playerDirectory, uuidString));
    }

    public static void firePlayerLoadingEvent(Player player, PlayerDataStorage playerFileData, String uuidString) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.LoadFromFile(player, playerFileData.getPlayerDataFolder(), uuidString));
    }

    @Nullable
    public static Component onClientChat(ChatType type, Component message, @Nullable UUID senderUUID) {
        ClientChatReceivedEvent event = new ClientChatReceivedEvent(type, message, senderUUID);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? null : event.getMessage();
    }

    @Nonnull
    public static String onClientSendMessage(String message) {
        ClientChatEvent event = new ClientChatEvent(message);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? "" : event.getMessage();
    }

    @Deprecated
    public static int onHoeUse(UseOnContext context) {
        UseHoeEvent event = new UseHoeEvent(context);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), player -> player.m_21190_(context.m_43724_()));
            return 1;
        }
        return 0;
    }

    @Nullable
    public static BlockState onToolUse(BlockState originalState, Level world, BlockPos pos, Player player, ItemStack stack, ToolAction toolAction) {
        BlockEvent.BlockToolInteractEvent event = new BlockEvent.BlockToolInteractEvent((LevelAccessor)world, pos, originalState, player, stack, toolAction);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? null : event.getFinalState();
    }

    public static int onApplyBonemeal(@Nonnull Player player, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ItemStack stack) {
        BonemealEvent event = new BonemealEvent(player, world, pos, state, stack);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!world.f_46443_) {
                stack.m_41774_(1);
            }
            return 1;
        }
        return 0;
    }

    @Nullable
    public static InteractionResultHolder<ItemStack> onBucketUse(@Nonnull Player player, @Nonnull Level world, @Nonnull ItemStack stack, @Nullable HitResult target) {
        FillBucketEvent event = new FillBucketEvent(player, stack, world, target);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (player.m_150110_().f_35937_) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
            }
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)event.getFilledBucket());
            }
            if (!player.m_150109_().m_36054_(event.getFilledBucket())) {
                player.m_36176_(event.getFilledBucket(), false);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return null;
    }

    public static boolean canEntityUpdate(Entity entity) {
        EntityEvent.CanUpdate event = new EntityEvent.CanUpdate(entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getCanUpdate();
    }

    public static PlaySoundAtEntityEvent onPlaySoundAtEntity(Entity entity, SoundEvent name, SoundSource category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = new PlaySoundAtEntityEvent(entity, name, category, volume, pitch);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static int onItemExpire(ItemEntity entity, @Nonnull ItemStack item) {
        if (item.m_41619_()) {
            return -1;
        }
        ItemExpireEvent event = new ItemExpireEvent(entity, item.m_41619_() ? 6000 : item.m_41720_().getEntityLifespan(item, entity.f_19853_));
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getExtraLife();
    }

    public static int onItemPickup(ItemEntity entityItem, Player player) {
        EntityItemPickupEvent event = new EntityItemPickupEvent(player, entityItem);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getResult() == Event.Result.ALLOW ? 1 : 0;
    }

    public static boolean canMountEntity(Entity entityMounting, Entity entityBeingMounted, boolean isMounting) {
        boolean isCanceled = MinecraftForge.EVENT_BUS.post((Event)new EntityMountEvent(entityMounting, entityBeingMounted, entityMounting.f_19853_, isMounting));
        if (isCanceled) {
            entityMounting.m_19890_(entityMounting.m_20185_(), entityMounting.m_20186_(), entityMounting.m_20189_(), entityMounting.f_19859_, entityMounting.f_19860_);
            return false;
        }
        return true;
    }

    public static boolean onAnimalTame(Animal animal, Player tamer) {
        return MinecraftForge.EVENT_BUS.post((Event)new AnimalTameEvent(animal, tamer));
    }

    public static Player.BedSleepingProblem onPlayerSleepInBed(Player player, Optional<BlockPos> pos) {
        PlayerSleepInBedEvent event = new PlayerSleepInBedEvent(player, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResultStatus();
    }

    public static void onPlayerWakeup(Player player, boolean wakeImmediately, boolean updateWorldFlag) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerWakeUpEvent(player, wakeImmediately, updateWorldFlag));
    }

    public static void onPlayerFall(Player player, float distance, float multiplier) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerFlyableFallEvent(player, distance, multiplier));
    }

    public static boolean onPlayerSpawnSet(Player player, ResourceKey<Level> world, BlockPos pos, boolean forced) {
        return MinecraftForge.EVENT_BUS.post((Event)new PlayerSetSpawnEvent(player, world, pos, forced));
    }

    public static void onPlayerClone(Player player, Player oldPlayer, boolean wasDeath) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.Clone(player, oldPlayer, wasDeath));
    }

    public static boolean onExplosionStart(Level world, Explosion explosion) {
        return MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Start(world, explosion));
    }

    public static void onExplosionDetonate(Level world, Explosion explosion, List<Entity> list, double diameter) {
        MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Detonate(world, explosion, list));
    }

    public static boolean onCreateWorldSpawn(Level world, ServerLevelData settings) {
        return MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.CreateSpawnPosition((LevelAccessor)world, settings));
    }

    public static float onLivingHeal(LivingEntity entity, float amount) {
        LivingHealEvent event = new LivingHealEvent(entity, amount);
        return MinecraftForge.EVENT_BUS.post((Event)event) ? 0.0f : event.getAmount();
    }

    public static boolean onPotionAttemptBrew(NonNullList<ItemStack> stacks) {
        NonNullList tmp = NonNullList.m_122780_((int)stacks.size(), (Object)ItemStack.f_41583_);
        for (int x = 0; x < tmp.size(); ++x) {
            tmp.set(x, (Object)((ItemStack)stacks.get(x)).m_41777_());
        }
        PotionBrewEvent.Pre event = new PotionBrewEvent.Pre((NonNullList<ItemStack>)tmp);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            boolean changed = false;
            for (int x = 0; x < stacks.size(); ++x) {
                changed |= ItemStack.m_41728_((ItemStack)((ItemStack)tmp.get(x)), (ItemStack)((ItemStack)stacks.get(x)));
                stacks.set(x, (Object)event.getItem(x));
            }
            if (changed) {
                ForgeEventFactory.onPotionBrewed(stacks);
            }
            return true;
        }
        return false;
    }

    public static void onPotionBrewed(NonNullList<ItemStack> brewingItemStacks) {
        MinecraftForge.EVENT_BUS.post((Event)new PotionBrewEvent.Post(brewingItemStacks));
    }

    public static void onPlayerBrewedPotion(Player player, ItemStack stack) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerBrewedPotionEvent(player, stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderFireOverlay(Player player, PoseStack mat) {
        return ForgeEventFactory.renderBlockOverlay(player, mat, RenderBlockOverlayEvent.OverlayType.FIRE, Blocks.f_50083_.m_49966_(), player.m_142538_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderWaterOverlay(Player player, PoseStack mat) {
        return ForgeEventFactory.renderBlockOverlay(player, mat, RenderBlockOverlayEvent.OverlayType.WATER, Blocks.f_49990_.m_49966_(), player.m_142538_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean renderBlockOverlay(Player player, PoseStack mat, RenderBlockOverlayEvent.OverlayType type, BlockState block, BlockPos pos) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderBlockOverlayEvent(player, mat, type, block, pos));
    }

    @Nullable
    public static <T extends ICapabilityProvider> CapabilityDispatcher gatherCapabilities(Class<? extends T> type, T provider) {
        return ForgeEventFactory.gatherCapabilities(type, provider, null);
    }

    @Nullable
    public static <T extends ICapabilityProvider> CapabilityDispatcher gatherCapabilities(Class<? extends T> type, T provider, @Nullable ICapabilityProvider parent) {
        return ForgeEventFactory.gatherCapabilities(new AttachCapabilitiesEvent<T>(type, provider), parent);
    }

    @Nullable
    private static CapabilityDispatcher gatherCapabilities(AttachCapabilitiesEvent<?> event, @Nullable ICapabilityProvider parent) {
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCapabilities().size() > 0 || parent != null ? new CapabilityDispatcher(event.getCapabilities(), event.getListeners(), parent) : null;
    }

    public static boolean fireSleepingLocationCheck(LivingEntity player, BlockPos sleepingLocation) {
        SleepingLocationCheckEvent evt = new SleepingLocationCheckEvent(player, sleepingLocation);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            return player.m_21257_().map(pos -> {
                BlockState state = player.f_19853_.m_8055_(pos);
                return state.m_60734_().isBed(state, (BlockGetter)player.f_19853_, pos, (Entity)player);
            }).orElse(false);
        }
        return canContinueSleep == Event.Result.ALLOW;
    }

    public static boolean fireSleepingTimeCheck(Player player, Optional<BlockPos> sleepingLocation) {
        SleepingTimeCheckEvent evt = new SleepingTimeCheckEvent(player, sleepingLocation);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        Event.Result canContinueSleep = evt.getResult();
        if (canContinueSleep == Event.Result.DEFAULT) {
            return !player.f_19853_.m_46461_();
        }
        return canContinueSleep == Event.Result.ALLOW;
    }

    public static InteractionResultHolder<ItemStack> onArrowNock(ItemStack item, Level world, Player player, InteractionHand hand, boolean hasAmmo) {
        ArrowNockEvent event = new ArrowNockEvent(player, item, hand, world, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        return event.getAction();
    }

    public static int onArrowLoose(ItemStack stack, Level world, Player player, int charge, boolean hasAmmo) {
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, hasAmmo);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return -1;
        }
        return event.getCharge();
    }

    public static boolean onProjectileImpact(Projectile projectile, HitResult ray) {
        return MinecraftForge.EVENT_BUS.post((Event)new ProjectileImpactEvent(projectile, ray));
    }

    public static LootTable loadLootTable(ResourceLocation name, LootTable table, LootTables lootTableManager) {
        LootTableLoadEvent event = new LootTableLoadEvent(name, table, lootTableManager);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return LootTable.f_79105_;
        }
        return event.getTable();
    }

    public static boolean canCreateFluidSource(LevelReader world, BlockPos pos, BlockState state, boolean def) {
        BlockEvent.CreateFluidSourceEvent evt = new BlockEvent.CreateFluidSourceEvent(world, pos, state);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        Event.Result result = evt.getResult();
        return result == Event.Result.DEFAULT ? def : result == Event.Result.ALLOW;
    }

    public static Optional<PortalShape> onTrySpawnPortal(LevelAccessor world, BlockPos pos, Optional<PortalShape> size) {
        if (!size.isPresent()) {
            return size;
        }
        return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.PortalSpawnEvent(world, pos, world.m_8055_(pos), size.get())) ? size : Optional.empty();
    }

    public static int onEnchantmentLevelSet(Level world, BlockPos pos, int enchantRow, int power, ItemStack itemStack, int level) {
        EnchantmentLevelSetEvent e = new EnchantmentLevelSetEvent(world, pos, enchantRow, power, itemStack, level);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.getLevel();
    }

    public static boolean onEntityDestroyBlock(LivingEntity entity, BlockPos pos, BlockState state) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingDestroyBlockEvent(entity, pos, state));
    }

    public static boolean getMobGriefingEvent(Level world, Entity entity) {
        EntityMobGriefingEvent event = new EntityMobGriefingEvent(entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        Event.Result result = event.getResult();
        return result == Event.Result.DEFAULT ? world.m_46469_().m_46207_(GameRules.f_46132_) : result == Event.Result.ALLOW;
    }

    public static boolean saplingGrowTree(LevelAccessor world, Random rand, BlockPos pos) {
        SaplingGrowTreeEvent event = new SaplingGrowTreeEvent(world, rand, pos);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getResult() != Event.Result.DENY;
    }

    public static void fireChunkWatch(boolean watch, ServerPlayer entity, ChunkPos chunkpos, ServerLevel world) {
        if (watch) {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.Watch(entity, chunkpos, world));
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new ChunkWatchEvent.UnWatch(entity, chunkpos, world));
        }
    }

    public static void fireChunkWatch(boolean wasLoaded, boolean load, ServerPlayer entity, ChunkPos chunkpos, ServerLevel world) {
        if (wasLoaded != load) {
            ForgeEventFactory.fireChunkWatch(load, entity, chunkpos, world);
        }
    }

    public static boolean onPistonMovePre(Level world, BlockPos pos, Direction direction, boolean extending) {
        return MinecraftForge.EVENT_BUS.post((Event)new PistonEvent.Pre(world, pos, direction, extending ? PistonEvent.PistonMoveType.EXTEND : PistonEvent.PistonMoveType.RETRACT));
    }

    public static boolean onPistonMovePost(Level world, BlockPos pos, Direction direction, boolean extending) {
        return MinecraftForge.EVENT_BUS.post((Event)new PistonEvent.Post(world, pos, direction, extending ? PistonEvent.PistonMoveType.EXTEND : PistonEvent.PistonMoveType.RETRACT));
    }

    public static long onSleepFinished(ServerLevel world, long newTime, long minTime) {
        SleepFinishedTimeEvent event = new SleepFinishedTimeEvent(world, newTime, minTime);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewTime();
    }

    public static List<PreparableReloadListener> onResourceReload(ServerResources dataPackRegistries) {
        AddReloadListenerEvent event = new AddReloadListenerEvent(dataPackRegistries);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getListeners();
    }

    public static void onCommandRegister(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        RegisterCommandsEvent event = new RegisterCommandsEvent(dispatcher, environment);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static EntityEvent.Size getEntitySizeForge(Entity entity, Pose pose, EntityDimensions size, float eyeHeight) {
        EntityEvent.Size evt = new EntityEvent.Size(entity, pose, size, eyeHeight);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static EntityEvent.Size getEntitySizeForge(Entity entity, Pose pose, EntityDimensions oldSize, EntityDimensions newSize, float newEyeHeight) {
        EntityEvent.Size evt = new EntityEvent.Size(entity, pose, oldSize, newSize, entity.m_20192_(), newEyeHeight);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt;
    }

    public static boolean canLivingConvert(LivingEntity entity, EntityType<? extends LivingEntity> outcome, Consumer<Integer> timer) {
        return !MinecraftForge.EVENT_BUS.post((Event)new LivingConversionEvent.Pre(entity, outcome, timer));
    }

    public static void onLivingConvert(LivingEntity entity, LivingEntity outcome) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingConversionEvent.Post(entity, outcome));
    }

    public static EntityTeleportEvent.TeleportCommand onEntityTeleportCommand(Entity entity, double targetX, double targetY, double targetZ) {
        EntityTeleportEvent.TeleportCommand event = new EntityTeleportEvent.TeleportCommand(entity, targetX, targetY, targetZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static EntityTeleportEvent.SpreadPlayersCommand onEntityTeleportSpreadPlayersCommand(Entity entity, double targetX, double targetY, double targetZ) {
        EntityTeleportEvent.SpreadPlayersCommand event = new EntityTeleportEvent.SpreadPlayersCommand(entity, targetX, targetY, targetZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static EntityTeleportEvent.EnderEntity onEnderTeleport(LivingEntity entity, double targetX, double targetY, double targetZ) {
        EntityTeleportEvent.EnderEntity event = new EntityTeleportEvent.EnderEntity(entity, targetX, targetY, targetZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static EntityTeleportEvent.EnderPearl onEnderPearlLand(ServerPlayer entity, double targetX, double targetY, double targetZ, ThrownEnderpearl pearlEntity, float attackDamage) {
        EntityTeleportEvent.EnderPearl event = new EntityTeleportEvent.EnderPearl(entity, targetX, targetY, targetZ, pearlEntity, attackDamage);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static EntityTeleportEvent.ChorusFruit onChorusFruitTeleport(LivingEntity entity, double targetX, double targetY, double targetZ) {
        EntityTeleportEvent.ChorusFruit event = new EntityTeleportEvent.ChorusFruit(entity, targetX, targetY, targetZ);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public static boolean onPermissionChanged(GameProfile gameProfile, int newLevel, PlayerList playerList) {
        int oldLevel = playerList.m_7873_().m_129944_(gameProfile);
        ServerPlayer player = playerList.m_11259_(gameProfile.getId());
        if (newLevel != oldLevel && player != null) {
            return MinecraftForge.EVENT_BUS.post((Event)new PermissionsChangedEvent(player, newLevel, oldLevel));
        }
        return false;
    }
}

