/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class LivingSpawnEvent
extends LivingEvent {
    private final LevelAccessor world;
    private final double x;
    private final double y;
    private final double z;

    public LivingSpawnEvent(Mob entity, LevelAccessor world, double x, double y, double z) {
        super((LivingEntity)entity);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Event.HasResult
    public static class AllowDespawn
    extends LivingSpawnEvent {
        public AllowDespawn(Mob entity) {
            super(entity, (LevelAccessor)entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        }
    }

    @Cancelable
    public static class SpecialSpawn
    extends LivingSpawnEvent {
        @Nullable
        private final BaseSpawner spawner;
        private final MobSpawnType spawnReason;

        public SpecialSpawn(Mob entity, Level world, double x, double y, double z, @Nullable BaseSpawner spawner, MobSpawnType spawnReason) {
            super(entity, (LevelAccessor)world, x, y, z);
            this.spawner = spawner;
            this.spawnReason = spawnReason;
        }

        @Nullable
        public BaseSpawner getSpawner() {
            return this.spawner;
        }

        public MobSpawnType getSpawnReason() {
            return this.spawnReason;
        }
    }

    @Event.HasResult
    public static class CheckSpawn
    extends LivingSpawnEvent {
        @Nullable
        private final BaseSpawner spawner;
        private final MobSpawnType spawnReason;

        public CheckSpawn(Mob entity, LevelAccessor world, double x, double y, double z, @Nullable BaseSpawner spawner, MobSpawnType spawnReason) {
            super(entity, world, x, y, z);
            this.spawner = spawner;
            this.spawnReason = spawnReason;
        }

        public boolean isSpawner() {
            return this.spawner != null;
        }

        @Nullable
        public BaseSpawner getSpawner() {
            return this.spawner;
        }

        public MobSpawnType getSpawnReason() {
            return this.spawnReason;
        }
    }
}

