/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmlclient;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.DataPackConfig;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.ModWorkManager;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fmlclient.EarlyLoaderGUI;
import net.minecraftforge.fmlclient.gui.screen.LoadingErrorScreen;
import net.minecraftforge.fmllegacy.BrandingControl;
import net.minecraftforge.fmllegacy.CrashReportExtender;
import net.minecraftforge.fmllegacy.LogicalSidedProvider;
import net.minecraftforge.fmllegacy.packs.DelegatingResourcePack;
import net.minecraftforge.fmllegacy.packs.ResourcePackLoader;
import net.minecraftforge.fmllegacy.server.LanguageHook;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathResourcePack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ClientModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean loading;
    private static Minecraft mc;
    private static boolean loadingComplete;
    private static LoadingFailedException error;
    private static EarlyLoaderGUI earlyLoaderGUI;

    public static void begin(Minecraft minecraft, PackRepository defaultResourcePacks, ReloadableResourceManager mcResourceManager, ClientPackSource metadataSerializer) {
        Runtime.getRuntime().addShutdownHook(new Thread(LogManager::shutdown));
        loading = true;
        mc = minecraft;
        LogicalSidedProvider.setClient(() -> minecraft);
        LanguageHook.loadForgeAndMCLangs();
        earlyLoaderGUI = new EarlyLoaderGUI(minecraft);
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().gatherAndInitializeMods(ModWorkManager.syncExecutor(), ModWorkManager.parallelExecutor(), (Runnable)new SpacedRunnable(earlyLoaderGUI::renderTick))).run();
        if (error == null) {
            ResourcePackLoader.loadResourcePacks(defaultResourcePacks, ClientModLoader::buildPackFinder);
            ModLoader.get().postEvent((Event)new AddPackFindersEvent(PackType.CLIENT_RESOURCES, arg_0 -> ((PackRepository)defaultResourcePacks).addPackFinder(arg_0)));
            DataPackConfig.f_45842_.addModPacks(ResourcePackLoader.getPackNames());
            mcResourceManager.m_7217_(ClientModLoader::onResourceReload);
            mcResourceManager.m_7217_((PreparableReloadListener)BrandingControl.resourceManagerReloadListener());
            ModelLoaderRegistry.init();
        }
    }

    private static CompletableFuture<Void> onResourceReload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller executeProfiler, Executor asyncExecutor, Executor syncExecutor) {
        return ((CompletableFuture)CompletableFuture.runAsync(ClientModLoader.createRunnableWithCatch(() -> ClientModLoader.startModLoading(ModWorkManager.wrappedExecutor((Executor)syncExecutor), asyncExecutor)), ModWorkManager.parallelExecutor()).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenRunAsync(() -> ClientModLoader.finishModLoading(ModWorkManager.wrappedExecutor((Executor)syncExecutor), asyncExecutor), ModWorkManager.parallelExecutor());
    }

    private static Runnable createRunnableWithCatch(Runnable r) {
        return () -> {
            block3: {
                if (loadingComplete) {
                    return;
                }
                try {
                    r.run();
                }
                catch (LoadingFailedException e) {
                    if (error != null) break block3;
                    error = e;
                }
            }
        };
    }

    private static void startModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        earlyLoaderGUI.handleElsewhere();
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().loadMods(syncExecutor, parallelExecutor, (Runnable)new SpacedRunnable(earlyLoaderGUI::renderTick))).run();
    }

    private static void finishModLoading(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor) {
        ClientModLoader.createRunnableWithCatch(() -> ModLoader.get().finishMods(syncExecutor, parallelExecutor, (Runnable)new SpacedRunnable(earlyLoaderGUI::renderTick))).run();
        loading = false;
        loadingComplete = true;
        syncExecutor.execute(() -> ClientModLoader.mc.f_91066_.m_92140_());
    }

    public static VersionChecker.Status checkForUpdates() {
        boolean anyOutdated = ModList.get().getMods().stream().map(VersionChecker::getResult).map(result -> result.status()).anyMatch(status -> status == VersionChecker.Status.OUTDATED || status == VersionChecker.Status.BETA_OUTDATED);
        return anyOutdated ? VersionChecker.Status.OUTDATED : null;
    }

    public static boolean completeModLoading() {
        RenderSystem.m_69472_();
        RenderSystem.m_69493_();
        List<ModLoadingWarning> warnings = ModLoader.get().getWarnings();
        boolean showWarnings = true;
        try {
            showWarnings = (Boolean)ForgeConfig.CLIENT.showLoadWarnings.get();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (!showWarnings) {
            if (!warnings.isEmpty()) {
                LOGGER.warn(Logging.LOADING, "Mods loaded with {} warning(s)", (Object)warnings.size());
                warnings.forEach(warning -> LOGGER.warn(Logging.LOADING, warning.formatToString()));
            }
            warnings = Collections.emptyList();
        }
        File dumpedLocation = null;
        if (error == null) {
            MinecraftForge.EVENT_BUS.start();
        } else {
            LanguageHook.loadForgeAndMCLangs();
            dumpedLocation = CrashReportExtender.dumpModLoadingCrashReport(LOGGER, error, ClientModLoader.mc.f_91069_);
        }
        if (error != null || !warnings.isEmpty()) {
            mc.m_91152_((Screen)new LoadingErrorScreen(error, warnings, dumpedLocation));
            return true;
        }
        return false;
    }

    public static void renderProgressText() {
        earlyLoaderGUI.renderFromGUI();
    }

    public static boolean isLoading() {
        return loading;
    }

    private static RepositorySource buildPackFinder(Map<IModFile, ? extends PathResourcePack> modResourcePacks) {
        return (packList, factory) -> ClientModLoader.clientPackFinder(modResourcePacks, packList, factory);
    }

    private static void clientPackFinder(Map<IModFile, ? extends PathResourcePack> modResourcePacks, Consumer<Pack> consumer, Pack.PackConstructor factory) {
        ArrayList<PathResourcePack> hiddenPacks = new ArrayList<PathResourcePack>();
        for (Map.Entry<IModFile, ? extends PathResourcePack> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            String name = "mod:" + mod.getModId();
            Pack packInfo = Pack.m_10430_((String)name, (boolean)false, e::getValue, (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (packInfo == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            if (mod.getOwningFile().showAsResourcePack()) {
                consumer.accept(packInfo);
                continue;
            }
            hiddenPacks.add(e.getValue());
        }
        Pack packInfo = Pack.m_10430_((String)"mod_resources", (boolean)true, () -> new DelegatingResourcePack("mod_resources", "Mod Resources", new PackMetadataSection((Component)new TranslatableComponent("fml.resources.modresources", new Object[]{hiddenPacks.size()}), PackType.CLIENT_RESOURCES.m_143756_(SharedConstants.m_136187_())), hiddenPacks), (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
        consumer.accept(packInfo);
    }

    private static class SpacedRunnable
    implements Runnable {
        static final long NANO_SLEEP_TIME = TimeUnit.MILLISECONDS.toNanos(50L);
        private final Runnable wrapped;
        private long lastRun;

        private SpacedRunnable(Runnable wrapped) {
            this.wrapped = wrapped;
            this.lastRun = System.nanoTime() - NANO_SLEEP_TIME;
        }

        @Override
        public void run() {
            if (System.nanoTime() - this.lastRun > NANO_SLEEP_TIME) {
                this.wrapped.run();
                this.lastRun = System.nanoTime();
            }
        }
    }
}

