/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmlclient.gui.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fmlclient.ConfigGuiHandler;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import net.minecraftforge.fmlclient.gui.widget.ModListWidget;
import net.minecraftforge.fmllegacy.ForgeI18n;
import net.minecraftforge.fmllegacy.MavenVersionStringHelper;
import net.minecraftforge.fmllegacy.packs.ResourcePackLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.resource.PathResourcePack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModListScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int PADDING = 6;
    private Screen parentScreen;
    private ModListWidget modList;
    private InfoPanel modInfo;
    private ModListWidget.ModEntry selected = null;
    private int listWidth;
    private List<IModInfo> mods;
    private final List<IModInfo> unsortedMods;
    private Button configButton;
    private Button openModsFolderButton;
    private Button doneButton;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private EditBox search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    private static String stripControlCodes(String value) {
        return StringUtil.m_14406_((String)value);
    }

    public ModListScreen(Screen parentScreen) {
        super((Component)new TranslatableComponent("fml.menu.mods.title"));
        this.parentScreen = parentScreen;
        this.mods = Collections.unmodifiableList(ModList.get().getMods());
        this.unsortedMods = Collections.unmodifiableList(this.mods);
    }

    public void m_7856_() {
        for (IModInfo mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().m_92895_(mod.getDisplayName()) + 10);
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().m_92895_(MavenVersionStringHelper.artifactVersionToString(mod.getVersion())) + 5);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.f_96543_ / 3), 100);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        int modInfoWidth = this.f_96543_ - this.listWidth - 18;
        int doneButtonWidth = Math.min(modInfoWidth, 200);
        int y = this.f_96544_ - 20 - 6;
        int fullButtonHeight = 32;
        this.doneButton = new Button((this.listWidth + 6 + this.f_96543_ - doneButtonWidth) / 2, y, doneButtonWidth, 20, (Component)new TranslatableComponent("gui.done"), b -> this.m_7379_());
        this.openModsFolderButton = new Button(6, y, this.listWidth, 20, (Component)new TranslatableComponent("fml.menu.mods.openmodsfolder"), b -> Util.m_137581_().m_137644_(FMLPaths.MODSDIR.get().toFile()));
        this.configButton = new Button(6, y -= 26, this.listWidth, 20, (Component)new TranslatableComponent("fml.menu.mods.config"), b -> this.displayModConfig());
        this.search = new EditBox(this.getFontRenderer(), 7, y -= 20, this.listWidth - 2, 14, (Component)new TranslatableComponent("fml.menu.mods.search"));
        int n = this.search.f_93621_;
        Objects.requireNonNull(this.getFontRenderer());
        this.modList = new ModListWidget(this, this.listWidth, fullButtonHeight, n - 9 - 6);
        this.modList.m_93507_(6);
        this.modInfo = new InfoPanel(this.f_96541_, modInfoWidth, this.f_96544_ - 6 - fullButtonHeight, 6);
        this.m_142416_((GuiEventListener)this.modList);
        this.m_142416_((GuiEventListener)this.modInfo);
        this.m_142416_((GuiEventListener)this.search);
        this.m_142416_((GuiEventListener)this.doneButton);
        this.m_142416_((GuiEventListener)this.configButton);
        this.m_142416_((GuiEventListener)this.openModsFolderButton);
        this.search.m_94178_(false);
        this.search.m_94190_(true);
        this.configButton.f_93623_ = false;
        int width = this.listWidth / this.numButtons;
        int x = 6;
        SortType.NORMAL.button = new Button(x, 6, width - this.buttonMargin, 20, SortType.NORMAL.getButtonText(), b -> this.resortMods(SortType.NORMAL));
        this.m_142416_((GuiEventListener)SortType.NORMAL.button);
        SortType.A_TO_Z.button = new Button(x += width + this.buttonMargin, 6, width - this.buttonMargin, 20, SortType.A_TO_Z.getButtonText(), b -> this.resortMods(SortType.A_TO_Z));
        this.m_142416_((GuiEventListener)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = new Button(x += width + this.buttonMargin, 6, width - this.buttonMargin, 20, SortType.Z_TO_A.getButtonText(), b -> this.resortMods(SortType.Z_TO_A));
        this.m_142416_((GuiEventListener)SortType.Z_TO_A.button);
        this.resortMods(SortType.NORMAL);
        this.updateCache();
    }

    private void displayModConfig() {
        if (this.selected == null) {
            return;
        }
        try {
            ConfigGuiHandler.getGuiFactoryFor(this.selected.getInfo()).map(f -> (Screen)f.apply(this.f_96541_, this)).ifPresent(newScreen -> this.f_96541_.m_91152_(newScreen));
        }
        catch (Exception e) {
            LOGGER.error("There was a critical issue trying to build the config GUI for {}", (Object)this.selected.getInfo().getModId(), (Object)e);
        }
    }

    public void m_96624_() {
        this.search.m_94120_();
        this.modList.m_6987_((AbstractSelectionList.Entry)this.selected);
        if (!this.search.m_94155_().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.mods.sort(this.sortType);
            this.modList.refreshList();
            if (this.selected != null) {
                this.selected = this.modList.m_6702_().stream().filter(e -> e.getInfo() == this.selected.getInfo()).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildModList(Consumer<T> modListViewConsumer, Function<IModInfo, T> newEntry) {
        this.mods.forEach(mod -> modListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((IModInfo)mod)));
    }

    private void reloadMods() {
        this.mods = this.unsortedMods.stream().filter(mi -> StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(mi.getDisplayName())).contains(StringUtils.toLowerCase((String)this.search.m_94155_()))).collect(Collectors.toList());
        this.lastFilterText = this.search.m_94155_();
    }

    private void resortMods(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.f_93623_ = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void m_6305_(PoseStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.modList.m_6305_(mStack, mouseX, mouseY, partialTicks);
        if (this.modInfo != null) {
            this.modInfo.m_6305_(mStack, mouseX, mouseY, partialTicks);
        }
        TranslatableComponent text = new TranslatableComponent("fml.menu.mods.search");
        int x = this.modList.getLeft() + (this.modList.getRight() - this.modList.getLeft()) / 2 - this.getFontRenderer().m_92852_((FormattedText)text) / 2;
        this.search.m_6305_(mStack, mouseX, mouseY, partialTicks);
        super.m_6305_(mStack, mouseX, mouseY, partialTicks);
        Font font = this.getFontRenderer();
        FormattedCharSequence formattedCharSequence = text.m_7532_();
        float f = x;
        int n = this.search.f_93621_;
        Objects.requireNonNull(this.getFontRenderer());
        font.m_92877_(mStack, formattedCharSequence, f, (float)(n - 9), 0xFFFFFF);
    }

    public Minecraft getMinecraftInstance() {
        return this.f_96541_;
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public void setSelected(ModListWidget.ModEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selected == null) {
            this.configButton.f_93623_ = false;
            this.modInfo.clearInfo();
            return;
        }
        final IModInfo selectedMod = this.selected.getInfo();
        this.configButton.f_93623_ = ConfigGuiHandler.getGuiFactoryFor(selectedMod).isPresent();
        ArrayList<String> lines = new ArrayList<String>();
        VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)selectedMod);
        Pair logoData = selectedMod.getLogoFile().map(logoFile -> {
            TextureManager tm = this.f_96541_.m_91097_();
            PathResourcePack resourcePack = ResourcePackLoader.getPackFor(selectedMod.getModId()).orElse(ResourcePackLoader.getPackFor("forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try {
                NativeImage logo = null;
                InputStream logoResource = resourcePack.m_5542_((String)logoFile);
                if (logoResource != null) {
                    logo = NativeImage.m_85058_((InputStream)logoResource);
                }
                if (logo != null) {
                    return Pair.of((Object)tm.m_118490_("modlogo", new DynamicTexture(logo){

                        public void m_117985_() {
                            this.m_117966_();
                            NativeImage td = this.m_117991_();
                            this.m_117991_().m_85013_(0, 0, 0, 0, 0, td.m_84982_(), td.m_85084_(), selectedMod.getLogoBlur(), false, false, false);
                        }
                    }), (Object)new Size2i(logo.m_84982_(), logo.m_85084_()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Pair.of(null, (Object)new Size2i(0, 0));
        }).orElse(Pair.of(null, (Object)new Size2i(0, 0)));
        lines.add(selectedMod.getDisplayName());
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.version", MavenVersionStringHelper.artifactVersionToString(selectedMod.getVersion())));
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.idstate", selectedMod.getModId(), ModList.get().getModContainerById(selectedMod.getModId()).map(ModContainer::getCurrentState).map(Object::toString).orElse("NONE")));
        selectedMod.getConfig().getConfigElement(new String[]{"credits"}).ifPresent(credits -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.credits", credits)));
        selectedMod.getConfig().getConfigElement(new String[]{"authors"}).ifPresent(authors -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.authors", authors)));
        selectedMod.getConfig().getConfigElement(new String[]{"displayURL"}).ifPresent(displayURL -> lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.displayurl", displayURL)));
        if (selectedMod.getOwningFile() == null || selectedMod.getOwningFile().getMods().size() == 1) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.nochildmods", new Object[0]));
        } else {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.childmods", selectedMod.getOwningFile().getMods().stream().map(IModInfo::getDisplayName).collect(Collectors.joining(","))));
        }
        if (vercheck.status() == VersionChecker.Status.OUTDATED || vercheck.status() == VersionChecker.Status.BETA_OUTDATED) {
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.updateavailable", vercheck.url() == null ? "" : vercheck.url()));
        }
        lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.license", selectedMod.getOwningFile().getLicense()));
        lines.add(null);
        lines.add(selectedMod.getDescription());
        if ((vercheck.status() == VersionChecker.Status.OUTDATED || vercheck.status() == VersionChecker.Status.BETA_OUTDATED) && vercheck.changes().size() > 0) {
            lines.add(null);
            lines.add(ForgeI18n.parseMessage("fml.menu.mods.info.changelogheader", new Object[0]));
            for (Map.Entry entry : vercheck.changes().entrySet()) {
                lines.add("  " + entry.getKey() + ":");
                lines.add((String)entry.getValue());
                lines.add(null);
            }
        }
        this.modInfo.setInfo(lines, (ResourceLocation)logoData.getLeft(), (Size2i)logoData.getRight());
    }

    public void m_6574_(Minecraft mc, int width, int height) {
        String s = this.search.m_94155_();
        SortType sort = this.sortType;
        ModListWidget.ModEntry selected = this.selected;
        this.m_6575_(mc, width, height);
        this.search.m_94144_(s);
        this.selected = selected;
        if (!this.search.m_94155_().isEmpty()) {
            this.reloadMods();
        }
        if (sort != SortType.NORMAL) {
            this.resortMods(sort);
        }
        this.updateCache();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    private static enum SortType implements Comparator<IModInfo>
    {
        NORMAL,
        A_TO_Z{

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A{

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        Button button;

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(IModInfo o1, IModInfo o2) {
            String name1 = StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(o1.getDisplayName()));
            String name2 = StringUtils.toLowerCase((String)ModListScreen.stripControlCodes(o2.getDisplayName()));
            return this.compare(name1, name2);
        }

        Component getButtonText() {
            return new TranslatableComponent("fml.menu.mods." + StringUtils.toLowerCase((String)this.name()));
        }
    }

    class InfoPanel
    extends ScrollPanel {
        private ResourceLocation logoPath;
        private Size2i logoDims;
        private List<FormattedCharSequence> lines;

        InfoPanel(Minecraft mcIn, int widthIn, int heightIn, int topIn) {
            super(mcIn, widthIn, heightIn, topIn, ModListScreen.this.modList.getRight() + 6);
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        void setInfo(List<String> lines, ResourceLocation logoPath, Size2i logoDims) {
            this.logoPath = logoPath;
            this.logoDims = logoDims;
            this.lines = this.resizeContent(lines);
        }

        void clearInfo() {
            this.logoPath = null;
            this.logoDims = new Size2i(0, 0);
            this.lines = Collections.emptyList();
        }

        private List<FormattedCharSequence> resizeContent(List<String> lines) {
            ArrayList<FormattedCharSequence> ret = new ArrayList<FormattedCharSequence>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                Component chat = ForgeHooks.newChatWithLinks(line, false);
                int maxTextLength = this.width - 12;
                if (maxTextLength < 0) continue;
                ret.addAll(Language.m_128107_().m_128112_(ModListScreen.this.f_96547_.m_92865_().m_92414_((FormattedText)chat, maxTextLength, Style.f_131099_)));
            }
            return ret;
        }

        @Override
        public int getContentHeight() {
            int height = 50;
            int n = this.lines.size();
            Objects.requireNonNull(ModListScreen.this.f_96547_);
            if ((height += n * 9) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        @Override
        protected int getScrollAmount() {
            Objects.requireNonNull(ModListScreen.this.f_96547_);
            return 9 * 3;
        }

        @Override
        protected void drawPanel(PoseStack mStack, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            if (this.logoPath != null) {
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.logoPath);
                int headerHeight = 50;
                GuiUtils.drawInscribedRect(mStack, this.left + 6, relativeY, this.width - 12, headerHeight, this.logoDims.width, this.logoDims.height, false, true);
                relativeY += headerHeight + 6;
            }
            for (FormattedCharSequence line : this.lines) {
                if (line != null) {
                    RenderSystem.m_69478_();
                    ModListScreen.this.f_96547_.m_92744_(mStack, line, (float)(this.left + 6), (float)relativeY, 0xFFFFFF);
                    RenderSystem.m_69461_();
                }
                Objects.requireNonNull(ModListScreen.this.f_96547_);
                relativeY += 9;
            }
            Style component = this.findTextLine(mouseX, mouseY);
            if (component != null) {
                ModListScreen.this.m_96570_(mStack, component, mouseX, mouseY);
            }
        }

        private Style findTextLine(int mouseX, int mouseY) {
            if (!this.m_5953_(mouseX, mouseY)) {
                return null;
            }
            double offset = (float)(mouseY - this.top + 4) + this.scrollDistance + 1.0f;
            if (this.logoPath != null) {
                offset -= 50.0;
            }
            if (offset <= 0.0) {
                return null;
            }
            Objects.requireNonNull(ModListScreen.this.f_96547_);
            int lineIdx = (int)(offset / 9.0);
            if (lineIdx >= this.lines.size() || lineIdx < 1) {
                return null;
            }
            FormattedCharSequence line = this.lines.get(lineIdx - 1);
            if (line != null) {
                return ModListScreen.this.f_96547_.m_92865_().m_92338_(line, mouseX - this.left - 4);
            }
            return null;
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Style component = this.findTextLine((int)mouseX, (int)mouseY);
            if (component != null) {
                ModListScreen.this.m_5561_(component);
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        protected void drawBackground() {
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }
}

