/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmlclient.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fmlclient.gui.screen.ModListScreen;
import net.minecraftforge.fmllegacy.MavenVersionStringHelper;
import net.minecraftforge.forgespi.language.IModInfo;

public class ModListWidget
extends ObjectSelectionList<ModEntry> {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final int listWidth;
    private ModListScreen parent;

    private static String stripControlCodes(String value) {
        return StringUtil.m_14406_((String)value);
    }

    public ModListWidget(ModListScreen parent, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getMinecraftInstance();
        int n = parent.f_96544_;
        Objects.requireNonNull(parent.getFontRenderer());
        super(minecraft, listWidth, n, top, bottom, 9 * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int m_5756_() {
        return this.listWidth;
    }

    public int m_5759_() {
        return this.listWidth;
    }

    public void refreshList() {
        this.m_93516_();
        this.parent.buildModList(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0), mod -> new ModEntry((IModInfo)mod, this.parent));
    }

    protected void m_7733_(PoseStack mStack) {
        this.parent.m_7333_(mStack);
    }

    public class ModEntry
    extends ObjectSelectionList.Entry<ModEntry> {
        private final IModInfo modInfo;
        private final ModListScreen parent;

        ModEntry(IModInfo info, ModListScreen parent) {
            this.modInfo = info;
            this.parent = parent;
        }

        public Component m_142172_() {
            return new TranslatableComponent("narrator.select", new Object[]{this.modInfo.getDisplayName()});
        }

        public void m_6311_(PoseStack pStack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            TextComponent name = new TextComponent(ModListWidget.stripControlCodes(this.modInfo.getDisplayName()));
            TextComponent version = new TextComponent(ModListWidget.stripControlCodes(MavenVersionStringHelper.artifactVersionToString(this.modInfo.getVersion())));
            VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)this.modInfo);
            Font font = this.parent.getFontRenderer();
            font.m_92877_(pStack, Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_((FormattedText)name, ModListWidget.this.listWidth)})), (float)(left + 3), (float)(top + 2), 0xFFFFFF);
            FormattedCharSequence formattedCharSequence = Language.m_128107_().m_5536_(FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_((FormattedText)version, ModListWidget.this.listWidth)}));
            float f = left + 3;
            Objects.requireNonNull(font);
            font.m_92877_(pStack, formattedCharSequence, f, (float)(top + 2 + 9), 0xCCCCCC);
            if (vercheck.status().shouldDraw()) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)VERSION_CHECK_ICONS);
                pStack.m_85836_();
                GuiComponent.m_93133_((PoseStack)pStack, (int)(ModListWidget.this.getLeft() + ModListWidget.this.f_93388_ - 12), (int)(top + entryHeight / 4), (float)(vercheck.status().getSheetOffset() * 8), (float)(vercheck.status().isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f), (int)8, (int)8, (int)64, (int)16);
                pStack.m_85849_();
            }
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.setSelected(this);
            ModListWidget.this.m_6987_((AbstractSelectionList.Entry)this);
            return false;
        }

        public IModInfo getInfo() {
            return this.modInfo;
        }
    }
}

