/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmlclient.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.fmlclient.gui.GuiUtils;
import net.minecraftforge.fmlclient.gui.widget.ExtendedButton;

public class Slider
extends ExtendedButton {
    public double sliderValue = 1.0;
    public Component dispString;
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    @Nullable
    public ISlider parent = null;
    public Component suffix;
    public boolean drawString = true;

    public Slider(int xPos, int yPos, int width, int height, Component prefix, Component suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Button.OnPress handler) {
        this(xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, handler, null);
    }

    public Slider(int xPos, int yPos, int width, int height, Component prefix, Component suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Button.OnPress handler, @Nullable ISlider par) {
        super(xPos, yPos, width, height, prefix, handler);
        String val;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.sliderValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.dispString = prefix;
        this.parent = par;
        this.suffix = suf;
        this.showDecimal = showDec;
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        this.m_93666_((Component)new TextComponent("").m_7220_(this.dispString).m_130946_(val).m_7220_(this.suffix));
        this.drawString = drawStr;
        if (!this.drawString) {
            this.m_93666_((Component)new TextComponent(""));
        }
    }

    public Slider(int xPos, int yPos, Component displayStr, double minVal, double maxVal, double currentVal, Button.OnPress handler, ISlider par) {
        this(xPos, yPos, 150, 20, displayStr, (Component)new TextComponent(""), minVal, maxVal, currentVal, true, true, handler, par);
    }

    public int m_7202_(boolean par1) {
        return 0;
    }

    protected void m_7906_(PoseStack mStack, Minecraft par1Minecraft, int par2, int par3) {
        if (this.f_93624_) {
            if (this.dragging) {
                this.sliderValue = (float)(par2 - (this.f_93620_ + 4)) / (float)(this.f_93618_ - 8);
                this.updateSlider();
            }
            GuiUtils.drawContinuousTexturedBox(mStack, f_93617_, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)), this.f_93621_, 0, 66, 8, this.f_93619_, 200, 20, 2, 3, 2, 2, this.m_93252_());
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.sliderValue = (mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8);
        this.updateSlider();
        this.dragging = true;
    }

    public void updateSlider() {
        Object val;
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (((String)val).substring(((String)val).indexOf(".") + 1).length() > this.precision) {
                if (((String)(val = ((String)val).substring(0, ((String)val).indexOf(".") + this.precision + 1))).endsWith(".")) {
                    val = ((String)val).substring(0, ((String)val).indexOf(".") + this.precision);
                }
            } else {
                while (((String)val).substring(((String)val).indexOf(".") + 1).length() < this.precision) {
                    val = (String)val + "0";
                }
            }
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawString) {
            this.m_93666_((Component)new TextComponent("").m_7220_(this.dispString).m_130946_((String)val).m_7220_(this.suffix));
        }
        if (this.parent != null) {
            this.parent.onChangeSliderValue(this);
        }
    }

    public void m_7691_(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    public static interface ISlider {
        public void onChangeSliderValue(Slider var1);
    }
}

