/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.Varint21FrameDecoder;
import net.minecraft.network.Varint21LengthFieldPrepender;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraftforge.fmllegacy.common.network.ByteBufUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketLoggingHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void register(Connection manager) {
        ChannelPipeline pipeline = manager.channel().pipeline();
        final PacketFlow direction = manager.getDirection();
        if (manager.m_129531_()) {
            pipeline.addBefore("packet_handler", "splitter", (ChannelHandler)new SimpleChannelInboundHandler<Packet<?>>(){
                String prefix;
                {
                    this.prefix = direction == PacketFlow.SERVERBOUND ? "SERVER: C->S" : "CLIENT: S->C";
                }

                protected void channelRead0(ChannelHandlerContext ctx, Packet<?> msg) throws Exception {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                    msg.m_5779_(buf);
                    LOGGER.debug("{} {}:\n{}", (Object)this.prefix, (Object)msg.getClass().getSimpleName(), (Object)ByteBufUtils.getContentDump((ByteBuf)buf));
                    ctx.fireChannelRead(msg);
                }
            });
            pipeline.addBefore("splitter", "prepender", (ChannelHandler)new ChannelOutboundHandlerAdapter(){
                String prefix;
                {
                    this.prefix = direction == PacketFlow.SERVERBOUND ? "SERVER: S->C" : "CLIENT: C->S";
                }

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg instanceof Packet) {
                        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                        ((Packet)msg).m_5779_(buf);
                        LOGGER.debug("{} {}:\n{}", (Object)this.prefix, (Object)msg.getClass().getSimpleName(), (Object)ByteBufUtils.getContentDump((ByteBuf)buf));
                    }
                    ctx.write(msg, promise);
                }
            });
        } else {
            pipeline.replace("splitter", "splitter", (ChannelHandler)new Varint21FrameDecoder(){
                String prefix;
                {
                    this.prefix = direction == PacketFlow.SERVERBOUND ? "SERVER: C->S" : "CLIENT: S->C";
                }

                protected void decode(ChannelHandlerContext context, ByteBuf input, List<Object> output) {
                    super.decode(context, input, output);
                    for (ByteBuf byteBuf : output) {
                        byteBuf.markReaderIndex();
                        LOGGER.debug("{}:\n{}", (Object)this.prefix, (Object)ByteBufUtils.getContentDump(byteBuf));
                        byteBuf.resetReaderIndex();
                    }
                }
            });
            pipeline.replace("prepender", "prepender", (ChannelHandler)new Varint21LengthFieldPrepender(){
                String prefix;
                {
                    this.prefix = direction == PacketFlow.SERVERBOUND ? "SERVER: S->C" : "CLIENT: C->S";
                }

                protected void encode(ChannelHandlerContext context, ByteBuf input, ByteBuf output) {
                    input.markReaderIndex();
                    LOGGER.debug("{}:\n{}", (Object)this.prefix, (Object)ByteBufUtils.getContentDump(input));
                    input.resetReaderIndex();
                    super.encode(context, input, output);
                }
            });
        }
    }
}

