/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.hooks;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class BasicEventHooks {
    public static void firePlayerChangedDimensionEvent(Player player, ResourceKey<Level> fromDim, ResourceKey<Level> toDim) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.PlayerChangedDimensionEvent(player, fromDim, toDim));
    }

    public static void firePlayerLoggedIn(Player player) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.PlayerLoggedInEvent(player));
    }

    public static void firePlayerLoggedOut(Player player) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.PlayerLoggedOutEvent(player));
    }

    public static void firePlayerRespawnEvent(Player player, boolean endConquered) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.PlayerRespawnEvent(player, endConquered));
    }

    public static void firePlayerItemPickupEvent(Player player, ItemEntity item, ItemStack clone) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemPickupEvent(player, item, clone));
    }

    public static void firePlayerCraftingEvent(Player player, ItemStack crafted, Container craftMatrix) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemCraftedEvent(player, crafted, craftMatrix));
    }

    public static void firePlayerSmeltedEvent(Player player, ItemStack smelted) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEvent.ItemSmeltedEvent(player, smelted));
    }

    public static void onRenderTickStart(float timer) {
        Animation.setClientPartialTickTime(timer);
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.RenderTickEvent(TickEvent.Phase.START, timer));
    }

    public static void onRenderTickEnd(float timer) {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.RenderTickEvent(TickEvent.Phase.END, timer));
    }

    public static void onPlayerPreTick(Player player) {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.PlayerTickEvent(TickEvent.Phase.START, player));
    }

    public static void onPlayerPostTick(Player player) {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.PlayerTickEvent(TickEvent.Phase.END, player));
    }

    public static void onPreWorldTick(Level world) {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.WorldTickEvent(LogicalSide.SERVER, TickEvent.Phase.START, world));
    }

    public static void onPostWorldTick(Level world) {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.WorldTickEvent(LogicalSide.SERVER, TickEvent.Phase.END, world));
    }

    public static void onPreClientTick() {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.ClientTickEvent(TickEvent.Phase.START));
    }

    public static void onPostClientTick() {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.ClientTickEvent(TickEvent.Phase.END));
    }

    public static void onPreServerTick() {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.ServerTickEvent(TickEvent.Phase.START));
    }

    public static void onPostServerTick() {
        MinecraftForge.EVENT_BUS.post((Event)new TickEvent.ServerTickEvent(TickEvent.Phase.END));
    }
}

