/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.fmllegacy.network.ConnectionType;
import net.minecraftforge.fmllegacy.network.FMLConnectionData;
import net.minecraftforge.fmllegacy.network.FMLHandshakeHandler;
import net.minecraftforge.fmllegacy.network.FMLMCRegisterPacketHandler;
import net.minecraftforge.fmllegacy.network.FMLNetworkConstants;
import net.minecraftforge.fmllegacy.network.FMLPlayMessages;
import net.minecraftforge.fmllegacy.network.ICustomPacket;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkInstance;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.network.NetworkFilters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHooks {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String getFMLVersion(String ip) {
        return ip.contains("\u0000") ? (Objects.equals(ip.split("\u0000")[1], "FML2") ? "FML2" : ip.split("\u0000")[1]) : "NONE";
    }

    public static ConnectionType getConnectionType(Supplier<Connection> connection) {
        return NetworkHooks.getConnectionType(connection.get().channel());
    }

    public static ConnectionType getConnectionType(ChannelHandlerContext context) {
        return NetworkHooks.getConnectionType(context.channel());
    }

    private static ConnectionType getConnectionType(Channel channel) {
        return ConnectionType.forVersionFlag((String)channel.attr(FMLNetworkConstants.FML_NETVERSION).get());
    }

    public static Packet<?> getEntitySpawningPacket(Entity entity) {
        return FMLNetworkConstants.playChannel.toVanillaPacket(new FMLPlayMessages.SpawnEntity(entity), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static boolean onCustomPayload(ICustomPacket<?> packet, Connection manager) {
        return NetworkRegistry.findTarget(packet.getName()).filter(ni -> NetworkHooks.validateSideForProcessing(packet, ni, manager)).map(ni -> ni.dispatch(packet.getDirection(), packet, manager)).orElse(Boolean.FALSE);
    }

    private static boolean validateSideForProcessing(ICustomPacket<?> packet, NetworkInstance ni, Connection manager) {
        if (packet.getDirection().getReceptionSide() != EffectiveSide.get()) {
            manager.m_129507_((Component)new TextComponent("Illegal packet received, terminating connection"));
            return false;
        }
        return true;
    }

    public static void validatePacketDirection(NetworkDirection packetDirection, Optional<NetworkDirection> expectedDirection, Connection connection) {
        if (packetDirection != expectedDirection.orElse(packetDirection)) {
            connection.m_129507_((Component)new TextComponent("Illegal packet received, terminating connection"));
            throw new IllegalStateException("Invalid packet received, aborting connection");
        }
    }

    public static void registerServerLoginChannel(Connection manager, ClientIntentionPacket packet) {
        manager.channel().attr(FMLNetworkConstants.FML_NETVERSION).set((Object)packet.getFMLVersion());
        FMLHandshakeHandler.registerHandshake(manager, NetworkDirection.LOGIN_TO_CLIENT);
    }

    public static synchronized void registerClientLoginChannel(Connection manager) {
        manager.channel().attr(FMLNetworkConstants.FML_NETVERSION).set((Object)"NONE");
        FMLHandshakeHandler.registerHandshake(manager, NetworkDirection.LOGIN_TO_SERVER);
    }

    public static synchronized void sendMCRegistryPackets(Connection manager, String direction) {
        NetworkFilters.injectIfNecessary(manager);
        Set<ResourceLocation> resourceLocations = NetworkRegistry.buildChannelVersions().keySet().stream().filter(rl -> !Objects.equals(rl.m_135827_(), "minecraft")).collect(Collectors.toSet());
        FMLMCRegisterPacketHandler.INSTANCE.addChannels(resourceLocations, manager);
        FMLMCRegisterPacketHandler.INSTANCE.sendRegistry(manager, NetworkDirection.valueOf(direction));
    }

    public static boolean isVanillaConnection(Connection manager) {
        if (manager == null || manager.channel() == null) {
            throw new NullPointerException("ARGH! Network Manager is null (" + manager != null ? "CHANNEL" : "MANAGER)");
        }
        return NetworkHooks.getConnectionType(() -> manager) == ConnectionType.VANILLA;
    }

    public static void handleClientLoginSuccess(Connection manager) {
        if (NetworkHooks.isVanillaConnection(manager)) {
            LOGGER.info("Connected to a vanilla server. Catching up missing behaviour.");
            ConfigTracker.INSTANCE.loadDefaultServerConfigs();
        } else {
            LOGGER.info("Connected to a modded server.");
        }
    }

    public static boolean tickNegotiation(ServerLoginPacketListenerImpl netHandlerLoginServer, Connection networkManager, ServerPlayer player) {
        return FMLHandshakeHandler.tickLogin(networkManager);
    }

    public static void openGui(ServerPlayer player, MenuProvider containerSupplier) {
        NetworkHooks.openGui(player, containerSupplier, (FriendlyByteBuf buf) -> {});
    }

    public static void openGui(ServerPlayer player, MenuProvider containerSupplier, BlockPos pos) {
        NetworkHooks.openGui(player, containerSupplier, (FriendlyByteBuf buf) -> buf.m_130064_(pos));
    }

    public static void openGui(ServerPlayer player, MenuProvider containerSupplier, Consumer<FriendlyByteBuf> extraDataWriter) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        player.m_9230_();
        player.m_9217_();
        int openContainerId = player.f_8940_;
        FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.buffer());
        extraDataWriter.accept(extraData);
        extraData.readerIndex(0);
        FriendlyByteBuf output = new FriendlyByteBuf(Unpooled.buffer());
        output.m_130130_(extraData.readableBytes());
        output.writeBytes((ByteBuf)extraData);
        if (output.readableBytes() > 32600 || output.readableBytes() < 1) {
            throw new IllegalArgumentException("Invalid PacketBuffer for openGui, found " + output.readableBytes() + " bytes");
        }
        AbstractContainerMenu c = containerSupplier.m_7208_(openContainerId, player.m_150109_(), (Player)player);
        MenuType type = c.m_6772_();
        FMLPlayMessages.OpenContainer msg = new FMLPlayMessages.OpenContainer(type, openContainerId, containerSupplier.m_5446_(), output);
        FMLNetworkConstants.playChannel.sendTo(msg, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        player.f_36096_ = c;
        player.m_143399_(player.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, c));
    }

    @Nullable
    public static FMLConnectionData getConnectionData(Connection mgr) {
        return (FMLConnectionData)mgr.channel().attr(FMLNetworkConstants.FML_CONNECTION_DATA).get();
    }
}

