/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;

public abstract class VanillaPacketFilter
extends MessageToMessageEncoder<Packet<?>> {
    protected final Map<Class<? extends Packet<?>>, BiConsumer<Packet<?>, List<? super Packet<?>>>> handlers;

    protected VanillaPacketFilter(Map<Class<? extends Packet<?>>, BiConsumer<Packet<?>, List<? super Packet<?>>>> handlers) {
        this.handlers = handlers;
    }

    @Nonnull
    protected static <T extends Packet<?>> Map.Entry<Class<? extends Packet<?>>, BiConsumer<Packet<?>, List<? super Packet<?>>>> handler(Class<T> cls, Function<T, ? extends Packet<?>> function) {
        return VanillaPacketFilter.handler(cls, (Packet<?> pkt, List<? super Packet<?>> list) -> list.add(function.apply((Packet)cls.cast(pkt))));
    }

    @Nonnull
    protected static <T extends Packet<?>> Map.Entry<Class<? extends Packet<?>>, BiConsumer<Packet<?>, List<? super Packet<?>>>> handler(Class<T> cls, BiConsumer<Packet<?>, List<? super Packet<?>>> consumer) {
        return new AbstractMap.SimpleEntry(cls, consumer);
    }

    protected abstract boolean isNecessary(Connection var1);

    protected void encode(ChannelHandlerContext ctx, Packet<?> msg, List<Object> out) {
        BiConsumer<Packet, List> consumer = this.handlers.getOrDefault(msg.getClass(), (pkt, list) -> list.add(pkt));
        consumer.accept(msg, out);
    }
}

