/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.MappedRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class NamespacedWrapper<T extends IForgeRegistryEntry<T>>
extends MappedRegistry<T>
implements ILockableRegistry {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean locked = false;
    private ForgeRegistry<T> delegate;

    public NamespacedWrapper(ForgeRegistry<T> owner) {
        super(owner.getRegistryKey(), Lifecycle.experimental());
        this.delegate = owner;
    }

    public <V extends T> V registerMapping(int id, ResourceKey<T> key, V value, Lifecycle lifecycle) {
        int realId;
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Validate.notNull(value);
        if (value.getRegistryName() == null) {
            value.setRegistryName(key.m_135782_());
        }
        if ((realId = this.delegate.add(id, value)) != id && id != -1) {
            LOGGER.warn("Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", key, (Object)value.getRegistryType().getName(), (Object)id, (Object)realId);
        }
        return value;
    }

    public <R extends T> R register(ResourceKey<T> key, R value, Lifecycle lifecycle) {
        return this.registerMapping(-1, key, value, lifecycle);
    }

    public <V extends T> V registerOrOverride(OptionalInt id, ResourceKey<T> key, V value, Lifecycle lifecycle) {
        int wanted = -1;
        if (id.isPresent() && this.byId(id.getAsInt()) != null) {
            wanted = id.getAsInt();
        }
        return this.registerMapping(wanted, key, value, lifecycle);
    }

    @Nullable
    public T get(@Nullable ResourceLocation name) {
        return this.delegate.getRaw(name);
    }

    public Optional<T> m_6612_(@Nullable ResourceLocation name) {
        return Optional.ofNullable(this.delegate.getRaw(name));
    }

    @Nullable
    public T get(@Nullable ResourceKey<T> name) {
        return name == null ? null : (T)this.delegate.getRaw(name.m_135782_());
    }

    @Nullable
    public ResourceLocation getKey(T value) {
        return this.delegate.getKey(value);
    }

    public boolean m_7804_(ResourceLocation key) {
        return this.delegate.containsKey(key);
    }

    public int getId(@Nullable T value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public T byId(int id) {
        return this.delegate.getValue(id);
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Set<ResourceLocation> m_6566_() {
        return this.delegate.getKeys();
    }

    public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
        return this.delegate.getEntries();
    }

    @Nullable
    public T getRandom(Random random) {
        Collection<T> values = this.delegate.getValues();
        return (T)((IForgeRegistryEntry)values.stream().skip(random.nextInt(values.size())).findFirst().orElse(null));
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    public static class Factory<V extends IForgeRegistryEntry<V>>
    implements IForgeRegistry.CreateCallback<V> {
        public static final ResourceLocation ID = new ResourceLocation("forge", "registry_defaulted_wrapper");

        @Override
        public void onCreate(IForgeRegistryInternal<V> owner, RegistryManager stage) {
            owner.setSlaveMap(ID, new NamespacedWrapper((ForgeRegistry)owner));
        }
    }
}

