/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.asm;

import java.util.Objects;
import java.util.Optional;
import org.cadixdev.bombe.asm.jar.ClassProvider;
import org.cadixdev.bombe.type.FieldType;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.FieldMapping;
import org.cadixdev.lorenz.model.jar.FieldTypeProvider;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class AsmFieldTypeProvider
implements FieldTypeProvider {
    private final ClassProvider classProvider;

    public AsmFieldTypeProvider(ClassProvider classProvider) {
        this.classProvider = classProvider;
    }

    public Optional<FieldType> provide(FieldMapping mapping) {
        String owner = ((ClassMapping)mapping.getParent()).getFullObfuscatedName();
        ClassNode node = this.classProvider.getAsNode(owner);
        if (node == null) {
            return Optional.empty();
        }
        Optional<FieldNode> fieldNode = node.fields.stream().filter(field -> Objects.equals(field.name, mapping.getObfuscatedName())).findAny();
        if (fieldNode.isPresent()) {
            FieldType type = FieldType.of((String)fieldNode.get().desc);
            return Optional.of(type);
        }
        return Optional.empty();
    }
}

