/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.lorenz.asm;

import org.cadixdev.bombe.analysis.InheritanceProvider;
import org.cadixdev.bombe.type.signature.FieldSignature;
import org.cadixdev.bombe.type.signature.MethodSignature;
import org.cadixdev.lorenz.MappingSet;
import org.cadixdev.lorenz.model.ClassMapping;
import org.cadixdev.lorenz.model.Mapping;
import org.objectweb.asm.commons.Remapper;

public class LorenzRemapper
extends Remapper {
    private final MappingSet mappings;
    private final InheritanceProvider inheritanceProvider;

    public LorenzRemapper(MappingSet mappings, InheritanceProvider inheritanceProvider) {
        this.mappings = mappings;
        this.inheritanceProvider = inheritanceProvider;
    }

    public String map(String typeName) {
        return this.mappings.computeClassMapping(typeName).map(Mapping::getFullDeobfuscatedName).orElse(typeName);
    }

    public String mapInnerClassName(String name, String ownerName, String innerName) {
        return this.mappings.computeClassMapping(name).map(Mapping::getDeobfuscatedName).orElse(innerName);
    }

    private ClassMapping<?, ?> getCompletedClassMapping(String owner) {
        ClassMapping mapping = this.mappings.getOrCreateClassMapping(owner);
        mapping.complete(this.inheritanceProvider);
        return mapping;
    }

    public String mapFieldName(String owner, String name, String desc) {
        return this.getCompletedClassMapping(owner).computeFieldMapping(FieldSignature.of((String)name, (String)desc)).map(Mapping::getDeobfuscatedName).orElse(name);
    }

    public String mapMethodName(String owner, String name, String desc) {
        return this.getCompletedClassMapping(owner).getMethodMapping(MethodSignature.of((String)name, (String)desc)).map(Mapping::getDeobfuscatedName).orElse(name);
    }
}

