/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.jimfs.Directory;
import com.google.common.jimfs.DirectoryEntry;
import com.google.common.jimfs.RegularFile;
import com.google.common.jimfs.SymbolicLink;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class File {
    private final int id;
    private int links;
    private long creationTime;
    private long lastAccessTime;
    private long lastModifiedTime;
    @NullableDecl
    private Table<String, String, Object> attributes;

    File(int id) {
        long now;
        this.id = id;
        this.creationTime = now = System.currentTimeMillis();
        this.lastAccessTime = now;
        this.lastModifiedTime = now;
    }

    public int id() {
        return this.id;
    }

    public long size() {
        return 0L;
    }

    public final boolean isDirectory() {
        return this instanceof Directory;
    }

    public final boolean isRegularFile() {
        return this instanceof RegularFile;
    }

    public final boolean isSymbolicLink() {
        return this instanceof SymbolicLink;
    }

    abstract File copyWithoutContent(int var1);

    void copyContentTo(File file) throws IOException {
    }

    @NullableDecl
    ReadWriteLock contentLock() {
        return null;
    }

    void opened() {
    }

    void closed() {
    }

    void deleted() {
    }

    final boolean isRootDirectory() {
        return this.isDirectory() && this.equals(((Directory)this).parent());
    }

    public final synchronized int links() {
        return this.links;
    }

    void linked(DirectoryEntry entry) {
        Preconditions.checkNotNull(entry);
    }

    void unlinked() {
    }

    final synchronized void incrementLinkCount() {
        ++this.links;
    }

    final synchronized void decrementLinkCount() {
        --this.links;
    }

    public final synchronized long getCreationTime() {
        return this.creationTime;
    }

    public final synchronized long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final synchronized long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    final synchronized void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    final synchronized void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    final synchronized void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    final void updateAccessTime() {
        this.setLastAccessTime(System.currentTimeMillis());
    }

    final void updateModifiedTime() {
        this.setLastModifiedTime(System.currentTimeMillis());
    }

    public final synchronized ImmutableSet<String> getAttributeNames(String view) {
        if (this.attributes == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(this.attributes.row(view).keySet());
    }

    @VisibleForTesting
    final synchronized ImmutableSet<String> getAttributeKeys() {
        if (this.attributes == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Table.Cell<String, String, Object> cell : this.attributes.cellSet()) {
            String string = cell.getRowKey();
            String string2 = cell.getColumnKey();
            builder.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(':').append(string2).toString());
        }
        return builder.build();
    }

    @NullableDecl
    public final synchronized Object getAttribute(String view, String attribute) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(view, attribute);
    }

    public final synchronized void setAttribute(String view, String attribute, Object value) {
        if (this.attributes == null) {
            this.attributes = HashBasedTable.create();
        }
        this.attributes.put(view, attribute, value);
    }

    public final synchronized void deleteAttribute(String view, String attribute) {
        if (this.attributes != null) {
            this.attributes.remove(view, attribute);
        }
    }

    final synchronized void copyBasicAttributes(File target) {
        target.setFileTimes(this.creationTime, this.lastModifiedTime, this.lastAccessTime);
    }

    private synchronized void setFileTimes(long creationTime, long lastModifiedTime, long lastAccessTime) {
        this.creationTime = creationTime;
        this.lastModifiedTime = lastModifiedTime;
        this.lastAccessTime = lastAccessTime;
    }

    final synchronized void copyAttributes(File target) {
        this.copyBasicAttributes(target);
        target.putAll(this.attributes);
    }

    private synchronized void putAll(@NullableDecl Table<String, String, Object> attributes) {
        if (attributes != null && this.attributes != attributes) {
            if (this.attributes == null) {
                this.attributes = HashBasedTable.create();
            }
            this.attributes.putAll(attributes);
        }
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id()).toString();
    }
}

