/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jimfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.jimfs.FileSystemView;
import com.google.common.jimfs.JimfsFileStore;
import com.google.common.jimfs.JimfsFileSystemProvider;
import com.google.common.jimfs.JimfsPath;
import com.google.common.jimfs.Name;
import com.google.common.jimfs.PathService;
import com.google.common.jimfs.UserLookupService;
import com.google.common.jimfs.WatchServiceConfiguration;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

final class JimfsFileSystem
extends FileSystem {
    private final JimfsFileSystemProvider provider;
    private final URI uri;
    private final JimfsFileStore fileStore;
    private final PathService pathService;
    private final UserPrincipalLookupService userLookupService = new UserLookupService(true);
    private final FileSystemView defaultView;
    private final WatchServiceConfiguration watchServiceConfig;
    @NullableDecl
    private ExecutorService defaultThreadPool;

    JimfsFileSystem(JimfsFileSystemProvider provider, URI uri, JimfsFileStore fileStore, PathService pathService, FileSystemView defaultView, WatchServiceConfiguration watchServiceConfig) {
        this.provider = Preconditions.checkNotNull(provider);
        this.uri = Preconditions.checkNotNull(uri);
        this.fileStore = Preconditions.checkNotNull(fileStore);
        this.pathService = Preconditions.checkNotNull(pathService);
        this.defaultView = Preconditions.checkNotNull(defaultView);
        this.watchServiceConfig = Preconditions.checkNotNull(watchServiceConfig);
    }

    @Override
    public JimfsFileSystemProvider provider() {
        return this.provider;
    }

    public URI getUri() {
        return this.uri;
    }

    public FileSystemView getDefaultView() {
        return this.defaultView;
    }

    @Override
    public String getSeparator() {
        return this.pathService.getSeparator();
    }

    public ImmutableSortedSet<Path> getRootDirectories() {
        ImmutableSortedSet.Builder<JimfsPath> builder = ImmutableSortedSet.orderedBy(this.pathService);
        for (Name name : this.fileStore.getRootDirectoryNames()) {
            builder.add((Object)this.pathService.createRoot(name));
        }
        return builder.build();
    }

    public JimfsPath getWorkingDirectory() {
        return this.defaultView.getWorkingDirectoryPath();
    }

    @VisibleForTesting
    PathService getPathService() {
        return this.pathService;
    }

    public JimfsFileStore getFileStore() {
        return this.fileStore;
    }

    public ImmutableSet<FileStore> getFileStores() {
        this.fileStore.state().checkOpen();
        return ImmutableSet.of(this.fileStore);
    }

    public ImmutableSet<String> supportedFileAttributeViews() {
        return this.fileStore.supportedFileAttributeViews();
    }

    @Override
    public JimfsPath getPath(String first, String ... more) {
        this.fileStore.state().checkOpen();
        return this.pathService.parsePath(first, more);
    }

    public URI toUri(JimfsPath path) {
        this.fileStore.state().checkOpen();
        return this.pathService.toUri(this.uri, path.toAbsolutePath());
    }

    public JimfsPath toPath(URI uri) {
        this.fileStore.state().checkOpen();
        return this.pathService.fromUri(uri);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        this.fileStore.state().checkOpen();
        return this.pathService.createPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        this.fileStore.state().checkOpen();
        return this.userLookupService;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.watchServiceConfig.newWatchService(this.defaultView, this.pathService);
    }

    public synchronized ExecutorService getDefaultThreadPool() {
        if (this.defaultThreadPool == null) {
            String string = this.uri.getHost();
            this.defaultThreadPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(new StringBuilder(37 + String.valueOf(string).length()).append("JimfsFileSystem-").append(string).append("-defaultThreadPool-%s").toString()).build());
            this.fileStore.state().register(new Closeable(){

                @Override
                public void close() {
                    JimfsFileSystem.this.defaultThreadPool.shutdown();
                }
            });
        }
        return this.defaultThreadPool;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.fileStore.state().isOpen();
    }

    @Override
    public void close() throws IOException {
        this.fileStore.state().close();
    }
}

